/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Defines and manages the physical location of coordinate system data files
 *
 */
 public class MgCoordinateSystemCatalog extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemCatalog(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemCatalogToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemCatalog() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemCatalog(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemCatalog obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Sets the default dictionary path and file names
 *
 */
 public void SetDefaultDictionaryDirAndFileNames() throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemCatalog_SetDefaultDictionaryDirAndFileNames(swigCPtr);
  }

  
/**
 * Gets the default dictionary path
 *
 * @return  The default dictionary path
 */
 public String GetDefaultDictionaryDir() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetDefaultDictionaryDir(swigCPtr); }
}

  
/**
 * Sets the path where the dictionary files are located
 *
 */
 public void SetDictionaryDir(String sDirPath) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemCatalog_SetDictionaryDir(swigCPtr, sDirPath);
  }

  
/**
 * Gets the current dictionary path
 *
 * @return  The current dictionary path
 */
 public String GetDictionaryDir() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetDictionaryDir(swigCPtr); }
}

  
/**
 * Returns the default directory path where user defined coordinate system
 * definitions can be found or can be written into, respectively.
 * If set, this method returns the value of the MENTOR_USER_DICTIONARY_PATH
 *
 */
 public String GetDefaultUserDictionaryDir() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetDefaultUserDictionaryDir(swigCPtr); }
}

  
/**
 * Sets the actual directory where user defined coordinate system
 * definitions can be found or can be written into. The directory set through this method must exist
 * and writeable. If set to an empty string, the catalog's 'user defined coordinate system' directory
 * will be unset and any updates will again happen only inside the directory
 * as returned by GetDictionaryDir().
 *
 */
 public void SetUserDictionaryDir(String sDirPath) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemCatalog_SetUserDictionaryDir(swigCPtr, sDirPath);
  }

  
/**
 * Returns the current directory where user defined coordinate system
 * definitions is obtained from or is written into. Returns an empty string
 * if no such directory is currently configured for this catalog.
 *
 */
 public String GetUserDictionaryDir() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetUserDictionaryDir(swigCPtr); }
}

  
/**
 * Sets the protection mode
 *
 * @param  nMode (short/int)  The protection mode
 */
 public void SetProtectionMode(short nMode) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemCatalog_SetProtectionMode(swigCPtr, nMode);
  }

  
/**
 * Gets the protection mode of this catalog
 *
 * @return  The protection mode of this catalog
 */
 public short GetProtectionMode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetProtectionMode(swigCPtr);
  }

  
/**
 * Gets the coordinate system category dictionary
 *
 * @return  The coordinate system category dictionary
 */
 public MgCoordinateSystemCategoryDictionary GetCategoryDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetCategoryDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemCategoryDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system dictionary
 *
 * @return  The coordinate system dictionary
 */
 public MgCoordinateSystemDictionary GetCoordinateSystemDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetCoordinateSystemDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system datum dictionary
 *
 * @return  The coordinate system datum dictionary
 */
 public MgCoordinateSystemDatumDictionary GetDatumDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetDatumDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatumDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system ellipsoid dictionary
 *
 * @return  The coordinate system ellipsoid dictionary
 */
 public MgCoordinateSystemEllipsoidDictionary GetEllipsoidDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetEllipsoidDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemEllipsoidDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system geodetic path dictionary
 *
 * @return  The coordinate system geodetic path dictionary
 */
 public MgCoordinateSystemGeodeticPathDictionary GetGeodeticPathDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetGeodeticPathDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPathDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system geodetic transform definition dictionary
 *
 * @return  The coordinate system geodetic transform definition dictionary
 */
 public MgCoordinateSystemGeodeticTransformDefDictionary GetGeodeticTransformDefDictionary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetGeodeticTransformDefDictionary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDefDictionary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the geodetic transformations for the source and target coordinate system datums
 *
 * @param  pSource ({@link MgCoordinateSystemDatum})  The source coordinate system datum
 * @param  pTarget ({@link MgCoordinateSystemDatum})  The target coordinate system datum
 * @return  The collection of {@link MgCoordinateSystemGeodeticTransformation} objects
 */
 public MgDisposableCollection GetGeodeticTransformations(MgCoordinateSystemDatum pSource, MgCoordinateSystemDatum pTarget) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetGeodeticTransformations(swigCPtr, MgCoordinateSystemDatum.getCPtr(pSource), MgCoordinateSystemDatum.getCPtr(pTarget));
    return (cPtr == 0) ? null : (MgDisposableCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system math comparator
 *
 * @return  The coordinate system math comparator
 */
 public MgCoordinateSystemMathComparator GetMathComparator() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetMathComparator(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemMathComparator)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system format converter
 *
 * @return  The coordinate system format converter
 */
 public MgCoordinateSystemFormatConverter GetFormatConverter() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetFormatConverter(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemFormatConverter)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system projection information
 *
 * @return  The coordinate system projection information
 */
 public MgCoordinateSystemProjectionInformation GetProjectionInformation() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetProjectionInformation(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemProjectionInformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system unit information
 *
 * @return  The coordinate system unit information
 */
 public MgCoordinateSystemUnitInformation GetUnitInformation() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetUnitInformation(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemUnitInformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system dictionary utility
 *
 * @return  The coordinate system dictionary utility
 */
 public MgCoordinateSystemDictionaryUtility GetDictionaryUtility() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemCatalog_GetDictionaryUtility(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDictionaryUtility)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Checks whether any kind of definition supported by this catalog can be updated in the dictionary files currently in use.
 * Depending on whether this catalog uses a specific directory to store user-provided definitions in, this method
 * will perform the following checks:
 *
 * @return  Otherwise false.
 */
 public boolean AreDictionaryFilesWritable() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemCatalog_AreDictionaryFilesWritable(swigCPtr);
  }

}
