/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * An instance of this class describes a geodetic transformation with all its parameters
 * as it is defined in the dictionary file. The actual transformation operation
 * is performed by the {@link MgCoordinateSystemGeodeticTransformation} objects
 * that's being returned by the CreateTransformation method.
 *
 */
 public class MgCoordinateSystemGeodeticTransformDef extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticTransformDef(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemGeodeticTransformDefToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticTransformDef() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemGeodeticTransformDef(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticTransformDef obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the transform name of this instance
 *
 * @return  The transform name of this instance
 */
 public String GetTransformName() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetTransformName(swigCPtr); }
}

  
/**
 * Sets the transform name of this instance
 *
 * @param  name (String/string)  The transform name
 */
 public void SetTransformName(String name) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetTransformName(swigCPtr, name);
  }

  
/**
 * Gets the source datum of this instance
 *
 * @return  The source datum of this instance
 */
 public String GetSourceDatum() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetSourceDatum(swigCPtr); }
}

  
/**
 * Sets the source datum of this instance
 *
 * @param  datumKey (String/string)  The source datum
 */
 public void SetSourceDatum(String datumKey) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetSourceDatum(swigCPtr, datumKey);
  }

  
/**
 * Gets the target datum of this instance
 *
 * @return  The target datum of this instance
 */
 public String GetTargetDatum() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetTargetDatum(swigCPtr); }
}

  
/**
 * Sets the target datum of this instance
 *
 * @param  datumKey (String/string)  The target datum
 */
 public void SetTargetDatum(String datumKey) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetTargetDatum(swigCPtr, datumKey);
  }

  
/**
 * Gets the group of this instance
 *
 * @return  The group of this instance
 */
 public String GetGroup() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this instance
 *
 * @param  group (String/string)  The group
 */
 public void SetGroup(String group) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetGroup(swigCPtr, group);
  }

  
/**
 * Gets the description of this instance
 *
 * @return  The description of this instance
 */
 public String GetDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetDescription(swigCPtr); }
}

  
/**
 * Sets the description of this instance
 *
 * @param  description (String/string)  The description
 */
 public void SetDescription(String description) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetDescription(swigCPtr, description);
  }

  
/**
 * Gets the source of this instance
 *
 * @return  The source of this instance
 */
 public String GetSource() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this instance
 *
 * @param  source (String/string)  The source
 */
 public void SetSource(String source) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetSource(swigCPtr, source);
  }

  
/**
 * Gets the EPSG code of this instance
 *
 * @return  The EPSG code of this instance
 */
 public int GetEpsgCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetEpsgCode(swigCPtr);
  }

  
/**
 * Sets the EPSG code of this instance
 *
 * @param  epsgCode (int)  The EPSG code
 */
 public void SetEpsgCode(int epsgCode) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetEpsgCode(swigCPtr, epsgCode);
  }

  
/**
 * Gets the EPSG variation of this instance
 *
 * @return  The EPSG variation of this instance
 */
 public int GetEpsgVariation() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetEpsgVariation(swigCPtr);
  }

  
/**
 * Sets the EPSG variation of this instance
 *
 * @param  epsgVariation (int)  The EPSG variation
 */
 public void SetEpsgVariation(int epsgVariation) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetEpsgVariation(swigCPtr, epsgVariation);
  }

  
/**
 * Gets whether the inverse is supported
 *
 * @return  true if this inverse is supported. false otherwise
 */
 public boolean GetInverseSupported() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetInverseSupported(swigCPtr);
  }

  
/**
 * Sets whether the inverse is supported
 *
 * @param  inverseSupported (boolean/bool)  true if the inverse is supported. false otherwise
 */
 public void SetInverseSupported(boolean inverseSupported) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetInverseSupported(swigCPtr, inverseSupported);
  }

  
/**
 * Gets the maximum iterations of this instance
 *
 * @return  The maximum iterations of this instance
 */
 public int GetMaxIterations() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetMaxIterations(swigCPtr);
  }

  
/**
 * Sets the maximum iterations of this instance
 *
 * @param  maxIterations (int)  The maximum iterations
 */
 public void SetMaxIterations(int maxIterations) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetMaxIterations(swigCPtr, maxIterations);
  }

  
/**
 * Gets the convergence value of this instance
 *
 * @return  The convergence value of this instance
 */
 public double GetConvergenceValue() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetConvergenceValue(swigCPtr);
  }

  
/**
 * Sets the convergence value of this instance
 *
 * @param  convergenceValue (double)  The convergence value
 */
 public void SetConvergenceValue(double convergenceValue) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetConvergenceValue(swigCPtr, convergenceValue);
  }

  
/**
 * Gets the error value of this instance
 *
 * @return  The error value of this instance
 */
 public double GetErrorValue() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetErrorValue(swigCPtr);
  }

  
/**
 * Sets the error value of this instance
 *
 * @param  errorValue (double)  The error value
 */
 public void SetErrorValue(double errorValue) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetErrorValue(swigCPtr, errorValue);
  }

  
/**
 * Gets the accuracy value of this instance
 *
 * @return  The accuracy value of this instance
 */
 public double GetAccuracy() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetAccuracy(swigCPtr);
  }

  
/**
 * Sets the accuracy value of this instance
 *
 * @param  accuracy (double)  The accuracy value
 */
 public void SetAccuracy(double accuracy) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetAccuracy(swigCPtr, accuracy);
  }

  
/**
 * Gets the minimum range longitude of this instance
 *
 * @return  The minimum range longitude of this instance
 */
 public double GetRangeMinLongitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMinLongitude(swigCPtr);
  }

  
/**
 * Sets the minimum range longitude of this instance
 *
 * @param  minLong (double)  The minimum range longitude
 */
 public void SetRangeMinLongitude(double minLong) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMinLongitude(swigCPtr, minLong);
  }

  
/**
 * Gets the maximum range longitude of this instance
 *
 * @return  The maximum range longitude of this instance
 */
 public double GetRangeMaxLongitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMaxLongitude(swigCPtr);
  }

  
/**
 * Sets the maximum range longitude of this instance
 *
 * @param  maxLong (double)  The maximum range longitude
 */
 public void SetRangeMaxLongitude(double maxLong) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMaxLongitude(swigCPtr, maxLong);
  }

  
/**
 * Gets the minimum range latitude of this instance
 *
 * @return  The minimum range latitude of this instance
 */
 public double GetRangeMinLatitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMinLatitude(swigCPtr);
  }

  
/**
 * Sets the minimum range latitude of this instance
 *
 * @param  minLat (double)  The minimum range latitude
 */
 public void SetRangeMinLatitude(double minLat) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMinLatitude(swigCPtr, minLat);
  }

  
/**
 * Gets the maximum range latitude of this instance
 *
 * @return  The maximum range latitude of this instance
 */
 public double GetRangeMaxLatitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMaxLatitude(swigCPtr);
  }

  
/**
 * Sets the maximum range latitude of this instance
 *
 * @param  maxLat (double)  The maximum range latitude
 */
 public void SetRangeMaxLatitude(double maxLat) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMaxLatitude(swigCPtr, maxLat);
  }

  
/**
 * Gets whether this instance is protected
 *
 * @return  true if this instance is protected. false otherwise
 */
 public boolean IsProtected() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_IsProtected(swigCPtr);
  }

  
/**
 * Gets whether this instance is valid
 *
 * @return  true if this instance is valid. false otherwise
 */
 public boolean IsValid() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_IsValid(swigCPtr);
  }

  
/**
 * Returns the type of this geodetic transformation (as defined by {@link MgCoordinateSystemGeodeticTransformDefType}).
 * The type defines the parameters that are being returned by the GetParameters method.
 *
 */
 public int GetTransformDefType() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetTransformDefType(swigCPtr);
  }

  
/**
 * Returns the extended parameters object valid for this transformation definition. See remarks.
 * Depending on the type returned by GetTransformDefType(), this method returns one of the following:
 *
 * @return  Returns the extended parameters (or NULL) object for this transformation object. The
 *  caller is responsible for disposing the object being returned. See remarks.
 */
 public MgCoordinateSystemGeodeticTransformDefParams GetParameters() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_GetParameters(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDefParams)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the extended parameters for this transformation.
 *
 * @param  parameters  The parameters to set for this transformation. The object passed in,  has to be of the same type as it has been returned by GetParameters. Otherwise,  an exception will be thrown. This parameter must not be NULL. Creating a transformation that  is supposed to do nothing except for allowing to switch from one datum to another (that is considered to be equal),  requires to create standalone transformation of type NullX.
 */
 public void SetParameters(MgCoordinateSystemGeodeticTransformDefParams parameters) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_SetParameters(swigCPtr, MgCoordinateSystemGeodeticTransformDefParams.getCPtr(parameters));
  }

  
/**
 * Creates a deep clone of this geodetic transformation. That is, the cloned object
 * will also have its extended parameters cloned.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticTransformDef} object that is an exact clone
 *  of this {@link MgCoordinateSystemGeodeticTransformDef} instance. The caller is responsible for
 *  disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticTransformDef CreateClone() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDef)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a new {@link MgCoordinateSystemGeodeticTransformation} object that
 * can be used to perform the actual transformation this transformation
 * definition describes. This method will fail with an exception,
 * if this is the NONE transformation.
 *
 * @param  createInverse  If true, the {@link MgCoordinateSystemGeodeticTransformation} being returned will  perform the inverse of the transformation as defined in the dictionary file. That is,  it will convert from the actual target datum to the source datum. Note, that not all  transformations are invertible. This method will fail with an exception then.  If false, this method will return a {@link MgCoordinateSystemGeodeticTransformation}  instance that performs the default forward datum transformation.
 * @return  Returns the {@link MgCoordinateSystemGeodeticTransformation} that performs the actual
 *  datum transformation as described by this definition instance. The caller
 *  is reponsible for disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticTransformation CreateTransformation(boolean createInverse) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformDef_CreateTransformation(swigCPtr, createInverse);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
