package org.osgeo.mapguide;


/**
 * This class contains the constants for all current transformation definition types.
 *
 */
public class MgCoordinateSystemGeodeticTransformDefType
{
   
/**
 * Default 0 constant available for programming convenience only. It does not
 * describe a specific geodetic transformation type.
 *
 */

   public static final int None = 0 ; 
   
/**
 * The transformation definition describes a built-in transformation. That is, that
 * transformation is well-known and cannot be parameterized because
 * the information is available to the transformation engine.
 *
 */

   public static final int Standalone = 1 ; 
   
/**
 * The transformation definition describes an analytical transformation where
 * the transformation between the source and the target datum is defined
 * through a formular that's fed with up to 10 parameters.
 *
 */

   public static final int Analytical = 2 ; 
   
/**
 * The transformation definition describes a transformation that
 * uses grid files to calculate the actual datum shift for a given
 * coordinate by interpolating between given grid points.
 *
 */

   public static final int Interpolation = 3 ; 
   
/**
 * The transformation definition describes a transformation that
 * uses a multiple regression calculation to perform the actual datum shift.
 *
 */

   public static final int MultipleRegression = 4 ; 
   
}

