/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * An instance of this class allow a caller do perform a geodetic transformation (datum shift).
 * That is, this class does not operate on coordinate system level, but rather on
 * datum level.
 *
 */
 public class MgCoordinateSystemGeodeticTransformation extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticTransformation(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemGeodeticTransformationToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticTransformation() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemGeodeticTransformation(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticTransformation obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Sets the source and target datums of this geodetic transformation
 *
 * @param  pSource ({@link MgCoordinateSystemDatum})  The source datum
 * @param  pTarget ({@link MgCoordinateSystemDatum})  The target datum
 */
 public void SetSourceAndTarget(MgCoordinateSystemDatum pSource, MgCoordinateSystemDatum pTarget) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_SetSourceAndTarget(swigCPtr, MgCoordinateSystemDatum.getCPtr(pSource), MgCoordinateSystemDatum.getCPtr(pTarget));
  }

  
/**
 * Gets the source datum of this geodetic transformation
 *
 * @return  The source datum of this geodetic transformation
 */
 public MgCoordinateSystemDatum GetSource() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetSource(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the target datum of this geodetic transformation
 *
 * @return  The target datum of this geodetic transformation
 */
 public MgCoordinateSystemDatum GetTarget() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetTarget(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Shift this datum to the specified coordinate
 *
 * @param  pLonLat ({@link MgCoordinate})  The coordinate to shift to
 */
 public void Shift(MgCoordinate pLonLat) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_0(swigCPtr, MgCoordinate.getCPtr(pLonLat));
  }

  
/**
 * Shift this datum to the specified longitude/latitude coordinate
 *
 * @param  dLongitude (double)  The longitude coordinate to shift to
 * @param  dLatitude (double)  The longitude coordinate to shift to
 */
 public MgCoordinate Shift(double dLongitude, double dLatitude) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_1(swigCPtr, dLongitude, dLatitude);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Shift this datum to the specified longitude/latitude/z coordinate
 *
 * @param  dLongitude (double)  The longitude coordinate to shift to
 * @param  dLatitude (double)  The longitude coordinate to shift to
 * @param  dZ (double)  The Z coordinate to shift to
 */
 public MgCoordinate Shift(double dLongitude, double dLatitude, double dZ) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_2(swigCPtr, dLongitude, dLatitude, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetOffsetX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetX(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetOffsetY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetY(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetOffsetZ() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetZ(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void SetOffset(double x, double y, double z) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_SetOffset(swigCPtr, x, y, z);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBursaWolfeTransformRotationX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationX(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBursaWolfeTransformRotationY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationY(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBursaWolfeTransformRotationZ() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationZ(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBursaWolfeTransformBwScale() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformBwScale(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void SetBursaWolfeTransform(double dRotationX, double dRotationY, double dRotationZ, double dBwScale) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_SetBursaWolfeTransform(swigCPtr, dRotationX, dRotationY, dRotationZ, dBwScale);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public int GetGeodeticTransformationMethod() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetGeodeticTransformationMethod(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void SetGeodeticTransformationMethod(int nGeodeticTransformationMethod) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_SetGeodeticTransformationMethod(swigCPtr, nGeodeticTransformationMethod);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetMaxOffset() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetMaxOffset(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean IsLegalOffset(double dOffset) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_IsLegalOffset(swigCPtr, dOffset);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetMaxRotation() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetMaxRotation(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean IsLegalRotation(double dRotation) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_IsLegalRotation(swigCPtr, dRotation);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBwScaleMin() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBwScaleMin(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double GetBwScaleMax() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_GetBwScaleMax(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean IsLegalBwScale(double dBwScale) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticTransformation_IsLegalBwScale(swigCPtr, dBwScale);
  }

}
