package org.osgeo.mapguide;


/**
 * An enumeration of the supported values for the <c>m_Orientation</c> member
 * of several objects related to grids and graticules. <p>
 * This value is used to qualify objects which are of the "iso" type.  I.e. a
 * grid line is referred to as an isoline as it is the locus of points which
 * have a specific value for either the easting or the northing.  It is this
 * value which indicates which.  Thus, a grid line which is classified as
 * having an "EastWest" orientation will be a isoline which is the locus of
 * points which share a common <b>easting</b> value, and the "m_Value" element
 * of that object will be an <b>easting</b> value.  Note that in this example,
 * the line is typically a vertical line.
 *
 */
public class MgCoordinateSystemGridOrientation
{
   
/**
 * Not specified yet, initialize to this value.
 *
 */

   public static final short None = 0 ; 
   
/**
 * The object represents a constant easting value.
 *
 */

   public static final short EastWest = 1 ; 
   
/**
 * The object represents a constant northing value.
 *
 */

   public static final short NorthSouth = 2 ; 
   
/**
 * Indicates the failure of an algorithm or other problem.
 *
 */

   public static final short Unknown = 3 ; 
   
}

