/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCurvePolygonCollection} provides support for defining an ordered set of
 * curve polygons.
 *
 */
 public class MgCurvePolygonCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgCurvePolygonCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCurvePolygonCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCurvePolygonCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCurvePolygonCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of curve polygons in the collection.
 *
 * @return  Returns number of curve polygons in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCurvePolygonCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the curve polygon in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the curve polygon to retrieve.
 * @return  Returns the curve polygon in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgCurvePolygon GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCurvePolygonCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCurvePolygon)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the curve polygon in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgCurvePolygon})  curve polygon to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void SetItem(int index, MgCurvePolygon value) throws MgException  {
    MapGuideJavaApiJNI.MgCurvePolygonCollection_SetItem(swigCPtr, index, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgCurvePolygon})  curve polygon to add to the collection.
 * @return  Returns nothing
 */
 public void Add(MgCurvePolygon value) throws MgException  {
    MapGuideJavaApiJNI.MgCurvePolygonCollection_Add(swigCPtr, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Inserts the specified curve polygon at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgCurvePolygon})  curve polygon to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void Insert(int index, MgCurvePolygon value) throws MgException  {
    MapGuideJavaApiJNI.MgCurvePolygonCollection_Insert(swigCPtr, index, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Removes all curve polygons from the collection.
 *
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgCurvePolygonCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified curve polygon from the collection.  Returns false if
 * the curve polygon could not be removed.
 *
 * @param  value ({@link MgCurvePolygon})  curve polygon reference to remove.
 * @return  Returns true if the curve polygon was removed
 */
 public boolean Remove(MgCurvePolygon value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurvePolygonCollection_Remove(swigCPtr, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Removes the curve polygon at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the curve polygon to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgCurvePolygonCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified curve polygon, false
 * otherwise.
 *
 * @param  value ({@link MgCurvePolygon})  curve polygon reference to check containment of.
 * @return  True if the collection contains the specified curve polygon, false
 *  otherwise.
 */
 public boolean Contains(MgCurvePolygon value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurvePolygonCollection_Contains(swigCPtr, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Returns the index of the specified curve polygon in the collection or -1
 * if the curve polygon does not exist.
 *
 * @param  value ({@link MgCurvePolygon})  curve polygon reference to find the index of.
 * @return  The index of the specified curve polygon in the collection or -1 if the
 *  curve polygon does not exist.
 */
 public int IndexOf(MgCurvePolygon value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurvePolygonCollection_IndexOf(swigCPtr, MgCurvePolygon.getCPtr(value));
  }

  
/**
 * Construct a {@link MgCurvePolygonCollection} object
 *
 */
 public MgCurvePolygonCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgCurvePolygonCollection(), true);
  }

}
