/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCurveSegmentCollection} provides support for defining an ordered set of
 * curve segments.
 *
 */
 public class MgCurveSegmentCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgCurveSegmentCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCurveSegmentCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCurveSegmentCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCurveSegmentCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of curve segments in the collection.
 *
 * @return  Returns number of curve segments in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCurveSegmentCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the curve segment in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the curve segment to retrieve.
 * @return  Returns the curve segment in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgCurveSegment GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCurveSegmentCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCurveSegment)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the curve segment in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgCurveSegment})  Curve segment to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void SetItem(int index, MgCurveSegment value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveSegmentCollection_SetItem(swigCPtr, index, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgCurveSegment})  Curve segment to add to the collection.
 * @return  Returns nothing
 */
 public void Add(MgCurveSegment value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveSegmentCollection_Add(swigCPtr, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Inserts the specified curve segment at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgCurveSegment})  Curve segment to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void Insert(int index, MgCurveSegment value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveSegmentCollection_Insert(swigCPtr, index, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Removes all curve segments from the collection.
 *
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgCurveSegmentCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified curve segment from the collection. Returns true
 * if the curve segment was successfully removed.
 *
 * @param  value ({@link MgCurveSegment})  Curve segment reference to remove.
 * @return  Returns true if curve segment was successfully removed.
 */
 public boolean Remove(MgCurveSegment value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveSegmentCollection_Remove(swigCPtr, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Removes the curve segment at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the curve segment to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgCurveSegmentCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified curve segment, false
 * otherwise.
 *
 * @param  value ({@link MgCurveSegment})  Curve segment reference to check containment of.
 * @return  True if the collection contains the specified curve segment, false
 *  otherwise.
 */
 public boolean Contains(MgCurveSegment value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveSegmentCollection_Contains(swigCPtr, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Returns the index of the specified curve segment in the collection or -1
 * if the curve segment does not exist.
 *
 * @param  value ({@link MgCurveSegment})  Curve segment reference to find the index of.
 * @return  The index of the specified curve segment in the collection or -1 if the
 *  curve segment does not exist.
 */
 public int IndexOf(MgCurveSegment value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveSegmentCollection_IndexOf(swigCPtr, MgCurveSegment.getCPtr(value));
  }

  
/**
 * Construct a {@link MgCurveSegmentCollection} object
 *
 */
 public MgCurveSegmentCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgCurveSegmentCollection(), true);
  }

}
