/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class represents a collection of {@link MgDisposable} objects.  The objects
 * are owned and managed by the collection.
 *
 */
 public class MgDisposableCollection extends MgCollection {
  private long swigCPtr;

  public MgDisposableCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgDisposableCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgDisposableCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgDisposableCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a DisposableCollection.  The collection is initially empty.
 *
 */
 public MgDisposableCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgDisposableCollection(), true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns number of items in the collection
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgDisposableCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the item in the collection at the specified index. Throws an invalid argument exception if the index is out of range.
 *
 * @param  index  Input index
 * @return  Returns the item in the collection at the specified index
 * @exception  MgIndexOutOfRangeException
 */
 public MgDisposable GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgDisposableCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgDisposable)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the item in the collection at the specified index to the specified value. Throws an invalid argument exception if the index is out of range.
 *
 * @param  index  Input index
 * @param  value  Input value
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException
 */
 public void SetItem(int index, MgDisposable value) throws MgException  {
    MapGuideJavaApiJNI.MgDisposableCollection_SetItem(swigCPtr, index, MgDisposable.getCPtr(value));
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value  Input value
 * @return  Returns nothing
 */
 public void Add(MgDisposable value) throws MgException  {
    MapGuideJavaApiJNI.MgDisposableCollection_Add(swigCPtr, MgDisposable.getCPtr(value));
  }

  
/**
 * Inserts the specified item at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 * Throws an invalid argument exception if the specified index is out of range.
 *
 * @param  index  Input index
 * @param  value  Input value
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException
 */
 public void Insert(int index, MgDisposable value) throws MgException  {
    MapGuideJavaApiJNI.MgDisposableCollection_Insert(swigCPtr, index, MgDisposable.getCPtr(value));
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgDisposableCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value  Input value
 * @return  Returns true if removal was successful
 */
 public boolean Remove(MgDisposable value) throws MgException  {
    return MapGuideJavaApiJNI.MgDisposableCollection_Remove(swigCPtr, MgDisposable.getCPtr(value));
  }

  
/**
 * Removes the specified item from the collection. Throws an invalid argument exception if the item does not exist within the collection.
 *
 * @param  index  Input index
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgDisposableCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise
 */
 public boolean Contains(MgDisposable value) throws MgException  {
    return MapGuideJavaApiJNI.MgDisposableCollection_Contains(swigCPtr, MgDisposable.getCPtr(value));
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist
 */
 public int IndexOf(MgDisposable value) throws MgException  {
    return MapGuideJavaApiJNI.MgDisposableCollection_IndexOf(swigCPtr, MgDisposable.getCPtr(value));
  }

  
/**
 * Creates an XML document representing the collection.
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader ToXml() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgDisposableCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
