/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgEnvelope} represents a bounding box defined in terms of a
 * lower left coordinate and an upper right coordinate.
 *
 */
 public class MgEnvelope extends MgSerializable {
  private long swigCPtr;

  public MgEnvelope(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgEnvelopeToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgEnvelope(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgEnvelope obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs and initializes  an "null" envelope.
 *
 */
 public MgEnvelope() throws MgException {
    this(MapGuideJavaApiJNI.new_MgEnvelope__SWIG_0(), true);
  }

  
/**
 * Constructs and initializes  an envelope for a region defined by one
 * coordinate.
 *
 * @param  coord ({@link MgCoordinate})  The {@link MgCoordinate} to use in defining the region.
 */
 public MgEnvelope(MgCoordinate coord) throws MgException {
    this(MapGuideJavaApiJNI.new_MgEnvelope__SWIG_1(MgCoordinate.getCPtr(coord)), true);
  }

  
/**
 * Constructs and initializes  an envelope for a region defined by two
 * coordinates.
 *
 * @param  coord1 ({@link MgCoordinate})  The first {@link MgCoordinate} to use in defining the region.
 * @param  coord2 ({@link MgCoordinate})  The second {@link MgCoordinate} to use in defining the region.
 */
 public MgEnvelope(MgCoordinate coord1, MgCoordinate coord2) throws MgException {
    this(MapGuideJavaApiJNI.new_MgEnvelope__SWIG_2(MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2)), true);
  }

  
/**
 * Constructs and initializes  an envelope for a region defined by two
 * coordinates , given as four doubles
 *
 * @param  xMin (double)  Left coordinate
 * @param  yMin (double)  Bottom coordinate
 * @param  xMax (double)  Right coordinate
 * @param  yMax (double)  Top coordinate
 */
 public MgEnvelope(double xMin, double yMin, double xMax, double yMax) throws MgException {
    this(MapGuideJavaApiJNI.new_MgEnvelope__SWIG_3(xMin, yMin, xMax, yMax), true);
  }

  
/**
 * Constructs and initializes  an envelope that is a copy of another.
 *
 * @param  envelope ({@link MgEnvelope})  The {@link MgEnvelope} to copy.
 */
 public MgEnvelope(MgEnvelope envelope) throws MgException {
    this(MapGuideJavaApiJNI.new_MgEnvelope__SWIG_4(MgEnvelope.getCPtr(envelope)), true);
  }

  
/**
 * Returns the lower left coordinate of the envelope.
 *
 * @return  An {@link MgCoordinate} that defines the lower left corner of the envelope.
 */
 public MgCoordinate GetLowerLeftCoordinate() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgEnvelope_GetLowerLeftCoordinate(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the upper right coordinate of the envelope.
 *
 * @return  An {@link MgCoordinate} that defines the upper right corner of the envelope.
 */
 public MgCoordinate GetUpperRightCoordinate() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgEnvelope_GetUpperRightCoordinate(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the difference between the maximum and minimum X values.
 *
 * @return  A double representing the width of the envelope.
 */
 public double GetWidth() throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_GetWidth(swigCPtr);
  }

  
/**
 * Returns the difference between the maximum and minimum Y values.
 *
 * @return  A double representing the height of the envelope.
 */
 public double GetHeight() throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_GetHeight(swigCPtr);
  }

  
/**
 * Returns the difference between the maximum and minimum Z values.
 *
 * @return  A double representing the depth of the envelope.
 */
 public double GetDepth() throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_GetDepth(swigCPtr);
  }

  
/**
 * Tests whether this Envelope is "null" or not.
 *
 * @return  True if this envelope is "null", false otherwise.
 */
 public boolean IsNull() throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_IsNull(swigCPtr);
  }

  
/**
 * Makes this envelope a "null" envelope.
 *
 */
 public void MakeNull() throws MgException  {
    MapGuideJavaApiJNI.MgEnvelope_MakeNull(swigCPtr);
  }

  
/**
 * Enlarges the boundary of the envelope so that it contains the given
 * coordinate.
 *
 * @param  coordinate ({@link MgCoordinate})  The {@link MgCoordinate} to expand this envelope to include.
 */
 public void ExpandToInclude(MgCoordinate coordinate) throws MgException  {
    MapGuideJavaApiJNI.MgEnvelope_ExpandToInclude__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coordinate));
  }

  
/**
 * Enlarges the boundary of the envelope so that it contains the given
 * envelope.
 *
 * @param  envelope ({@link MgEnvelope})  The {@link MgEnvelope} to expand this envelope to include.
 */
 public void ExpandToInclude(MgEnvelope envelope) throws MgException  {
    MapGuideJavaApiJNI.MgEnvelope_ExpandToInclude__SWIG_1(swigCPtr, MgEnvelope.getCPtr(envelope));
  }

  
/**
 * Tests whether the given coordinate lies in or on this envelope.
 *
 * @param  coordinate ({@link MgCoordinate})  The {@link MgCoordinate} to test containment of.
 * @return  True if the coordinate is contained in this envelope, false otherwise.
 */
 public boolean Contains(MgCoordinate coordinate) throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_Contains__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coordinate));
  }

  
/**
 * Tests whether the given envelope lies completely inside this
 * Envelope (inclusive of the boundary).
 *
 * @param  envelope ({@link MgEnvelope})  The {@link MgEnvelope} to test containment of.
 * @return  True if the envelope argument is contained in this envelope,
 *  false otherwise.
 */
 public boolean Contains(MgEnvelope envelope) throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_Contains__SWIG_1(swigCPtr, MgEnvelope.getCPtr(envelope));
  }

  
/**
 * Tests if the region defined by another envelope overlaps (intersects)
 * the region of this envelope.
 *
 * @param  envelope ({@link MgEnvelope})  The {@link MgEnvelope} to test for intersection.
 * @return  True if the envelopes intersect, false otherwise.
 */
 public boolean Intersects(MgEnvelope envelope) throws MgException  {
    return MapGuideJavaApiJNI.MgEnvelope_Intersects(swigCPtr, MgEnvelope.getCPtr(envelope));
  }

  
/**
 * Returns a transformed copy of this envelope.
 *
 * @param  transform ({@link MgTransform})  The {@link MgTransform} to use in constructing a copy of this envelope.
 * @return  An {@link MgEnvelope} that is a copy of this one but whose region is
 *  transformed.
 */
 public MgEnvelope Transform(MgTransform transform) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgEnvelope_Transform(swigCPtr, MgTransform.getCPtr(transform));
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
