/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgGeometry} is an abstract base class for all of the geometry
 * types.
 *
 */
 public class MgGeometry extends MgGeometricEntity {
  private long swigCPtr;

  public MgGeometry(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgGeometryToMgGeometricEntity(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgGeometry() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgGeometry(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometry obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the type of this geometry.
 *
 * @return  Returns the value defined in {@link MgGeometryType} corresponding to
 *  this geometry.
 */
 public int GetGeometryType() throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_GetGeometryType(swigCPtr);
  }

  
/**
 * This is a convenience method. Given 2 geometries a and b,
 * a.Contains(b) is true if and only if b.{@link MgGeometry}::Within(a)
 * is true.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this one.
 * @return  True if the other geometry is within this geometry, false
 *  otherwise.
 */
 public boolean Contains(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Contains(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Crosses(b) is true if and only
 * if the dimension of the intersection of the interior of a and
 * the interior of b is less than the greater of the dimension
 * of the interior of a and the dimension of the interior of b
 * and the intersection of a and b is neither a nor b.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this  one.
 * @return  True if this geometry spatially crosses the other geometry,
 *  false otherwise.
 */
 public boolean Crosses(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Crosses(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Disjoint(b)is true if and only
 * if the intersection of a and b is empty.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this one.
 * @return  True if this geometry is spatially disjoint from the other
 *  geometry, false otherwise.
 */
 public boolean Disjoint(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Disjoint(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Equals(b) is true if the 2
 * geometries are spatially equal
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this one.
 * @return  True if this geometry is spatially equal to the other
 *  geometry, false otherwise.
 */
 public boolean Equals(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Equals(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * This is a convenience method. Given 2 geometries a and b,
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this one.
 * @return  True if this geometry is not disjoint with respect to the
 *  other geometry, false otherwise.
 */
 public boolean Intersects(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Intersects(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Overlaps(b) is true if and only
 * if the dimension of the interior of a equals the dimension of
 * the interior of b equals the dimension of the intersection of
 * the interior of a and the interior of b and the intersection
 * of a and b is neither a nor b.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this one.
 * @return  True if this geometry spatially overlaps the other geometry,
 *  false otherwise.
 */
 public boolean Overlaps(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Overlaps(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Touches(b) is true if and only
 * if the intersection of the interior of a and the interior of
 * b is empty and the intersection of a and b is not empty.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this  one.
 * @return  True if this geometry spatially touches the other geometry,
 *  false otherwise.
 */
 public boolean Touches(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Touches(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * Given 2 geometries a and b, a.Within(b) is true if and only
 * if the intersection of a and b is a and the intersection of
 * the interior of a and the interior of b is not empty.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to test against this  one.
 * @return  True if this geometry is spatially within the other geometry,
 *  false otherwise.
 */
 public boolean Within(MgGeometry other) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Within(swigCPtr, MgGeometry.getCPtr(other));
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  An {@link MgGeometry} that represents this geometric entity's
 *  boundary.
 *  <h2>'Mod 2' Union Rule</h2>
 */
 public MgGeometry Boundary() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_Boundary(swigCPtr);
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a geometry that represents all points whose distance
 * from this geometric entity is less than or equal to a given
 * distance. By default, the distance computation is done using
 * a linear algorithm unless a custom measure is supplied.
 *
 * @param  distance (double)  The distance from the geometry in units.  This value cannot be zero.
 * @param  measure ({@link MgMeasure})  The {@link MgMeasure} instance to use when computing the buffer. If null,  a linear distance algorithm is used.
 * @return  An {@link MgGeometry} that represents the geometric entity's buffer, or
 *  NULL if the geometry cannot be buffered.
 */
 public MgGeometry Buffer(double distance, MgMeasure measure) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_Buffer(swigCPtr, distance, MgMeasure.getCPtr(measure));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  An {@link MgGeometry} that represents the convex hull of the
 *  geometric entity.
 */
 public MgGeometry ConvexHull() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_ConvexHull(swigCPtr);
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a geometry that represents a point set difference
 * between this geometric entity and another.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to subtract from this one.
 * @return  An {@link MgGeometry} representing the difference.
 *  <h2>Illustration</h2>
 *  if (Geom1.Disjoint(Geom2) == True) then
 *  Geom1.Difference(Geom2) = Geom1.
 */
 public MgGeometry Difference(MgGeometry other) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_Difference(swigCPtr, MgGeometry.getCPtr(other));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the shortest distance between this geometry and
 * another. By default distance computation is done using a
 * linear algorithm unless a custom measure is supplied.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to determine the distance to.
 * @param  measure ({@link MgMeasure})  The {@link MgMeasure} instance to use when computing the  distance. If null, a linear distance algorithm  is used.
 * @return  A double value representing the shortest distance between two
 *  geometries.
 */
 public double Distance(MgGeometry other, MgMeasure measure) throws MgException  {
    return MapGuideJavaApiJNI.MgGeometry_Distance(swigCPtr, MgGeometry.getCPtr(other), MgMeasure.getCPtr(measure));
  }

  
/**
 * Returns a geometry that represents the point set
 * intersection of this geometry and another.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to compute the intersection with  this one.
 * @return  An {@link MgGeometry} that represents the intersection.
 */
 public MgGeometry Intersection(MgGeometry other) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_Intersection(swigCPtr, MgGeometry.getCPtr(other));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to subtract from this one.
 * @return  An {@link MgGeometry} representing the symmetric difference.
 *  <h2>Illustration</h2>
 *  if (Geom1.Disjoint(Geom2) == True) then
 *  <TABLE border="1" class="RuledTable">
 *    <tr>
 *      <th>A</th>
 *      <th>B</th>
 *      <th>SymDiff</th>
 *    </tr>
 *    <tr>
 *      <td>Point | MultiPoint</td>
 *      <td>Point | MultiPoint</td>
 *      <td>MultiPoint</td>
 *    </tr>
 *    <tr>
 *      <td>Point | MultiPoint</td>
 *      <td>LineString | MultiLineString</td>
 *      <td>Geometry Collection (MultiLineString Point+, LineString+)</td>
 *    </tr>
 *    <tr>
 *      <td>Point | MultiPoint</td>
 *      <td>Polygon | MultiPolygon</td>
 *      <td>Geometry Collection (Point+, Polygon+)</td>
 *    </tr>
 *    <tr>
 *      <td>LineString | MultiLineString</td>
 *      <td>LineString | MultiLineString</td>
 *      <td>MultiLineString</td>
 *    </tr>
 *    <tr>
 *      <td>LineString |MultiLineString</td>
 *      <td>Polygon | MultiPolygon</td>
 *      <td>Geometry Collection (LineString+, Polygon+)</td>
 *    </tr>
 *    <tr>
 *      <td>Polygon | MultiPolygon</td>
 *      <td>Polygon | MultiPolygon</td>
 *      <td>MultiPolygon</td>
 *    </tr>
 *  </TABLE>
 */
 public MgGeometry SymetricDifference(MgGeometry other) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_SymetricDifference(swigCPtr, MgGeometry.getCPtr(other));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a geometry that represents the point set union of
 * this geometry with another.
 *
 * @param  other ({@link MgGeometry})  The {@link MgGeometry} to union with this one.
 * @return  An {@link MgGeometry} representing the union of the two geometries.
 */
 public MgGeometry Union(MgGeometry other) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometry_Union(swigCPtr, MgGeometry.getCPtr(other));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
