/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates the properties of a layer group.
 *
 */
 public class MgLayerGroup extends MgNamedSerializable {
  private long swigCPtr;

  public MgLayerGroup(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgLayerGroupToMgNamedSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerGroup() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgLayerGroup(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgLayerGroup} object with the specified name.
 *
 * @param  name (String/string)  Name of the group
 */
 public MgLayerGroup(String name) throws MgException {
    this(MapGuideJavaApiJNI.new_MgLayerGroup(name), true);
  }

  
/**
 * Gets the group name.
 *
 * @return  Returns the group name as a string.
 */
 public String GetName() throws MgException  {
  { return MapGuideJavaApiJNI.MgLayerGroup_GetName(swigCPtr); }
}

  
/**
 * Gets a unique identifier for this layer group.
 *
 * @return  Returns the unique identifier as a string.
 */
 public String GetObjectId() throws MgException  {
  { return MapGuideJavaApiJNI.MgLayerGroup_GetObjectId(swigCPtr); }
}

  
/**
 * Gets the type of the layer group.
 *
 * @return  Returns the type of the layer group.
 */
 public int GetLayerGroupType() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroup_GetLayerGroupType(swigCPtr);
  }

  
/**
 * Gets the group this group is organized within.
 *
 * @return  Returns the parent group, or NULL if the group is at the top
 *  level of the hierarchy.
 */
 public MgLayerGroup GetGroup() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLayerGroup_GetGroup(swigCPtr);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Changes the group this group is organized within.
 *
 * @param  group ({@link MgLayerGroup})  Group for this group to belong to, or NULL if the  group should not belong to any group.
 * @return  Returns nothing.
 */
 public void SetGroup(MgLayerGroup group) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroup_SetGroup(swigCPtr, MgLayerGroup.getCPtr(group));
  }

  
/**
 * Determines if the layer group is potentially visible.
 *
 * @return  Returns true if the layer group is potentially visible, or
 *  false otherwise.
 */
 public boolean GetVisible() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroup_GetVisible(swigCPtr);
  }

  
/**
 * Alters the group potential visibility.
 *
 * @param  visible (boolean/bool)  True if the group should be visible, or false  otherwise.
 * @return  Returns nothing.
 */
 public void SetVisible(boolean visible) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroup_SetVisible(swigCPtr, visible);
  }

  
/**
 * Determines the actual visibility of the group.
 *
 * @return  Returns true if the layer group is visible, or false
 *  otherwise.
 */
 public boolean IsVisible() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroup_IsVisible(swigCPtr);
  }

  
/**
 * Determines whether an entry for the group should appear in
 * the legend.
 *
 * @return  Returns true if the group should appear in the legend, or
 *  false otherwise.
 */
 public boolean GetDisplayInLegend() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroup_GetDisplayInLegend(swigCPtr);
  }

  
/**
 * Specifies whether an entry for the group should appear in the
 * legend.
 *
 * @param  displayInLegend (boolean/bool)  True if the group should appear in the  legend, or false otherwise.
 * @return  Returns nothing.
 */
 public void SetDisplayInLegend(boolean displayInLegend) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroup_SetDisplayInLegend(swigCPtr, displayInLegend);
  }

  
/**
 * Determines whether the entry for the group should initially
 * be expanded in the legend, if possible.
 *
 * @return  Returns true if the group should initially be expanded in the legend, or
 *  false otherwise.
 */
 public boolean GetExpandInLegend() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroup_GetExpandInLegend(swigCPtr);
  }

  
/**
 * Gets the label to be displayed for the group in the legend.
 *
 * @return  Returns the legend label as a string.
 */
 public String GetLegendLabel() throws MgException  {
  { return MapGuideJavaApiJNI.MgLayerGroup_GetLegendLabel(swigCPtr); }
}

  
/**
 * Sets the label to be displayed for the group in the legend.
 *
 * @param  legendLabel (String/string)  Legend label.
 * @return  Returns nothing.
 */
 public void SetLegendLabel(String legendLabel) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroup_SetLegendLabel(swigCPtr, legendLabel);
  }

  
/**
 * Specifies whether the entry for the group should initially
 * be expanded in the legend, if possible.
 *
 * @param  expandInLegend (boolean/bool)  Indicates whether this group is expanded in the legend
 * @return  Returns nothing.
 * @since  2.5 */
 public void SetExpandInLegend(boolean expandInLegend) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroup_SetExpandInLegend(swigCPtr, expandInLegend);
  }

}
