/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgLinearRingCollection} provides support for defining an ordered set of
 * linear rings.
 *
 */
 public class MgLinearRingCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgLinearRingCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgLinearRingCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgLinearRingCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLinearRingCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of linear rings in the collection.
 *
 * @return  Returns number of linear rings in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgLinearRingCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the linear ring in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the linear ring to retrieve.
 * @return  Returns the linear ring in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgLinearRing GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLinearRingCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLinearRing)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the linear ring in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgLinearRing})  linear ring to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void SetItem(int index, MgLinearRing value) throws MgException  {
    MapGuideJavaApiJNI.MgLinearRingCollection_SetItem(swigCPtr, index, MgLinearRing.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgLinearRing})  linear ring to add to the collection.
 * @return  Returns nothing
 */
 public void Add(MgLinearRing value) throws MgException  {
    MapGuideJavaApiJNI.MgLinearRingCollection_Add(swigCPtr, MgLinearRing.getCPtr(value));
  }

  
/**
 * Inserts the specified linear ring at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgLinearRing})  linear ring to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void Insert(int index, MgLinearRing value) throws MgException  {
    MapGuideJavaApiJNI.MgLinearRingCollection_Insert(swigCPtr, index, MgLinearRing.getCPtr(value));
  }

  
/**
 * Removes all linear rings from the collection.
 *
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgLinearRingCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified linear ring from the collection. Returns true
 * if removal was successful.
 *
 * @param  value ({@link MgLinearRing})  linear ring reference to remove.
 * @return  Returns true if successful.
 */
 public boolean Remove(MgLinearRing value) throws MgException  {
    return MapGuideJavaApiJNI.MgLinearRingCollection_Remove(swigCPtr, MgLinearRing.getCPtr(value));
  }

  
/**
 * Removes the linear ring at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the linear ring to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgLinearRingCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified linear ring, false
 * otherwise.
 *
 * @param  value ({@link MgLinearRing})  linear ring reference to check containment of.
 * @return  True if the collection contains the specified linear ring, false
 *  otherwise.
 */
 public boolean Contains(MgLinearRing value) throws MgException  {
    return MapGuideJavaApiJNI.MgLinearRingCollection_Contains(swigCPtr, MgLinearRing.getCPtr(value));
  }

  
/**
 * Returns the index of the specified linear ring in the collection or -1
 * if the linear ring does not exist.
 *
 * @param  value ({@link MgLinearRing})  linear ring reference to find the index of.
 * @return  The index of the specified linear ring in the collection or -1 if the
 *  linear ring does not exist.
 */
 public int IndexOf(MgLinearRing value) throws MgException  {
    return MapGuideJavaApiJNI.MgLinearRingCollection_IndexOf(swigCPtr, MgLinearRing.getCPtr(value));
  }

  
/**
 * Construct a {@link MgLinearRingCollection} object
 *
 */
 public MgLinearRingCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgLinearRingCollection(), true);
  }

}
