/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Defines the runtime state of a map.
 *
 */
 public class MgMapBase extends MgResource {
  private long swigCPtr;

  public MgMapBase(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgMapBaseToMgResource(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgMapBase(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMapBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an empty un-initialized {@link MgMapBase} object.
 *
 */
 public MgMapBase() throws MgException {
    this(MapGuideJavaApiJNI.new_MgMapBase(), true);
  }

  
/**
 * Gets the name of this map.
 *
 * @return  Returns the name of the map as a string.
 */
 public String GetName() throws MgException  {
  { return MapGuideJavaApiJNI.MgMapBase_GetName(swigCPtr); }
}

  
/**
 * Gets the identifier of the session associated with this map.
 *
 * @return  Returns the session id of the map as a string.
 */
 public String GetSessionId() throws MgException  {
  { return MapGuideJavaApiJNI.MgMapBase_GetSessionId(swigCPtr); }
}

  
/**
 * Gets an identifier that can be used to uniquely identify this
 * map.
 *
 * @return  Returns the unique identifier of this map as a string.
 */
 public String GetObjectId() throws MgException  {
  { return MapGuideJavaApiJNI.MgMapBase_GetObjectId(swigCPtr); }
}

  
/**
 * Returns the resource identifier that specifies the location
 * of the map definition that was used to create this map.
 *
 * @return  Returns an {@link MgResourceIdentifier} that specifies the location
 *  of the map definition. NULL is returned if this map was created
 *  from a Tile Set Definition
 */
 public MgResourceIdentifier GetMapDefinition() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetMapDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgResourceIdentifier)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the spatial reference system used to display this map.
 *
 */
 public String GetMapSRS() throws MgException  {
  { return MapGuideJavaApiJNI.MgMapBase_GetMapSRS(swigCPtr); }
}

  
/**
 * Returns the the overall extent of the map.
 *
 * @return  Returns an {@link MgEnvelope} that defines the overall extent of the
 *  map.
 */
 public MgEnvelope GetMapExtent() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetMapExtent(swigCPtr);
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns this map's layers.
 *
 * @return  Returns an {@link MgLayerCollection} that contains the map layers.
 */
 public MgLayerCollection GetLayers() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetLayers(swigCPtr);
    return (cPtr == 0) ? null : (MgLayerCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns this map's layer groups.
 *
 * @return  Returns an {@link MgLayerGroupCollection} that contains the map
 *  layer groups.
 */
 public MgLayerGroupCollection GetLayerGroups() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetLayerGroups(swigCPtr);
    return (cPtr == 0) ? null : (MgLayerGroupCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Initializes a new {@link MgMapBase} object given a resource service, map
 * definition, and a name for the map. This method is used for
 * MapGuide Viewers or for offline map production.
 *
 * @param  resourceService  An {@link MgResourceService} that can be used to  retrieve the map definition.
 * @param  mapDefinition  An {@link MgResourceIdentifier} that specifies the  location of the map definition in a resource  repository.
 * @param  mapName  A string that specifies the name of the map.
 */
 public void Create(MgResourceService resourceService, MgResourceIdentifier mapDefinition, String mapName) throws MgException  {
    MapGuideJavaApiJNI.MgMapBase_Create__SWIG_0(swigCPtr, MgResourceService.getCPtr(resourceService), MgResourceIdentifier.getCPtr(mapDefinition), mapName);
  }

  
/**
 * Initializes a new {@link MgMapBase} object given a spatial reference system,
 * spatial extent of the map, and a name for the map. This method
 * is used for the WMS service implementation and creates a map
 * without any layers.
 *
 * @param  mapSRS  A string specifying the spatial reference system in OpenGIS WKT  format.
 * @param  mapExtent  An {@link MgEnvelope} defining the overall extent of the map.
 * @param  mapName  A string that specifies the name of the map.
 */
 public void Create(String mapSRS, MgEnvelope mapExtent, String mapName) throws MgException  {
    MapGuideJavaApiJNI.MgMapBase_Create__SWIG_1(swigCPtr, mapSRS, MgEnvelope.getCPtr(mapExtent), mapName);
  }

  
/**
 * Loads the map object from a session repository.
 *
 * @param  resourceService  An {@link MgResourceService} that can be used to retrieve  the map.
 * @param  mapName  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void Open(MgResourceService resourceService, String mapName) throws MgException  {
    MapGuideJavaApiJNI.MgMapBase_Open(swigCPtr, MgResourceService.getCPtr(resourceService), mapName);
  }

  
/**
 * Gets the current center point of the map, in the spatial
 * reference system of the map.
 *
 * @return  Returns an {@link MgPoint} that specifies the center of the map.
 */
 public MgPoint GetViewCenter() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetViewCenter(swigCPtr);
    return (cPtr == 0) ? null : (MgPoint)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the current scale of the map.
 *
 * @return  Returns a double that specifies the scale of the map.
 */
 public double GetViewScale() throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetViewScale(swigCPtr);
  }

  
/**
 * Returns the extent of the data to be generated for the map
 * in the spatial reference system of the map.
 *
 * @return  Returns an {@link MgEnvelope} that defines the current data extent.
 */
 public MgEnvelope GetDataExtent() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapBase_GetDataExtent(swigCPtr);
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the number of dots per inch of the map display.
 *
 * @return  Returns the number of dots per inch of the map display.
 */
 public int GetDisplayDpi() throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetDisplayDpi(swigCPtr);
  }

  
/**
 * Sets the number of dots per inch of the map display.
 *
 * @param  dpi (int)  Number of dots per inch of the map display
 * @since  2.4 */
 public void SetDisplayDpi(int dpi) throws MgException  {
    MapGuideJavaApiJNI.MgMapBase_SetDisplayDpi(swigCPtr, dpi);
  }

  
/**
 * Returns the current width of the map display in pixels.
 *
 * @return  Returns the width of the map display in pixels.
 */
 public int GetDisplayWidth() throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetDisplayWidth(swigCPtr);
  }

  
/**
 * Returns the current height of the map display in pixels.
 *
 * @return  Returns the height of the map display in pixels.
 */
 public int GetDisplayHeight() throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetDisplayHeight(swigCPtr);
  }

  
/**
 * Gets the number of finite display scales in the map.
 *
 * @return  Returns the number of finite display scales in the map.
 */
 public int GetFiniteDisplayScaleCount() throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetFiniteDisplayScaleCount(swigCPtr);
  }

  
/**
 * Gets the finite display scale at the specified index.
 *
 * @param  index  Index of the finite display scale to get.
 * @return  Returns the finite display scale.
 * @exception  MgOutOfRangeException if the index is invalid.
 */
 public double GetFiniteDisplayScaleAt(int index) throws MgException  {
    return MapGuideJavaApiJNI.MgMapBase_GetFiniteDisplayScaleAt(swigCPtr, index);
  }

  
/**
 * Returns the background color for the map
 *
 * @return  Background color.
 * @since  2.4 */
 public String GetBackgroundColor() throws MgException  {
  { return MapGuideJavaApiJNI.MgMapBase_GetBackgroundColor(swigCPtr); }
}

}
