package org.osgeo.mapguide;


/**
 * {@link MgMapPlotInstruction} defines enumerated values used to indicate whether the plot
 * should be based on the center and scale of the map,
 * an overridden center and scale, or an overridden extent.
 *
 */
public class MgMapPlotInstruction
{
   
/**
 * Specifies the plot should use the center and scale of the map
 *
 */

   public static final int UseMapCenterAndScale = 0 ; 
   
/**
 * Specifies the plot should use the overridden center and scale of the map
 *
 */

   public static final int UseOverriddenCenterAndScale = 1 ; 
   
/**
 * Specifies the plot should use the overridden extent
 *
 */

   public static final int UseOverriddenExtent = 2 ; 
   
}

