package org.osgeo.mapguide;


/**
 * Defines a type used to specify the order in which features
 * are returned by {@link MgFeatureService}::SelectFeatures. This type
 * is used as an argument to the {@link MgFeatureQueryOptions}::SetOrderingFilter.
 *
 */
public class MgOrderingOption
{
   
/**
 * Signifies that the features are returned in ascending order
 * relative to the properties specified in the first argument of
 * {@link MgFeatureQueryOptions}::SetOrderingFilter.
 *
 */

   public static final int Ascending = 0 ; 
   
/**
 * Signifies that the features are returned in descending order
 * relative to the properties specified in the first argument of
 * {@link MgFeatureQueryOptions}::SetOrderingFilter.
 *
 */

   public static final int Descending = 1 ; 
   
}

