package org.osgeo.mapguide;


/**
 * Defines the names for the various property types.
 *
 */
public class MgPropertyType
{
   
/**
 * Type name for a null property.
 *
 */

   public static final int Null = 0 ; 
   
/**
 * Type name for a boolean property ({@link MgBooleanProperty}).
 *
 */

   public static final int Boolean = 1 ; 
   
/**
 * Type name for a byte (unsigned 8 bit value) property
 * ({@link MgByteProperty}).
 *
 */

   public static final int Byte = 2 ; 
   
/**
 * Type name for an {@link MgDateTime} property ({@link MgDateTimeProperty}).
 *
 */

   public static final int DateTime = 3 ; 
   
/**
 * Type name for a single precision floating point value
 * property ({@link MgSingleProperty}).
 *
 */

   public static final int Single = 4 ; 
   
/**
 * Type name for a double precision floating point value
 * property ({@link MgDoubleProperty}).
 *
 */

   public static final int Double = 5 ; 
   
/**
 * Type name for a 16 bit signed integer value property
 * ({@link MgInt16Property}).
 *
 */

   public static final int Int16 = 6 ; 
   
/**
 * Type name for a 32 bit signed integer value property
 * ({@link MgInt32Property}).
 *
 */

   public static final int Int32 = 7 ; 
   
/**
 * Type name for a 64 bit signed integer value property
 * ({@link MgInt64Property}).
 *
 */

   public static final int Int64 = 8 ; 
   
/**
 * Type name for a string property ({@link MgStringProperty}).
 *
 */

   public static final int String = 9 ; 
   
/**
 * Type name for a Binary Large OBject property
 * ({@link MgBlobProperty}).
 *
 */

   public static final int Blob = 10 ; 
   
/**
 * Type name for a Character Large OBject property
 * ({@link MgClobProperty}).
 *
 */

   public static final int Clob = 11 ; 
   
/**
 * Type name for a feature property ({@link MgFeatureProperty}).
 *
 */

   public static final int Feature = 12 ; 
   
/**
 * Type name for a geometry property ({@link MgGeometryProperty}).
 *
 */

   public static final int Geometry = 13 ; 
   
/**
 * Type name for a raster property ({@link MgRasterProperty}).
 *
 */

   public static final int Raster = 14 ; 
   
/**
 * Type name for a decimal property.
 *
 * @since  2.2 */

   public static final int Decimal = 15 ; 
   
}

