/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides read only access to a collection of {@link MgLayerBase} objects.
 *
 */
 public class MgReadOnlyLayerCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgReadOnlyLayerCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgReadOnlyLayerCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgReadOnlyLayerCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgReadOnlyLayerCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgReadOnlyLayerCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of layers in the collection.
 *
 * @return  Returns the number of layers.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgReadOnlyLayerCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer at the specified index.
 *
 * @param  index (int)  Index of the layer to get.
 * @return  Returns the layer.
 * @exception  MgOutOfRangeException if the index is invalid.
 */
 public MgLayerBase GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgReadOnlyLayerCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean Contains(MgLayerBase value) throws MgException  {
    return MapGuideJavaApiJNI.MgReadOnlyLayerCollection_Contains(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int IndexOf(MgLayerBase value) throws MgException  {
    return MapGuideJavaApiJNI.MgReadOnlyLayerCollection_IndexOf(swigCPtr, MgLayerBase.getCPtr(value));
  }

}
