/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class contains methods to allow MapGuide clients to perform administration related
 * operations:
 * - Server Configuration
 * - Logging
 * - Online/Offline
 * - Server Health
 *
 */
 public class MgServerAdmin extends MgGuardDisposable {
  private long swigCPtr;

  public MgServerAdmin(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgServerAdminToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgServerAdmin(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgServerAdmin obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Default Constructor for an {@link MgServerAdmin} object.
 *
 * @return  Nothing
 */
 public MgServerAdmin() throws MgException {
    this(MapGuideJavaApiJNI.new_MgServerAdmin(), true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Opens a connection to a specified Server.
 *
 * @param  server  Server IP address or DNS name.
 * @param  userInformation  User information - credentials, locale, session identifier
 * @return  Nothing
 * @exception  MgServerNotFoundException
 * @exception  MgConnectionFailedException
 */
 public void Open(String server, MgUserInformation userInformation) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_Open__SWIG_0(swigCPtr, server, MgUserInformation.getCPtr(userInformation));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Opens a connection to a Server.
 *
 * @param  userInformation  User information - credentials, locale, session identifier
 * @return  Nothing
 * @exception  MgServerNotFoundException
 * @exception  MgConnectionFailedException
 */
 public void Open(MgUserInformation userInformation) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_Open__SWIG_1(swigCPtr, MgUserInformation.getCPtr(userInformation));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Closes the current Server connection.
 *
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void Close() throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_Close(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * HasWarning() method reports if there is a current warning.
 *
 * @return  Returns true or false
 * @exception  MgConnectionNotOpenException
 */
 public boolean HasWarning() throws MgException  {
    return MapGuideJavaApiJNI.MgServerAdmin_HasWarning(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * GetWarningsObject() method returns all the current warning.
 *
 * @return  Returns a pointer to the {@link MgWarnings} object.
 * @exception  MgConnectionNotOpenException
 */
 public MgWarnings GetWarningsObject() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetWarningsObject(swigCPtr);
    return (cPtr == 0) ? null : (MgWarnings)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the configuration properties for the specified property section.
 *
 * @param  propertySection  The property section to get.
 * @return  The collection of configuration properties associated with the specified property section.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidPropertySectionException
 * @exception  MgPropertySectionNotAvailableException
 */
 public MgPropertyCollection GetConfigurationProperties(String propertySection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetConfigurationProperties(swigCPtr, propertySection);
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Sets the configuration properties for the specified property section.
 *
 * @param  propertySection  The property section to set.
 * @param  properties  The collection of configuration properties associated with the specified property section that you want to set.
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidPropertySectionException
 * @exception  MgPropertySectionNotAvailableException
 * @exception  MgPropertySectionReadOnlyException
 * @exception  MgInvalidPropertyException
 */
 public void SetConfigurationProperties(String propertySection, MgPropertyCollection properties) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_SetConfigurationProperties(swigCPtr, propertySection, MgPropertyCollection.getCPtr(properties));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Removes the configuration properties for the specified property section.
 * If the properties are not specified, then the entire section will be removed.
 *
 * @param  propertySection  The property section to remove.
 * @param  properties  The collection of configuration properties associated with the specified property section that you want to remove.
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidPropertySectionException
 * @exception  MgPropertySectionNotAvailableException
 * @exception  MgPropertySectionReadOnlyException
 * @exception  MgInvalidPropertyException
 */
 public void RemoveConfigurationProperties(String propertySection, MgPropertyCollection properties) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_RemoveConfigurationProperties(swigCPtr, propertySection, MgPropertyCollection.getCPtr(properties));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Clears the specified log.
 *
 * @param  log  The log to be cleared. (AccessLog, AdminLog, AuthenticationLog, ErrorLog,  SessionLog, TraceLog)
 * @return  True if the log was successfully cleared, false otherwise.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullReferenceException
 */
 public boolean ClearLog(String log) throws MgException  {
    return MapGuideJavaApiJNI.MgServerAdmin_ClearLog(swigCPtr, log);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Deletes the specified log if it exists.
 *
 * @param  fileName  The name of the log to be deleted from the logs directory (does not include path)
 * @return  Nothing.
 * @exception  MgNullArgumentException
 * @exception  MgFileNotFoundException
 * @exception  MgFileIoException
 */
 public void DeleteLog(String fileName) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_DeleteLog(swigCPtr, fileName);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Renames the specified log to the new name given
 *
 * @param  oldFileName  The current name of the log file
 * @param  newFileName  The new name to give the log file
 * @return  Nothing.
 * @exception  MgNullArgumentException
 * @exception  MgDuplicateFileException
 * @exception  MgFileNotFoundException
 * @exception  MgInvalidArgumentException
 * @exception  MgFileIoException
 */
 public void RenameLog(String oldFileName, String newFileName) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_RenameLog(swigCPtr, oldFileName, newFileName);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Returns a string collection listing the contents of the logs directory.
 *
 * @return  A string collection listing the contents of the logs directory.
 * @exception  MgFileIoException
 */
 public MgPropertyCollection EnumerateLogs() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_EnumerateLogs(swigCPtr);
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the contents of the specified log.
 *
 * @param  log  The log to retrieve. (AccessLog, AdminLog, AuthenticationLog, ErrorLog,  SessionLog, TraceLog)
 * @return  The log contents in a ByteReader.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullReferenceException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetLog(String log) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetLog__SWIG_0(swigCPtr, log);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the specified number of entries from the specified log.
 *
 * @param  log  The log to retrieve. (AccessLog, AdminLog, AuthenticationLog, ErrorLog,  SessionLog, TraceLog)
 * @param  numEntries  The number of entries to return.
 * @return  The log contents in a ByteReader.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgArgumentOutOfRangeException
 * @exception  MgNullReferenceException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetLog(String log, int numEntries) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetLog__SWIG_1(swigCPtr, log, numEntries);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the contents of the specified log between two dates.  A maximum 24 hour
 * period is allowed to be retrieved.  This will use the current file name convention
 * for the log so if the filename was changed it will be unable to find entries
 * located previous files.
 *
 * @param  log  The log to retrieve. (AccessLog, AdminLog, AuthenticationLog, ErrorLog,  MapLayerAccessLog, SessionLog, TraceLog)
 * @param  fromDate  Date and time to start pulling entries from
 * @param  toDate  Last date and time to pull entries for
 * @return  The log contents in a ByteReader.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidLogTypeException
 * @exception  MgNullReferenceException
 * @exception  MgInvalidArgumentException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetLog(String log, MgDateTime fromDate, MgDateTime toDate) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetLog__SWIG_2(swigCPtr, log, MgDateTime.getCPtr(fromDate), MgDateTime.getCPtr(toDate));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the contents of the specified log file.
 *
 * @param  logFile  The log file to retrieve.
 * @return  The log contents in a ByteReader.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullReferenceException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetLogFile(String logFile) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetLogFile(swigCPtr, logFile);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Allows the server to process client operations.
 *
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void BringOnline() throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_BringOnline(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Prevents the server from processing client operations.  When offline, the
 * adminstrator can access the server via "Admin" operations without worrying
 * about MapGuide clients using the server.
 *
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void TakeOffline() throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_TakeOffline(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the online status of the server.
 *
 * @return  True for online, False for offline.
 * @exception  MgConnectionNotOpenException
 */
 public boolean IsOnline() throws MgException  {
    return MapGuideJavaApiJNI.MgServerAdmin_IsOnline(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the information properties for the server.
 *
 * @return  The collection of information properties.
 * @exception  MgConnectionNotOpenException
 */
 public MgPropertyCollection GetInformationProperties() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetInformationProperties(swigCPtr);
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the site version.
 *
 * @return  The site version.
 * @exception  MgConnectionNotOpenException
 */
 public String GetSiteVersion() throws MgException  {
  { return MapGuideJavaApiJNI.MgServerAdmin_GetSiteVersion(swigCPtr); }
}

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the status properties for the server.
 *
 * @return  The collection of status properties.
 * @exception  MgConnectionNotOpenException
 */
 public MgPropertyCollection GetSiteStatus() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetSiteStatus(swigCPtr);
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Delete the specified package, if able.
 *
 * @param  packageName  The name of the package to be deleted.  Available packages can be found by  using EnumeratePackages().
 * @return  Nothing.
 * @exception  MgInvalidArgumentException
 * @exception  MgFileIoException
 * @exception  MgFileNotFoundException
 */
 public void DeletePackage(String packageName) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_DeletePackage(swigCPtr, packageName);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Enumerates the packages available in the package directory.
 *
 * @return  An {@link MgStringCollection} containing a list of packages in the packages directory
 * @exception  MgOutOfMemoryException
 * @exception  MgFileNotFoundException
 * @exception  MgFileIoException
 */
 public MgStringCollection EnumeratePackages() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_EnumeratePackages(swigCPtr);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets current log of the specified package
 *
 * @param  packageName  The name of the package to get the status for.  Available packages can be  found by using EnumeratePackages().
 * @return  An {@link MgByteReader} containing the contents of the package's log.
 * @exception  MgFileNotFoundException
 * @exception  MgFileIoException
 * @exception  MgInvalidArgumentException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetPackageLog(String packageName) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetPackageLog(swigCPtr, packageName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Retrieves the current status of the specified package.
 *
 * @param  packageName  The name of the package to get the status for.  Available packages can be found by using EnumeratePackages().
 * @return  The status of the package.
 */
 public MgPackageStatusInformation GetPackageStatus(String packageName) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetPackageStatus(swigCPtr, packageName);
    return (cPtr == 0) ? null : (MgPackageStatusInformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Loads the specified resource package into the repository.
 *
 * @param  packageName  The name of the package to be loaded.  Available packages can be found by  using EnumeratePackages().
 * @return  Nothing.
 * @exception  MgFileNotFoundException
 * @exception  MgPathTooLongException
 * @exception  MgFileIoException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullArgumentException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgOutOfMemoryException
 */
 public void LoadPackage(String packageName) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_LoadPackage(swigCPtr, packageName);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates a package from the specified resource, and then saves it into
 * the specified name.
 *
 * @param  resource  Resource identifier of a folder containing permissible resources to be  packaged.
 * @param  packageName  The name of the package to be made. The serverconfig.ini file has the  "PackagesPath" property which will be used for path. The file name will  automatically be appended with the ".mgp" extension (case sensitive)  if it is not specified.
 * @param  packageDescription  The description of the package.
 * @return  Nothing.
 * @exception  MgDuplicateFileException
 * @exception  MgPathTooLongException
 * @exception  MgFileIoException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullArgumentException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgOutOfMemoryException
 */
 public void MakePackage(MgResourceIdentifier resource, String packageName, String packageDescription) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_MakePackage(swigCPtr, MgResourceIdentifier.getCPtr(resource), packageName, packageDescription);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Specifies the maximum size in kilobytes for the log files.  When the maximum
 * size is exceeded, the current log will be archived, and a new log will be created.
 *
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void SetMaximumLogSize(int size) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_SetMaximumLogSize(swigCPtr, size);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Specifies the delimiter to use for separating the data fields in the logs.
 *
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void SetLogDelimiter(String delimiter) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_SetLogDelimiter(swigCPtr, delimiter);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Enables/disables maximum log file size restriction.  Maximum log file size is
 * set with {@link MgServerAdmin}::SetMaximumLogSize().
 *
 * @param  useMaxSize  Log file size restriction is enforced if useMaxSize = true.  using EnumeratePackages().
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 */
 public void EnableMaximumLogSize(boolean useMaxSize) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_EnableMaximumLogSize(swigCPtr, useMaxSize);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Determines if log file size is restricted to the maximum size
 * set with {@link MgServerAdmin}::SetMaximumLogSize().
 *
 * @return  The status of the use of the maximum log size restriction
 * @exception  MgConnectionNotOpenException
 */
 public boolean IsMaximumLogSizeEnabled() throws MgException  {
    return MapGuideJavaApiJNI.MgServerAdmin_IsMaximumLogSizeEnabled(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the contents of the specified document.
 *
 * @param  identifier  The document to retrieve.
 * @return  The document contents in a ByteReader.
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullReferenceException
 * @exception  MgOutOfMemoryException
 */
 public MgByteReader GetDocument(String identifier) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgServerAdmin_GetDocument(swigCPtr, identifier);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Sets the contents of the specified document.
 *
 * @param  identifier  The document to set.
 * @param  data  The data to set the document contents to.
 * @return  Nothing
 * @exception  MgConnectionNotOpenException
 * @exception  MgInvalidArgumentException
 * @exception  MgNullReferenceException
 * @exception  MgOutOfMemoryException
 */
 public void SetDocument(String identifier, MgByteReader data) throws MgException  {
    MapGuideJavaApiJNI.MgServerAdmin_SetDocument(swigCPtr, identifier, MgByteReader.getCPtr(data));
  }

}
