/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Site connection.  Provides basic authentication and Service access
 * capabilities for the site.
 *
 */
 public class MgSiteConnection extends MgGuardDisposable {
  private long swigCPtr;

  public MgSiteConnection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgSiteConnectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgSiteConnection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgSiteConnection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates a site connection.  The local site defined
 * for the web tier or server is used.
 *
 * @exception  MgConfigurationException
 */
 public MgSiteConnection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgSiteConnection__SWIG_0(), true);
  }

  
/**
 * Establishes a connection to a site
 *
 * @param  userInformation ({@link MgUserInformation})  User information to authenticate against.  Can either be username/password  or session identifier.  User information also contains client locale.  See {@link MgUserInformation} for details.
 * @return  Nothing
 * @exception  MgAuthenticationFailedException if user information was not supplied
 * @exception  MgConfigurationException if configuration information could not be loaded
 * @exception  MgUnauthorizedAccessException if user is not authorized for site
 * @exception  MgConnectionFailedException if site cannot be connected to
 */
 public void Open(MgUserInformation userInformation) throws MgException  {
    MapGuideJavaApiJNI.MgSiteConnection_Open(swigCPtr, MgUserInformation.getCPtr(userInformation));
  }

  
/**
 * Returns a new instance of the specified service from the site.  A connection
 * to the machine hosting the service will be created if required.
 * Configuration information determines whether the service is hosted locally
 * or not. The configuration information is stored in a file named webconfig.ini
 * which is located in the same folder as the map agent. The parameters in this file
 * can be modified using the web administration application.
 *
 * @param  serviceType (int)  Type of service to create.  See {@link MgServiceType} for valid service names.
 * @return  Returns the created service
 * @exception  MgServiceNotSupportedException if service type is not supported
 * @exception  MgConnectionNotOpenException if connection has not been opened
 */
 public MgService CreateService(int serviceType) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSiteConnection_CreateService(swigCPtr, serviceType);
    return (cPtr == 0) ? null : (MgService)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns an instance of the {@link MgSite} object.  This object
 * is responsible for user/group management and session management.
 * {@link MgSite} exposes functionality to enumerate users and groups and to
 * manage user sessions.  The connection must already be open to
 * obtain access to the site.
 *
 * @return  Returns a reference to the {@link MgSite} object.
 * @exception  MgConnectionNotOpenException if connection has not been opened
 */
 public MgSite GetSite() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSiteConnection_GetSite(swigCPtr);
    return (cPtr == 0) ? null : (MgSite)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates a site at the given url.
 *
 * @param  url  HTTP url for a site.
 */
 public MgSiteConnection(String url) throws MgException {
    this(MapGuideJavaApiJNI.new_MgSiteConnection__SWIG_1(url), true);
  }

}
