/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCoordinateCollection} provides support for defining an ordered set of
 * coordinates.
 *
 */
 public class MgCoordinateCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of coordinates in the collection.
 *
 * @return  Returns number of coordinates in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgCoordinateCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the coordinate in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the coordinate to retrieve.
 * @return  Returns the coordinate in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgCoordinate getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the coordinate in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgCoordinate})  Coordinate to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgCoordinate value) {
    MapGuideJavaApiExJNI.MgCoordinateCollection_SetItem(swigCPtr, index, MgCoordinate.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgCoordinate})  Coordinate to add to the collection.
 * @return  Returns nothing
 */
 public void add(MgCoordinate value) {
    MapGuideJavaApiExJNI.MgCoordinateCollection_Add(swigCPtr, MgCoordinate.getCPtr(value));
  }

  
/**
 * Inserts the specified coordinate at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgCoordinate})  Coordinate to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgCoordinate value) {
    MapGuideJavaApiExJNI.MgCoordinateCollection_Insert(swigCPtr, index, MgCoordinate.getCPtr(value));
  }

  
/**
 * Removes all coordinates from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgCoordinateCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified coordinate from the collection.  Returns false if
 * the coordinate could not be removed.
 *
 * @param  value ({@link MgCoordinate})  Coordinate reference to remove.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgCoordinate value) {
    return MapGuideJavaApiExJNI.MgCoordinateCollection_Remove(swigCPtr, MgCoordinate.getCPtr(value));
  }

  
/**
 * Removes the coordinate at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the coordinate to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgCoordinateCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified coordinate, false
 * otherwise.
 *
 * @param  value ({@link MgCoordinate})  Coordinate reference to check containment of.
 * @return  True if the collection contains the specified coordinate, false
 *  otherwise.
 */
 public boolean contains(MgCoordinate value) {
    return MapGuideJavaApiExJNI.MgCoordinateCollection_Contains(swigCPtr, MgCoordinate.getCPtr(value));
  }

  
/**
 * Returns the index of the specified coordinate in the collection or -1
 * if the coordinate does not exist.
 *
 * @param  value ({@link MgCoordinate})  Coordinate reference to find the index of.
 * @return  The index of the specified coordinate in the collection or -1 if the
 *  coordinate does not exist.
 */
 public int indexOf(MgCoordinate value) {
    return MapGuideJavaApiExJNI.MgCoordinateCollection_IndexOf(swigCPtr, MgCoordinate.getCPtr(value));
  }

  
/**
 * Construct a {@link MgCoordinateCollection} object
 *
 */
 public MgCoordinateCollection() {
    this(MapGuideJavaApiExJNI.new_MgCoordinateCollection(), true);
  }

}
