package org.osgeo.mapguide;


/**
 * Specifies the coordinate space for feature geometry returned from QueryFeatures.
 * Can also specify that only non-geometric data should be returned by QueryFeature.
 *
 */
public class MgCoordinateSpace
{
   
/**
 * Specifies that geometry properties should not be returned by QueryFeature.
 *
 */

   public static final String None  = "None"; /// \if INTERNAL  \endif 
   
/**
 * Specifies that geometry properties should be returned by QueryFeature in
 * the coordinate system space of the map they belong to.
 *
 */

   public static final String Map  = "Map"; /// \if INTERNAL  \endif 
   
/**
 * Specifies that geometry properties should be returned by QueryFeature in
 * the coordinate system space of the display in the client.
 *
 */

   public static final String Display  = "Display"; /// \if INTERNAL  \endif 
   
}

