/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * A geodetic (transformation) path allows to concatenate multiple
 * geodetic transformations. For example, converting between 2 datums
 * cannot be achieved by doing 1 datum shift only but requires to
 * do 1 or more datums shifts in between.
 *
 */
 public class MgCoordinateSystemGeodeticPath extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticPath(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGeodeticPathToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticPath() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGeodeticPath(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticPath obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the path name of this geodetic path
 *
 * @return  The path name of this geodetic path
 */
 public String getPathName() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetPathName(swigCPtr); }
}

  
/**
 * Sets the path name of this geodetic path
 *
 * @param  sName (String/string)  The path name
 */
 public void setPathName(String sName) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetPathName(swigCPtr, sName);
  }

  
/**
 * Gets the description of this geodetic path
 *
 * @return  The description of this geodetic path
 */
 public String getDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetDescription(swigCPtr); }
}

  
/**
 * Sets the description of this geodetic path
 *
 * @param  sDescription (String/string)  The description
 */
 public void setDescription(String sDescription) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetDescription(swigCPtr, sDescription);
  }

  
/**
 * Gets the group of this geodetic path
 *
 * @return  The group of this geodetic path
 */
 public String getGroup() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this geodetic path
 *
 * @param  sGroup (String/string)  The group
 */
 public void setGroup(String sGroup) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetGroup(swigCPtr, sGroup);
  }

  
/**
 * Gets the source of this geodetic path
 *
 * @return  The source of this geodetic path
 */
 public String getSource() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this geodetic path
 *
 * @param  sSource (String/string)  The source
 */
 public void setSource(String sSource) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetSource(swigCPtr, sSource);
  }

  
/**
 * Gets the target datum of this geodetic path
 *
 * @return  The target datum of this geodetic path
 */
 public String getTargetDatum() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetTargetDatum(swigCPtr); }
}

  
/**
 * Sets the target datum of this geodetic path
 *
 * @param  sTargetDatum (String/string)  The target datum
 */
 public void setTargetDatum(String sTargetDatum) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetTargetDatum(swigCPtr, sTargetDatum);
  }

  
/**
 * Gets the source datum of this geodetic path
 *
 * @return  The source datum of this geodetic path
 */
 public String getSourceDatum() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetSourceDatum(swigCPtr); }
}

  
/**
 * Sets the source datum of this geodetic path
 *
 * @param  sSourceDatum (String/string)  The source datum
 */
 public void setSourceDatum(String sSourceDatum) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetSourceDatum(swigCPtr, sSourceDatum);
  }

  
/**
 * Gets the accuracy of this geodetic path
 *
 * @return  The accuracy of this geodetic path
 */
 public double getAccuracy() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetAccuracy(swigCPtr);
  }

  
/**
 * Sets the accuracy of this geodetic path
 *
 * @param  accuracy (String/string)  The accuracy
 */
 public void setAccuracy(double accuracy) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetAccuracy(swigCPtr, accuracy);
  }

  
/**
 * Gets whether this geodetic path is reversible
 *
 * @return  true if this geodetic path is reversible
 */
 public boolean getIsReversible() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetIsReversible(swigCPtr);
  }

  
/**
 * Sets whether this geodetic path is reversible
 *
 * @param  isReversible (boolean/bool)  true if reversible. false otherwise
 */
 public void setIsReversible(boolean isReversible) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetIsReversible(swigCPtr, isReversible);
  }

  
/**
 * Gets the EPSG code of of this geodetic path
 *
 * @return  The EPSG code of this geodetic path
 */
 public int getEpsgCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetEpsgCode(swigCPtr);
  }

  
/**
 * Sets the EPSG code of of this geodetic path
 *
 * @param  epsgCode (int)  the EPSG code
 */
 public void setEpsgCode(int epsgCode) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetEpsgCode(swigCPtr, epsgCode);
  }

  
/**
 * Gets the EPSG variant of this geodetic path
 *
 * @return  The EPSG variant of this geodetic path
 */
 public int getEpsgVariant() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetEpsgVariant(swigCPtr);
  }

  
/**
 * Sets the EPSG variant of of this geodetic path
 *
 * @param  epsgVariant (int)  the EPSG variant
 */
 public void setEpsgVariant(int epsgVariant) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetEpsgVariant(swigCPtr, epsgVariant);
  }

  
/**
 * Returns an ordered collection of {@link MgCoordinateSystemGeodeticPathElement} objects
 * that form this geodetic transformation path. See remarks.
 *
 * @return  Returns a (possibly empty) collection of {@link MgCoordinateSystemGeodeticPathElement} instances.
 *  The caller is responsible for disposing the collection being returned.
 */
 public MgDisposableCollection getPathElements() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_GetPathElements(swigCPtr);
    return (cPtr == 0) ? null : (MgDisposableCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the individual transformation steps that form this geodetic transformation
 * path.
 *
 */
 public void setPathElements(MgDisposableCollection pathElements) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_SetPathElements(swigCPtr, MgDisposableCollection.getCPtr(pathElements));
  }

  
/**
 * Gets whether this geodetic path is protected
 *
 * @return  true if this geodetic path is protected. false otherwise
 */
 public boolean isProtected() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_IsProtected(swigCPtr);
  }

  
/**
 * Gets whether this geodetic path is valid
 *
 * @return  true if this geodetic path is valid. false otherwise
 */
 public boolean isValid() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_IsValid(swigCPtr);
  }

  
/**
 * Creates a new, unitialized {@link MgCoordinateSystemGeodeticPathElement} instance.
 * Calling this method does not affect the underlying dictionary file.
 * Typically, an API client will retrieve new objects through this method
 * so they can be added to the collection of path elements that can be set
 * via SetPathElements.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticPathElement} instance. The caller is responsible
 *  for disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticPathElement newPathElement() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_NewPathElement(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPathElement)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a deep clone of this geodetic path. That is, the cloned object
 * will also have its geodetic path element information cloned.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticPath} object that is an exact clone
 *  of this {@link MgCoordinateSystemGeodeticPath} instance. The caller is responsible for
 *  disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticPath createClone() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticPath_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPath)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
