/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * An instance of this class describes a geodetic transformation with all its parameters
 * as it is defined in the dictionary file. The actual transformation operation
 * is performed by the {@link MgCoordinateSystemGeodeticTransformation} objects
 * that's being returned by the CreateTransformation method.
 *
 */
 public class MgCoordinateSystemGeodeticTransformDef extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticTransformDef(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGeodeticTransformDefToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticTransformDef() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGeodeticTransformDef(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticTransformDef obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the transform name of this instance
 *
 * @return  The transform name of this instance
 */
 public String getTransformName() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetTransformName(swigCPtr); }
}

  
/**
 * Sets the transform name of this instance
 *
 * @param  name (String/string)  The transform name
 */
 public void setTransformName(String name) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetTransformName(swigCPtr, name);
  }

  
/**
 * Gets the source datum of this instance
 *
 * @return  The source datum of this instance
 */
 public String getSourceDatum() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetSourceDatum(swigCPtr); }
}

  
/**
 * Sets the source datum of this instance
 *
 * @param  datumKey (String/string)  The source datum
 */
 public void setSourceDatum(String datumKey) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetSourceDatum(swigCPtr, datumKey);
  }

  
/**
 * Gets the target datum of this instance
 *
 * @return  The target datum of this instance
 */
 public String getTargetDatum() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetTargetDatum(swigCPtr); }
}

  
/**
 * Sets the target datum of this instance
 *
 * @param  datumKey (String/string)  The target datum
 */
 public void setTargetDatum(String datumKey) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetTargetDatum(swigCPtr, datumKey);
  }

  
/**
 * Gets the group of this instance
 *
 * @return  The group of this instance
 */
 public String getGroup() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this instance
 *
 * @param  group (String/string)  The group
 */
 public void setGroup(String group) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetGroup(swigCPtr, group);
  }

  
/**
 * Gets the description of this instance
 *
 * @return  The description of this instance
 */
 public String getDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetDescription(swigCPtr); }
}

  
/**
 * Sets the description of this instance
 *
 * @param  description (String/string)  The description
 */
 public void setDescription(String description) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetDescription(swigCPtr, description);
  }

  
/**
 * Gets the source of this instance
 *
 * @return  The source of this instance
 */
 public String getSource() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this instance
 *
 * @param  source (String/string)  The source
 */
 public void setSource(String source) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetSource(swigCPtr, source);
  }

  
/**
 * Gets the EPSG code of this instance
 *
 * @return  The EPSG code of this instance
 */
 public int getEpsgCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetEpsgCode(swigCPtr);
  }

  
/**
 * Sets the EPSG code of this instance
 *
 * @param  epsgCode (int)  The EPSG code
 */
 public void setEpsgCode(int epsgCode) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetEpsgCode(swigCPtr, epsgCode);
  }

  
/**
 * Gets the EPSG variation of this instance
 *
 * @return  The EPSG variation of this instance
 */
 public int getEpsgVariation() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetEpsgVariation(swigCPtr);
  }

  
/**
 * Sets the EPSG variation of this instance
 *
 * @param  epsgVariation (int)  The EPSG variation
 */
 public void setEpsgVariation(int epsgVariation) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetEpsgVariation(swigCPtr, epsgVariation);
  }

  
/**
 * Gets whether the inverse is supported
 *
 * @return  true if this inverse is supported. false otherwise
 */
 public boolean getInverseSupported() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetInverseSupported(swigCPtr);
  }

  
/**
 * Sets whether the inverse is supported
 *
 * @param  inverseSupported (boolean/bool)  true if the inverse is supported. false otherwise
 */
 public void setInverseSupported(boolean inverseSupported) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetInverseSupported(swigCPtr, inverseSupported);
  }

  
/**
 * Gets the maximum iterations of this instance
 *
 * @return  The maximum iterations of this instance
 */
 public int getMaxIterations() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetMaxIterations(swigCPtr);
  }

  
/**
 * Sets the maximum iterations of this instance
 *
 * @param  maxIterations (int)  The maximum iterations
 */
 public void setMaxIterations(int maxIterations) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetMaxIterations(swigCPtr, maxIterations);
  }

  
/**
 * Gets the convergence value of this instance
 *
 * @return  The convergence value of this instance
 */
 public double getConvergenceValue() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetConvergenceValue(swigCPtr);
  }

  
/**
 * Sets the convergence value of this instance
 *
 * @param  convergenceValue (double)  The convergence value
 */
 public void setConvergenceValue(double convergenceValue) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetConvergenceValue(swigCPtr, convergenceValue);
  }

  
/**
 * Gets the error value of this instance
 *
 * @return  The error value of this instance
 */
 public double getErrorValue() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetErrorValue(swigCPtr);
  }

  
/**
 * Sets the error value of this instance
 *
 * @param  errorValue (double)  The error value
 */
 public void setErrorValue(double errorValue) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetErrorValue(swigCPtr, errorValue);
  }

  
/**
 * Gets the accuracy value of this instance
 *
 * @return  The accuracy value of this instance
 */
 public double getAccuracy() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetAccuracy(swigCPtr);
  }

  
/**
 * Sets the accuracy value of this instance
 *
 * @param  accuracy (double)  The accuracy value
 */
 public void setAccuracy(double accuracy) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetAccuracy(swigCPtr, accuracy);
  }

  
/**
 * Gets the minimum range longitude of this instance
 *
 * @return  The minimum range longitude of this instance
 */
 public double getRangeMinLongitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMinLongitude(swigCPtr);
  }

  
/**
 * Sets the minimum range longitude of this instance
 *
 * @param  minLong (double)  The minimum range longitude
 */
 public void setRangeMinLongitude(double minLong) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMinLongitude(swigCPtr, minLong);
  }

  
/**
 * Gets the maximum range longitude of this instance
 *
 * @return  The maximum range longitude of this instance
 */
 public double getRangeMaxLongitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMaxLongitude(swigCPtr);
  }

  
/**
 * Sets the maximum range longitude of this instance
 *
 * @param  maxLong (double)  The maximum range longitude
 */
 public void setRangeMaxLongitude(double maxLong) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMaxLongitude(swigCPtr, maxLong);
  }

  
/**
 * Gets the minimum range latitude of this instance
 *
 * @return  The minimum range latitude of this instance
 */
 public double getRangeMinLatitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMinLatitude(swigCPtr);
  }

  
/**
 * Sets the minimum range latitude of this instance
 *
 * @param  minLat (double)  The minimum range latitude
 */
 public void setRangeMinLatitude(double minLat) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMinLatitude(swigCPtr, minLat);
  }

  
/**
 * Gets the maximum range latitude of this instance
 *
 * @return  The maximum range latitude of this instance
 */
 public double getRangeMaxLatitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetRangeMaxLatitude(swigCPtr);
  }

  
/**
 * Sets the maximum range latitude of this instance
 *
 * @param  maxLat (double)  The maximum range latitude
 */
 public void setRangeMaxLatitude(double maxLat) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetRangeMaxLatitude(swigCPtr, maxLat);
  }

  
/**
 * Gets whether this instance is protected
 *
 * @return  true if this instance is protected. false otherwise
 */
 public boolean isProtected() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_IsProtected(swigCPtr);
  }

  
/**
 * Gets whether this instance is valid
 *
 * @return  true if this instance is valid. false otherwise
 */
 public boolean isValid() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_IsValid(swigCPtr);
  }

  
/**
 * Returns the type of this geodetic transformation (as defined by {@link MgCoordinateSystemGeodeticTransformDefType}).
 * The type defines the parameters that are being returned by the GetParameters method.
 *
 */
 public int getTransformDefType() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetTransformDefType(swigCPtr);
  }

  
/**
 * Returns the extended parameters object valid for this transformation definition. See remarks.
 * Depending on the type returned by GetTransformDefType(), this method returns one of the following:
 *
 * @return  Returns the extended parameters (or NULL) object for this transformation object. The
 *  caller is responsible for disposing the object being returned. See remarks.
 */
 public MgCoordinateSystemGeodeticTransformDefParams getParameters() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_GetParameters(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDefParams)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the extended parameters for this transformation.
 *
 * @param  parameters  The parameters to set for this transformation. The object passed in,  has to be of the same type as it has been returned by GetParameters. Otherwise,  an exception will be thrown. This parameter must not be NULL. Creating a transformation that  is supposed to do nothing except for allowing to switch from one datum to another (that is considered to be equal),  requires to create standalone transformation of type NullX.
 */
 public void setParameters(MgCoordinateSystemGeodeticTransformDefParams parameters) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_SetParameters(swigCPtr, MgCoordinateSystemGeodeticTransformDefParams.getCPtr(parameters));
  }

  
/**
 * Creates a deep clone of this geodetic transformation. That is, the cloned object
 * will also have its extended parameters cloned.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticTransformDef} object that is an exact clone
 *  of this {@link MgCoordinateSystemGeodeticTransformDef} instance. The caller is responsible for
 *  disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticTransformDef createClone() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDef)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a new {@link MgCoordinateSystemGeodeticTransformation} object that
 * can be used to perform the actual transformation this transformation
 * definition describes. This method will fail with an exception,
 * if this is the NONE transformation.
 *
 * @param  createInverse  If true, the {@link MgCoordinateSystemGeodeticTransformation} being returned will  perform the inverse of the transformation as defined in the dictionary file. That is,  it will convert from the actual target datum to the source datum. Note, that not all  transformations are invertible. This method will fail with an exception then.  If false, this method will return a {@link MgCoordinateSystemGeodeticTransformation}  instance that performs the default forward datum transformation.
 * @return  Returns the {@link MgCoordinateSystemGeodeticTransformation} that performs the actual
 *  datum transformation as described by this definition instance. The caller
 *  is reponsible for disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticTransformation createTransformation(boolean createInverse) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformDef_CreateTransformation(swigCPtr, createInverse);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformation)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
