/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCoordinateSystemGridSpecification} is an object that is used to
 * convey all the parameters necessary for the generation of a grid/graticule
 * lumped into a single object for convenience.  Thus, adding a parameter
 * determined to be necessary at a later time does not alter a lot of calling
 * sequences.
 * Note that this interface is an abstract interface.  There is code
 * associated with the implementation of this interface which is used to
 * handle the conversion of parameters between the various unit systems.
 * Thus, one obtains a {@link MgCoordinateSystemGridSpecification} from the
 * {@link MgCoordinateSystemFactory} object.
 * Note that all values are provided in the units specified within the object.
 * The units used in this object do <b>not</b> need to be the same as any
 * coordinate system involved in the generation of a grid, although the
 * <b>type</b> of unit must be consistent with the type of grid being drawn.
 * That is, specifying a Angular unit type when drawing a UTM grid will cause
 * an exception at the time the request for (say) grid lines is issued.
 *
 * @since  2.2 */
 public class MgCoordinateSystemGridBase extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGridBase(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGridBaseToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGridBase() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGridBase(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGridBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the specialized type of this grid instance. Value can be any value from {@link MgCoordinateSystemGridSpecializationType}
 *
 * @return  The specialized type of this grid instance ({@link MgCoordinateSystemGridSpecializationType})
 */
 public int getSpecializationType() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetSpecializationType(swigCPtr);
  }

  
/**
 * Sets the boundary of this grid instance
 *
 * @param  pGridBoundary ({@link MgCoordinateSystemGridBoundary})  The boundary
 */
 public void setBoundary(MgCoordinateSystemGridBoundary pGridBoundary) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_SetBoundary(swigCPtr, MgCoordinateSystemGridBoundary.getCPtr(pGridBoundary));
  }

  public MgCoordinateSystemGridBoundary getBoundary() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetBoundary(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBoundary)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the grid lines for this grid instance for the given grid specification
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The collection of grid lines
 */
 public MgCoordinateSystemGridLineCollection getGridLines(MgCoordinateSystemGridSpecification specification) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetGridLines(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
    return (cPtr == 0) ? null : (MgCoordinateSystemGridLineCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the grid regions for this grid instance for the given grid specification
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The collection of grid regions
 */
 public MgCoordinateSystemGridRegionCollection getGridRegions(MgCoordinateSystemGridSpecification specification) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetGridRegions(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
    return (cPtr == 0) ? null : (MgCoordinateSystemGridRegionCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Generates grid ticks for the grid boundary.
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The collection of grid ticks for the grid boundary
 */
 public MgCoordinateSystemGridTickCollection getGridTicks(MgCoordinateSystemGridSpecification specification) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetGridTicks(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
    return (cPtr == 0) ? null : (MgCoordinateSystemGridTickCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the convergence angle for the given location
 *
 * @param  location ({@link MgCoordinate})  The location
 * @return  The convergence angle for the given location
 */
 public double getConvergenceAngle(MgCoordinate location) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetConvergenceAngle(swigCPtr, MgCoordinate.getCPtr(location));
  }

  
/**
 * Gets the projective grid scale for the given location
 *
 * @param  location ({@link MgCoordinate})  The location
 * @return  The projective grid scale for the given location
 */
 public double getProjectiveGridScale(MgCoordinate location) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetProjectiveGridScale(swigCPtr, MgCoordinate.getCPtr(location));
  }

  
/**
 * Calculates the approximate amount of memory required to generated grid lines for this instance
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The approximate memory usage in bytes
 */
 public int approxGridLineMemoryUsage(MgCoordinateSystemGridSpecification specification) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_ApproxGridLineMemoryUsage(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
  }

  
/**
 * Calculates the approximate amount of memory required to generated grid regions for this instance
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The approximate memory usage in bytes
 */
 public int approxGridRegionMemoryUsage(MgCoordinateSystemGridSpecification specification) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_ApproxGridRegionMemoryUsage(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
  }

  
/**
 * Calculates the approximate amount of memory required to generated grid ticks for this instance
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The grid specification
 * @return  The approximate memory usage in bytes
 */
 public int approxGridTickMemoryUsage(MgCoordinateSystemGridSpecification specification) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_ApproxGridTickMemoryUsage(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
  }

  
/**
 * Sets the amount of memory at which an exception will be thrown if generating a grid line
 * collection that would exceed the specified value in memory usage
 *
 * @param  memoryUseMax (int)  The memory limit in bytes
 * @return  The new memory limit
 */
 public int setGridLineExceptionLevel(int memoryUseMax) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_SetGridLineExceptionLevel(swigCPtr, memoryUseMax);
  }

  
/**
 * Sets the amount of memory at which an exception will be thrown if generating a grid region
 * collection that would exceed the specified value in memory usage
 *
 * @param  memoryUseMax (int)  The memory limit in bytes
 * @return  The new memory limit
 */
 public int setGridRegionExceptionLevel(int memoryUseMax) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_SetGridRegionExceptionLevel(swigCPtr, memoryUseMax);
  }

  
/**
 * Sets the amount of memory at which an exception will be thrown if generating a grid tick
 * collection that would exceed the specified value in memory usage
 *
 * @param  memoryUseMax (int)  The memory limit in bytes
 * @return  The new memory limit
 */
 public int setGridTickExceptionLevel(int memoryUseMax) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_SetGridTickExceptionLevel(swigCPtr, memoryUseMax);
  }

  
/**
 * Returns the last error code
 *
 * @return  The last error code
 */
 public int getLastError() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_GetLastError(swigCPtr);
  }

  
/**
 * Resets the last error code
 *
 */
 public void resetLastError() {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_ResetLastError(swigCPtr);
  }

  
/**
 * Gets whether exceptions are enabled for this instance
 *
 * @return  true if exceptions are enabled. false otherwise
 */
 public boolean areExceptionsOn() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_AreExceptionsOn(swigCPtr);
  }

  
/**
 * Enables or disables exceptions for this instance
 *
 * @param  bOn (boolean/bool)  true to enable exceptions. false to disable exceptions
 */
 public void setExceptionsOn(boolean bOn) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridBase_SetExceptionsOn(swigCPtr, bOn);
  }

}
