/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCoordinateSystemGridSpecification} is an object that is used to
 * convey all the parameters necessary for the generation of a grid/graticule
 * lumped into a single object for convenience.  Thus, adding a parameter
 * determined to be necessary at a later time does not alter a lot of calling
 * sequences.
 * Note that this interface is an abstract interface.  There is code
 * associated with the implementation of this interface which is used to
 * handle the conversion of parameters between the various unit systems.
 * Thus, one obtains a {@link MgCoordinateSystemGridSpecification} from the
 * {@link MgCoordinateSystemFactory} object.
 * Note that all values are provided in the units specified within the object.
 * The units used in this object do <b>not</b> need to be the same as any
 * coordinate system involved in the generation of a grid, although the
 * <b>type</b> of unit must be consistent with the type of grid being drawn.
 * That is, specifying a Angular unit type when drawing a UTM grid will cause
 * an exception at the time the request for (say) grid lines is issued.
 *
 * @since  2.2 */
 public class MgCoordinateSystemGridLine extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGridLine(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGridLineToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGridLine() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGridLine(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGridLine obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public int getGridOrientation() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_GetGridOrientation(swigCPtr);
  }

  public double getRealValue() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_GetRealValue(swigCPtr);
  }

  public int getCount() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_GetCount(swigCPtr);
  }

  
/**
 * Gets the line segment at the specified index
 *
 * @param  index (int)  The index at which to retrieve the line segment
 * @return  The {@link MgLineString} at the specified index
 */
 public MgLineString getSegment(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_GetSegment(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLineString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  public MgLineStringCollection getSegmentCollection() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_GetSegmentCollection(swigCPtr);
    return (cPtr == 0) ? null : (MgLineStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the entire line segment collection
 *
 * @param  segmentCollection ({@link MgLineStringCollection})  The line segment collection
 */
 public void setSegmentCollection(MgLineStringCollection segmentCollection) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridLine_SetSegmentCollection(swigCPtr, MgLineStringCollection.getCPtr(segmentCollection));
  }

}
