/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCoordinateSystemGridSpecification} is an object that is used to
 * convey all the parameters necessary for the generation of a grid/graticule
 * lumped into a single object for convenience.  Thus, adding a parameter
 * determined to be necessary at a later time does not alter a lot of calling
 * sequences.
 * Note that this interface is an abstract interface.  There is code
 * associated with the implementation of this interface which is used to
 * handle the conversion of parameters between the various unit systems.
 * Thus, one obtains a {@link MgCoordinateSystemGridSpecification} from the
 * {@link MgCoordinateSystemFactory} object.
 * Note that all values are provided in the units specified within the object.
 * The units used in this object do <b>not</b> need to be the same as any
 * coordinate system involved in the generation of a grid, although the
 * <b>type</b> of unit must be consistent with the type of grid being drawn.
 * That is, specifying a Angular unit type when drawing a UTM grid will cause
 * an exception at the time the request for (say) grid lines is issued.
 *
 * @since  2.2 */
 public class MgCoordinateSystemGridSpecification extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGridSpecification(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGridSpecificationToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGridSpecification() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGridSpecification(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGridSpecification obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public double getEastingBase() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetEastingBase(swigCPtr);
  }

  public double getNorthingBase() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetNorthingBase(swigCPtr);
  }

  public double getEastingIncrement() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetEastingIncrement(swigCPtr);
  }

  public double getNorthingIncrement() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetNorthingIncrement(swigCPtr);
  }

  public double getTickEastingIncrement() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetTickEastingIncrement(swigCPtr);
  }

  public double getTickNorthingIncrement() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetTickNorthingIncrement(swigCPtr);
  }

  public int getUnitType() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetUnitType(swigCPtr);
  }

  public int getUnitCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetUnitCode(swigCPtr);
  }

  
/**
 * Determines if two {@link MgCoordinateSystemGridSpecification} objects are the
 * same.
 *
 * @param  specification ({@link MgCoordinateSystemGridSpecification})  The second object to which the host object is to be compared to.
 * @return  Returns true if the objects are identical.
 */
 public boolean isSameAs(MgCoordinateSystemGridSpecification specification) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_IsSameAs(swigCPtr, MgCoordinateSystemGridSpecification.getCPtr(specification));
  }

  public double getCurvePrecision() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_GetCurvePrecision(swigCPtr);
  }

  
/**
 * Sets the easting and northing base values.
 *
 * @param  eastingBase (double)  The base value to be used in calculating the easting grid and tick  values.
 * @param  northingBase (double)  The base value to be used in calculating the northing grid and tick  values.
 */
 public void setGridBase(double eastingBase, double northingBase) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetGridBase(swigCPtr, eastingBase, northingBase);
  }

  
/**
 * Sets the easting and northing grid line increment values.
 *
 * @param  eastingIncrement (double)  The distance between easting grid lines.
 * @param  northingIncrement (double)  The distance between northing grid lines.
 */
 public void setGridIncrement(double eastingIncrement, double northingIncrement) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetGridIncrement(swigCPtr, eastingIncrement, northingIncrement);
  }

  
/**
 * Sets the easting and northing tick increment values.
 *
 * @param  eastingIncrement (double)  The distance between easting tick marks.
 * @param  northingIncrement (double)  The distance between northing tick marks.
 */
 public void setTickIncrements(double eastingIncrement, double northingIncrement) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetTickIncrements(swigCPtr, eastingIncrement, northingIncrement);
  }

  
/**
 * Sets the units used to define the desired grid.
 *
 * @param  unitCode (int)  One of the integer values defined in the {@link MgCoordinateSystemUnitCode}  object which indicates the units used to define the grid parameters.
 * @param  unitType (int)  One of the integer values defined in the {@link MgCoordinateSystemUnitType}  object which indicates the type of units (linear vs angular) used to  define the grid parameters.
 */
 public void setUnits(int unitCode, int unitType) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetUnits(swigCPtr, unitCode, unitType);
  }

  
/**
 * Sets the desired precision of complex curve approximations.
 *
 * @param  curvePrecision (double)  The desired maximum distance between an approximation of a complex curve  and the true curve.
 */
 public void setCurvePrecision(double curvePrecision) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetCurvePrecision(swigCPtr, curvePrecision);
  }

  
/**
 * Sets the maximum number of points to generate for a complex curve
 * approximation.
 *
 * @param  maxCurvePoints (INT32)  The desired maximum number of points to be generated for a complex  curve approximation.  Default is 511.
 */
 public void setMaxCurvePoints(int maxCurvePoints) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_SetMaxCurvePoints(swigCPtr, maxCurvePoints);
  }

  public boolean isConsistent() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGridSpecification_IsConsistent(swigCPtr);
  }

}
