package org.osgeo.mapguide;


/**
 * Defines constants used to indicate the type of a coordinate
 * system.
 *
 */
public class MgCoordinateSystemType
{
   
/**
 * Specifies the coordinate system is not set.
 *
 */

   public static final int Unknown = 0 ; 
   
/**
 * Specifies that the coordinate system is arbitrary. That is,
 * it is not spatially bound to the earth, and the initial
 * keyword in the WKT definition of the coordinate system is
 * LOCAL_CS.
 *
 */

   public static final int Arbitrary = 1 ; 
   
/**
 * Specifies that the coordinate system is geographic. That is,
 * the initial keyword in the WKT definition of the coordinate
 * system is GEOGCS.
 *
 */

   public static final int Geographic = 2 ; 
   
/**
 * Specifies that the coordinate system is projected. In most
 * cases, the initial keyword in the WKT definition of the
 * coordinate system is PROJCS. In some cases, the initial
 * keyword is GEOGCS.
 *
 */

   public static final int Projected = 3 ; 
   
}

