/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Represents a collection of feature commands.
 *
 */
 public class MgFeatureCommandCollection extends MgSerializable {
  private long swigCPtr;

  public MgFeatureCommandCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgFeatureCommandCollectionToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgFeatureCommandCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgFeatureCommandCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of commands in the collection.
 *
 * @return  Returns number of commands in the collection
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgFeatureCommandCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the command in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the command in the collection at the specified index
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public MgFeatureCommand getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureCommandCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgFeatureCommand)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the command in the collection at the specified index to the specified command.
 * If there was already command assigned to specified index, it will be overwritten.
 *
 * @param  index (int)  Input index
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void setItem(int index, MgFeatureCommand command) {
    MapGuideJavaApiExJNI.MgFeatureCommandCollection_SetItem(swigCPtr, index, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Adds the specified command to the end of the collection.
 *
 * @param  command ({@link MgFeatureCommand})  One of type {@link MgDeleteFeatures}, {@link MgInsertFeatures},  or {@link MgUpdateFeatures}
 * @return  Returns nothing.
 */
 public void add(MgFeatureCommand command) {
    MapGuideJavaApiExJNI.MgFeatureCommandCollection_Add(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Inserts the specified command at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new command.
 *
 * @param  index (int)  Input index
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void insert(int index, MgFeatureCommand command) {
    MapGuideJavaApiExJNI.MgFeatureCommandCollection_Insert(swigCPtr, index, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Removes all commands from the collection.
 *
 * @return  Returns nothing
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgFeatureCommandCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified command from the collection.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgFeatureCommand command) {
    return MapGuideJavaApiExJNI.MgFeatureCommandCollection_Remove(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Removes the specified command from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgFeatureCommandCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified command, false otherwise.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns true if the collection contains the specified command, false otherwise
 */
 public boolean contains(MgFeatureCommand command) {
    return MapGuideJavaApiExJNI.MgFeatureCommandCollection_Contains(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Returns the index of the specified command in the collection or -1 if the command does not exist.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns the index of the specified command in the collection or -1 if the command does not exist
 */
 public int indexOf(MgFeatureCommand command) {
    return MapGuideJavaApiExJNI.MgFeatureCommandCollection_IndexOf(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Constructor.  Creates an empty collection of feature commands.
 *
 */
 public MgFeatureCommandCollection() {
    this(MapGuideJavaApiExJNI.new_MgFeatureCommandCollection(), true);
  }

}
