package org.osgeo.mapguide;


/**
 * Is a set of constants specifying the dimensions of geometries
 * which can be stored in a geometry property.
 *
 */
public class MgFeatureGeometricType
{
   
/**
 * Represents zero-dimensional geometric primitives, such as
 * {@link MgPoint}.
 *
 */

   public static final int Point = 1 ; 
   
/**
 * Represents one-dimensional geometric primitives, such as
 * {@link MgLineString} and {@link MgCurveString}.
 *
 */

   public static final int Curve = 2 ; 
   
/**
 * Represents two-dimensional geometric primitives, such as
 * {@link MgPolygon} and {@link MgCurvePolygon}.
 *
 */

   public static final int Surface = 4 ; 
   
/**
 * Represents three-dimensional geometric primitives, such as
 * Cubes.
 *
 */

   public static final int Solid = 8 ; 
   
}

