/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Use this class to set filter criteria for selecting features
 *
 */
 public class MgFeatureQueryOptions extends MgSerializable {
  private long swigCPtr;

  public MgFeatureQueryOptions(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgFeatureQueryOptionsToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgFeatureQueryOptions(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgFeatureQueryOptions obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgFeatureQueryOptions} object.
 *
 */
 public MgFeatureQueryOptions() {
    this(MapGuideJavaApiExJNI.new_MgFeatureQueryOptions(), true);
  }

  
/**
 * Call this method for each class property whose value you want
 * retrieved by the {@link MgFeatureService}::SelectFeatures() call. Not
 * calling this method results in the retrieval of all property
 * values for each feature selected.
 *
 * @param  propertyName (String/string)  The name of the class property to  be added.
 * @return  Returns the total number of properties added.
 * @exception  MgInvalidArgumentException if property name is empty
 */
 public int addFeatureProperty(String propertyName) {
    return MapGuideJavaApiExJNI.MgFeatureQueryOptions_AddFeatureProperty(swigCPtr, propertyName);
  }

  
/**
 * Define an alias for a computed property and an expression for
 * what is to be computed. In this SQL example, "select
 * min(aDouble + aSingle) as minF, min(anInt16 + anInt16) as
 * minI from featclass;", minF and minI are computed properties.
 * Call this method for each computed property that you add.
 *
 * @param  aliasName (String/string)  The name of the computed property.
 * @param  expression (String/string)  The expression to be associated with  the name of the computed property.
 * @return  Returns the total number of properties added.
 * @exception  MgInvalidArgumentException if aliasName or expression is empty
 */
 public int addComputedProperty(String aliasName, String expression) {
    return MapGuideJavaApiExJNI.MgFeatureQueryOptions_AddComputedProperty(swigCPtr, aliasName, expression);
  }

  
/**
 * Sets the filter for this select operation. The filter acts
 * like the where clause in an SQL Select statement. Not calling
 * this method causes all instances of the feature class to be
 *
 * @param  filterText (String/string)  The filter text to be applied.
 * @return  Returns nothing.
 *  <!-- Example -->
 * @exception  MgInvalidArgumentException
 */
 public void setFilter(String filterText) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_SetFilter(swigCPtr, filterText);
  }

  
/**
 * Use this method to join a regular filter with a spatial
 * filter An argument of TRUE results in an AND join, and an
 * argument of FALSE results in an OR join. The binary operator
 * applies only when both the SetFilter() and SetSpatialFilter()
 * methods have been called. If both have been called and
 * SetBinaryOperator() has not been called, an AND join is
 * applied.
 *
 * @param  andOr (boolean/bool)  If true, apply an AND join; otherwise  apply an OR join.
 * @return  Nothing
 */
 public void setBinaryOperator(boolean andOr) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_SetBinaryOperator(swigCPtr, andOr);
  }

  
/**
 * Use this method to select features whose geometry property
 * satisfies the relationship argument to the geometry argument.
 * The effect is geometryProperty.spatialOperation(geometryArg).
 * By default this filter is joined by the AND operator with the
 *
 * @param  geometryProperty (String/string)  The name of the geometry property belonging the  features selected from the datastore
 * @param  geometry ({@link MgGeometry})  The geometry object set in relation to the  geometry property.
 * @param  spatialOperation (int)  The spatial operation to perform between the  lefthand operand (the geometry property) and  the righthand operand (the geometry object).  The spatial operation value of is one of the  {@link MgFeatureSpatialOperations} types.
 * @return  Returns nothing.
 * @exception  MgInvalidArgumentException
 */
 public void setSpatialFilter(String geometryProperty, MgGeometry geometry, int spatialOperation) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_SetSpatialFilter(swigCPtr, geometryProperty, MgGeometry.getCPtr(geometry), spatialOperation);
  }

  
/**
 * Use this method to specify the order (ascending or
 * descending) in which the selected features are returned.
 *
 * @param  orderByProperties ({@link MgStringCollection})  The collection of properties to which the  ordering option specified in the second  parameter is applied.
 * @param  orderOption (int)  The ordering option,  {@link MgOrderingOption}::Ascending or  {@link MgOrderingOption}::Descending.
 * @return  Nothing
 * @exception  MgInvalidArgumentException
 */
 public void setOrderingFilter(MgStringCollection orderByProperties, int orderOption) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_SetOrderingFilter(swigCPtr, MgStringCollection.getCPtr(orderByProperties), orderOption);
  }

  
/**
 * Removes a class property.
 *
 * @param  propertyName (String/string)  The name of the class property to  be removed.
 * @return  Returns the total number of properties remaining.
 * @exception  MgInvalidArgumentException
 */
 public void removeFeatureProperty(String propertyName) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_RemoveFeatureProperty(swigCPtr, propertyName);
  }

  
/**
 * Removes a computed property.
 *
 * @param  aliasName (String/string)  The name of the computed property to  be removed.
 * @return  Returns the total number of properties remaining.
 * @exception  MgInvalidArgumentException
 */
 public void removeComputedProperty(String aliasName) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_RemoveComputedProperty(swigCPtr, aliasName);
  }

  
/**
 * For queries that return a large number of objects
 * some feature sources support improving performance by setting
 * fetch size in order to reduce the number of database server
 * round trips required to satisfy the selection criteria.
 * Providers that do not use a fetch size will ignore the fetch
 * size parameter. This does not affect the actual results of
 * queries as it is a performance tuning parameter.
 *
 * @param  fetchSize (int)  The fetch size of query. The query returns all of query  results if setting the fetch size to 0.
 * @return  Returns nothing.
 */
 public void setFetchSize(int fetchSize) {
    MapGuideJavaApiExJNI.MgFeatureQueryOptions_SetFetchSize(swigCPtr, fetchSize);
  }

}
