/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides an abstraction layer for the storage and retrieval
 * of feature data in a technology-independent way. The API
 * lets you determine what storage technologies are available
 * and what capabilities they have. Access to the storage
 * technology is modeled as a connection. For example, you can
 * connect to a file and do simple insertions or connect to a
 * relational database and do transaction-based operations.
 *
 */
 public class MgFeatureService extends MgService {
  private long swigCPtr;

  public MgFeatureService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgFeatureServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgFeatureService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgFeatureService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgFeatureService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets a list of the available FDO providers together with
 * other information such as the names of the connection
 * properties for each provider. This information is in XML
 *
 * @return  Returns an {@link MgByteReader} containing the provider registry in
 *  XML format.
 * @exception  MgFdoException
 */
 public MgByteReader getFeatureProviders() {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetFeatureProviders(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets a set of connection values that are used to make
 * connections to an FDO provider that permits multiple
 * connections.
 *
 * @param  providerName (String/string)  The name of the Fdo feature provider. Permissible
 * @param  propertyName (String/string)  The name of the enumerable property for which  values need to be retrieved. Connection property  names are contained in the output of the  {@link MgFeatureService}::GetFeatureProviders method.  The value of the ConnectionProperty element's  Enumerable attribute must be true.
 * @param  partialConnString (String/string)  A partial connection string, which is sufficient  to connect to a provider.
 * @return  Returns an {@link MgStringCollection} or NULL, if nothing is found.
 *  <!-- Examples (PHP) -->
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgStringCollection getConnectionPropertyValues(String providerName, String propertyName, String partialConnString) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetConnectionPropertyValues(swigCPtr, providerName, propertyName, partialConnString);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Connects to the Feature Provider specified in the connection
 *
 * @param  providerName (String/string)  The name of the Fdo feature provider. Permissible
 * @param  connectionString (String/string)  Connection string for Feature Provider. Connection  property names that appear in the connection string  as keys can be obtained from the output of  GetFeatureProviders method. Look at the  //FeatureProviderRegistry/FeatureProvider/ConnectionProperties/ConnectionProperty/Name  elements.
 * @return  Returns true if the connection was successful; otherwise
 *  returns false.
 * @exception  MgFdoException
 */
 public boolean testConnection(String providerName, String connectionString) {
    return MapGuideJavaApiExJNI.MgFeatureService_TestConnection__SWIG_0(swigCPtr, providerName, connectionString);
  }

  
/**
 * Connects to the feature source specified by the resource
 * identifier and verifies that the feature source has been
 * correctly configured and installed in the resource
 *
 * @param  resource ({@link MgResourceIdentifier})  The resource identifier for the  feature source.
 * @return  Returns true if connection was successful; otherwise returns
 *  false.
 * @exception  MgFdoException
 */
 public boolean testConnection(MgResourceIdentifier resource) {
    return MapGuideJavaApiExJNI.MgFeatureService_TestConnection__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource));
  }

  
/**
 * Gets the capabilities of an FDO Provider expressed in XML
 *
 * @param  providerName (String/string)  The name of the FDO provider. Get the exact  form of the name from  {@link MgFeatureService}::GetFeatureProviders.
 * @return  Returns an {@link MgByteReader} containing the capabilities in XML
 *  format (or NULL).
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgByteReader getCapabilities(String providerName) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetCapabilities__SWIG_0(swigCPtr, providerName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the capabilities of an FDO Provider expressed in XML
 *
 * @param  providerName (String/string)  The name of the FDO provider. Get the exact  form of the name from  {@link MgFeatureService}::GetFeatureProviders.
 * @param  connectionString (String/string)  The connection string to use.
 * @return  Returns an {@link MgByteReader} containing the capabilities in XML
 *  format (or NULL).
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  2.3 */
 public MgByteReader getCapabilities(String providerName, String connectionString) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetCapabilities__SWIG_1(swigCPtr, providerName, connectionString);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates or updates a feature schema within the specified feature source. For this method to
 * actually delete any schema elements, the matching elements in the input schema must be marked
 * for deletion using the {@link MgFeatureSchema}::Delete(), {@link MgClassDefinition}::Delete() and
 * {@link MgPropertyDefinition}::Delete() methods
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier referring to a feature source.
 * @param  schema  Input schema to be created or updated.
 * @return  Returns nothing.
 * @since  2.2 */
 public void applySchema(MgResourceIdentifier resource, MgFeatureSchema schema) {
    MapGuideJavaApiExJNI.MgFeatureService_ApplySchema(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgFeatureSchema.getCPtr(schema));
  }

  
/**
 * Gets the definitions of one or more schemas contained in the
 * feature source for particular classes. If the specified schema name or
 * a class name does not exist, this method will throw an exception.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature source.
 * @param  schemaName (String/string)  The name of the schema definition to retrieve. If this string is empty,  execution of the command will describe requested classes using the  qualified class name. If the class name is not qualified, the requested  class from all schemas will be described.
 * @param  classNames ({@link MgStringCollection})  A collection of strings identifying the feature classes for which to  retrieve schema information. If this collection is null or empty,  execution of the command will describe all classes.  If the class name is not qualified, and the schema name is not specified,  the requested class from all schemas will be described.  The class names specified serve only as a hint. Use of the hint  during command execution is provider dependent. Providers that  will not use the hint will describe the schema for all classes.
 * @return  Returns the schema collection representing the schema containing
 *  the class collection for the specified classes.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  2.1 */
 public MgFeatureSchemaCollection describeSchema(MgResourceIdentifier resource, String schemaName, MgStringCollection classNames) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_DescribeSchema__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName, MgStringCollection.getCPtr(classNames));
    return (cPtr == 0) ? null : (MgFeatureSchemaCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the definitions of one or more schema contained in the
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  schemaName (String/string)  The name of the schema definition to  retrieve or an empty string to retrieve  all available schema definitions.
 * @return  Returns an {@link MgFeatureSchemaCollection}.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
@Deprecated
 public MgFeatureSchemaCollection describeSchema(MgResourceIdentifier resource, String schemaName) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_DescribeSchema__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName);
    return (cPtr == 0) ? null : (MgFeatureSchemaCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the definitions in XML format of one or more schemas contained in the
 * feature source for particular classes. If the specified schema name or
 * a class name does not exist, this method will throw an exception.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature source.
 * @param  schemaName (String/string)  The name of the schema definition to retrieve. If this string is empty,  execution of the command will describe requested classes using the  qualified class name. If the class name is not qualified, the requested  class from all schemas will be described.
 * @param  classNames ({@link MgStringCollection})  A collection of strings identifying the feature classes for which to  retrieve schema information. If this collection is null or empty,  execution of the command will describe all classes.  If the class name is not qualified, and the schema name is not specified,  the requested class from all schemas will be described.  The class names specified serve only as a hint. Use of the hint  during command execution is provider dependent. Providers that  will not use the hint will describe the schema for all classes.
 * @return  Returns a string containing the FDO schema in XML format.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  2.1 */
 public String describeSchemaAsXml(MgResourceIdentifier resource, String schemaName, MgStringCollection classNames) {
  { return MapGuideJavaApiExJNI.MgFeatureService_DescribeSchemaAsXml__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName, MgStringCollection.getCPtr(classNames)); }
}

  
/**
 * Gets the definition in XML format of a schema contained in
 *
 * @param  resource ({@link MgResourceIdentifier})  The resource identifier for the feature  source
 * @param  schemaName (String/string)  The name of the schema definition to  retrieve or an empty string to retrieve  all available schema definitions.
 * @return  Returns a string containing the FDO schema in XML format.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
@Deprecated
 public String describeSchemaAsXml(MgResourceIdentifier resource, String schemaName) {
  { return MapGuideJavaApiExJNI.MgFeatureService_DescribeSchemaAsXml__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName); }
}

  
/**
 * Translates the FDO schema information in the provided
 * {@link MgFeatureSchemaCollection} object into a string containing an
 * XML representation of the schema definitions in the feature
 *
 * @param  schema ({@link MgFeatureSchemaCollection})  A FeatureSchemaCollection  object.
 * @return  Returns a string containiing a set of FDO schema definitions
 *  in XML format.
 * @exception  MgFeatureServiceException
 * @exception  MgNullArgumentException
 * @exception  MgFdoException
 */
 public String schemaToXml(MgFeatureSchemaCollection schema) {
  { return MapGuideJavaApiExJNI.MgFeatureService_SchemaToXml(swigCPtr, MgFeatureSchemaCollection.getCPtr(schema)); }
}

  
/**
 * Creates an {@link MgFeatureSchemaCollection} object using the XML
 * schema provided
 *
 * @param  xml (String/string)  A string containing schema definitions  in XML format.
 * @return  Returns an {@link MgFeatureSchemaCollection} object.
 * @exception  MgNullArgumentException
 * @exception  MgFdoException
 */
 public MgFeatureSchemaCollection xmlToSchema(String xml) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_XmlToSchema(swigCPtr, xml);
    return (cPtr == 0) ? null : (MgFeatureSchemaCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. If you want to apply the criteria to a subset of the
 * features, use {@link MgFeatureService}::SelectAggregate.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class from which  the properties of interest are selected.
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgFeatureReader selectFeatures(MgResourceIdentifier resource, String className, MgFeatureQueryOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_SelectFeatures__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgFeatureQueryOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. Use the coordinateSystem argument to set the target
 * coordinate system if you want to transform.
 * If you want to apply the criteria to a subset of the
 * features, use {@link MgFeatureService}::SelectAggregate.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class from which  the properties of interest are selected.
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @param  coordinateSystem (String/string)  The name of the coordinate system to transform to.
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgFeatureReader selectFeatures(MgResourceIdentifier resource, String className, MgFeatureQueryOptions options, String coordinateSystem) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_SelectFeatures__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgFeatureQueryOptions.getCPtr(options), coordinateSystem);
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects groups of features from a feature source and applies
 * filters to each of the groups according to the criteria set
 * in the {@link MgFeatureAggregateOptions} argument. If you want to
 * apply the criteria to all features without grouping them, use
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the select operation is performed.
 * @param  options ({@link MgFeatureAggregateOptions})  An {@link MgFeatureAggregateOptions} instance  containing all the criteria and filters  required for this select operation.
 * @return  Returns an {@link MgDataReader} containing the group values.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgDataReader selectAggregate(MgResourceIdentifier resource, String className, MgFeatureAggregateOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_SelectAggregate(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgFeatureAggregateOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgDataReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @param  useTransaction (boolean/bool)  If true and transactions are supported  by the Fdo provider, execute all  commands inside a transaction. If false,  do not use a transaction.
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnlockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *    <li>For any of the above commands, if the property type is
 *      {@link MgPropertyType}::String, it indicates an exception had occurred
 *      for that particular command, and its value is the exception message.
 *      This only applies when the operation is not using a transaction</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public MgPropertyCollection updateFeatures(MgResourceIdentifier resource, MgFeatureCommandCollection commands, boolean useTransaction) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_UpdateFeatures__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgFeatureCommandCollection.getCPtr(commands), useTransaction);
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object within
 * the given transaction.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @param  transaction ({@link MgTransaction})  The {@link MgTransaction} instance on which the commands  will be executed.
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnlockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *    <li>For any of the above commands, if the property type is
 *      {@link MgPropertyType}::String, it indicates an exception had occurred
 *      for that particular command, and its value is the exception message.
 *      This only applies when the operation is not using a transaction</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  2.2 */
 public MgPropertyCollection updateFeatures(MgResourceIdentifier resource, MgFeatureCommandCollection commands, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_UpdateFeatures__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgFeatureCommandCollection.getCPtr(commands), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a new feature into the specified feature class of the specified Feature Source
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the insert operation is performed.
 * @param  propertyValues ({@link MgPropertyCollection})  The collection of property values to insert
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgResourceIdentifier resource, String className, MgPropertyCollection propertyValues) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_InsertFeatures__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgPropertyCollection.getCPtr(propertyValues));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a new feature into the specified feature class of the specified Feature Source
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the insert operation is performed.
 * @param  propertyValues ({@link MgPropertyCollection})  The collection of property values to insert
 * @param  trans ({@link MgTransaction})  The transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgResourceIdentifier resource, String className, MgPropertyCollection propertyValues, MgTransaction trans) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_InsertFeatures__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgPropertyCollection.getCPtr(propertyValues), MgTransaction.getCPtr(trans));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a set of new features into the specified feature class of the specified Feature Source
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the insert operation is performed.
 * @param  batchPropertyValues ({@link MgBatchPropertyCollection})  The collection of property values to insert. Each {@link MgPropertyCollection} within  this collection represents property values for a single feature to insert
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgResourceIdentifier resource, String className, MgBatchPropertyCollection batchPropertyValues) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_InsertFeatures__SWIG_2(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgBatchPropertyCollection.getCPtr(batchPropertyValues));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a set of new features into the specified feature class of the specified Feature Source
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the insert operation is performed.
 * @param  batchPropertyValues ({@link MgBatchPropertyCollection})  The collection of property values to insert. Each {@link MgPropertyCollection} within  this collection represents property values for a single feature to insert
 * @param  trans ({@link MgTransaction})  The transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgResourceIdentifier resource, String className, MgBatchPropertyCollection batchPropertyValues, MgTransaction trans) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_InsertFeatures__SWIG_3(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgBatchPropertyCollection.getCPtr(batchPropertyValues), MgTransaction.getCPtr(trans));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Updates all features that match the given filter with the specified property values
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the update operation is performed.
 * @param  properties ({@link MgBatchPropertyCollection})  The property values to update matching features with
 * @param  filter (String/string)  The FDO filter string that detemines what features will be updated
 * @return  Returns the number of features updated by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int updateMatchingFeatures(MgResourceIdentifier resource, String className, MgPropertyCollection properties, String filter) {
    return MapGuideJavaApiExJNI.MgFeatureService_UpdateMatchingFeatures__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgPropertyCollection.getCPtr(properties), filter);
  }

  
/**
 * Updates all features that match the given filter with the specified property values
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the update operation is performed.
 * @param  properties ({@link MgBatchPropertyCollection})  The property values to update matching features with
 * @param  filter (String/string)  The FDO filter string that detemines what features will be updated
 * @param  trans ({@link MgTransaction})  The transaction to execute this operation under
 * @return  Returns the number of features updated by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int updateMatchingFeatures(MgResourceIdentifier resource, String className, MgPropertyCollection properties, String filter, MgTransaction trans) {
    return MapGuideJavaApiExJNI.MgFeatureService_UpdateMatchingFeatures__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgPropertyCollection.getCPtr(properties), filter, MgTransaction.getCPtr(trans));
  }

  
/**
 * Deletes all features that match the given filter
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the delete operation is performed.
 * @param  filter (String/string)  The FDO filter string that detemines what features will be deleted
 * @return  Returns the number of features deleted by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int deleteFeatures(MgResourceIdentifier resource, String className, String filter) {
    return MapGuideJavaApiExJNI.MgFeatureService_DeleteFeatures__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, filter);
  }

  
/**
 * Deletes all features that match the given filter
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the delete operation is performed.
 * @param  filter (String/string)  The FDO filter string that detemines what features will be deleted
 * @param  trans ({@link MgTransaction})  The transaction to execute this operation under
 * @return  Returns the number of features deleted by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int deleteFeatures(MgResourceIdentifier resource, String className, String filter, MgTransaction trans) {
    return MapGuideJavaApiExJNI.MgFeatureService_DeleteFeatures__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, filter, MgTransaction.getCPtr(trans));
  }

  
/**
 * Gets the locked features
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the feature  source.
 * @param  className (String/string)  The name of the feature class on which  the select operation is performed.
 * @param  options ({@link MgFeatureAggregateOptions})  An {@link MgFeatureAggregateOptions} instance  containing all the criteria and filters  required for this select operation.
 * @return  Returns an {@link MgFeatureReader} containing the locked features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 */
 public MgFeatureReader getLockedFeatures(MgResourceIdentifier resource, String className, MgFeatureQueryOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetLockedFeatures(swigCPtr, MgResourceIdentifier.getCPtr(resource), className, MgFeatureQueryOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Starts a transaction on the specified feature source
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier referring  to a feature source.
 * @return  Returns an {@link MgTransaction} instance (or NULL).
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  2.2 */
 public MgTransaction beginTransaction(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_BeginTransaction(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgTransaction)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the SQL SELECT statement on the specified feature
 * source.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier referring  to a feature source.
 * @param  sqlStatement (String/string)  The SQL SELECT statement.
 * @return  Returns an {@link MgSqlDataReader} instance (or NULL).
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public MgSqlDataReader executeSqlQuery(MgResourceIdentifier resource, String sqlStatement) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_ExecuteSqlQuery__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), sqlStatement);
    return (cPtr == 0) ? null : (MgSqlDataReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the SQL SELECT statement on the specified feature
 * source within the given transaction.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier referring  to a feature source.
 * @param  sqlStatement (String/string)  The SQL SELECT statement.
 * @param  parameters ({@link MgParameterCollection})  Parameters binded to the SQL statement.
 * @param  transaction ({@link MgTransaction})  The {@link MgTransaction} instance on which the sql  statement will be executed.
 * @return  Returns an {@link MgSqlDataReader} instance (or NULL).
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  2.2 */
 public MgSqlDataReader executeSqlQuery(MgResourceIdentifier resource, String sqlStatement, MgParameterCollection parameters, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_ExecuteSqlQuery__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), sqlStatement, MgParameterCollection.getCPtr(parameters), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgSqlDataReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes SQL statements NOT including SELECT statements.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for a  feature source.
 * @param  sqlNonSelectStatement (String/string)  The SQL statement that is NOT a  SELECT statement.
 * @return  Returns a positive integer value indicating how many
 *  instances (rows) have been affected.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public int executeSqlNonQuery(MgResourceIdentifier resource, String sqlNonSelectStatement) {
    return MapGuideJavaApiExJNI.MgFeatureService_ExecuteSqlNonQuery__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), sqlNonSelectStatement);
  }

  
/**
 * Executes SQL statements NOT including SELECT statements
 * within the given transaction.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for a  feature source.
 * @param  sqlNonSelectStatement (String/string)  The SQL statement that is NOT a  SELECT statement.
 * @param  parameters ({@link MgParameterCollection})  Parameters binded to the SQL statement.
 * @param  transaction ({@link MgTransaction})  The {@link MgTransaction} instance on which the sql  statement will be executed.
 * @return  Returns a positive integer value indicating how many
 *  instances (rows) have been affected.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  2.2 */
 public int executeSqlNonQuery(MgResourceIdentifier resource, String sqlNonSelectStatement, MgParameterCollection parameters, MgTransaction transaction) {
    return MapGuideJavaApiExJNI.MgFeatureService_ExecuteSqlNonQuery__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), sqlNonSelectStatement, MgParameterCollection.getCPtr(parameters), MgTransaction.getCPtr(transaction));
  }

  
/**
 * Gets all of the spatial contexts available in the feature
 * source or just the active one.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier identifying a feature  source in the repository.
 * @param  bActiveOnly (boolean/bool)  This flag is obsolete and no longer used.
 * @return  Returns an {@link MgSpatialContextReader} object.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public MgSpatialContextReader getSpatialContexts(MgResourceIdentifier resource, boolean bActiveOnly) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetSpatialContexts(swigCPtr, MgResourceIdentifier.getCPtr(resource), bActiveOnly);
    return (cPtr == 0) ? null : (MgSpatialContextReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets all available long transactions for the provider.
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for feature  source.
 * @param  bActiveOnly (boolean/bool)  If true, returns the active long  transaction; otherwise returns all  long transactions.
 * @return  Returns an {@link MgLongTransactionReader} instance or NULL.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public MgLongTransactionReader getLongTransactions(MgResourceIdentifier resource, boolean bActiveOnly) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetLongTransactions(swigCPtr, MgResourceIdentifier.getCPtr(resource), bActiveOnly);
    return (cPtr == 0) ? null : (MgLongTransactionReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Set the active long transaction name for a feature source.
 *
 * @param  featureSourceId ({@link MgResourceIdentifier})  A resource identifier identifying a feature source in the repository.
 * @param  longTransactionName (String/string)  The long transaction name to set.
 * @return  Returns true if the name was successfully set; otherwise
 *  returns false.
 * @exception  MgNullArgumentException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgSessionNotFoundException
 */
 public boolean setLongTransaction(MgResourceIdentifier featureSourceId, String longTransactionName) {
    return MapGuideJavaApiExJNI.MgFeatureService_SetLongTransaction(swigCPtr, MgResourceIdentifier.getCPtr(featureSourceId), longTransactionName);
  }

  
/**
 * Gets a list of the names of all of the schemas available in
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for the  feature source,
 * @return  Returns an {@link MgStringCollection} object listing the schema
 *  names.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgStringCollection getSchemas(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetSchemas(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets a list of the names of all classes available within a
 *
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for a  feature source.
 * @param  schemaName (String/string)  A schema name.
 * @return  Returns an {@link MgStringCollection} containing a list of class
 *  names.  These names are fully qualified.  In other words, they are in the form <i>schema_name</i>:<i>class_name</i>.
 *  For example, SHP_Schema:lulc_n83.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgStringCollection getClasses(MgResourceIdentifier resource, String schemaName) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetClasses(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  A resource identifier for  the feature source.
 * @param  schemaName (String/string)  A schema name.
 * @param  className (String/string)  A class name.
 * @return  Returns an {@link MgClassDefinition} instance for the specified
 *  class name.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgClassDefinition getClassDefinition(MgResourceIdentifier resource, String schemaName, String className) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetClassDefinition(swigCPtr, MgResourceIdentifier.getCPtr(resource), schemaName, className);
    return (cPtr == 0) ? null : (MgClassDefinition)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a feature source in the repository identified by the
 * specified resource identifier, using the given feature source
 * parameters.
 *
 * @param  resource ({@link MgResourceIdentifier})  The resource identifier defining the  location of the new feature source in  the repository.
 * @param  sourceParams ({@link MgFeatureSourceParams})  The feature source parameters (feature  schema and spatial context definitions).
 * @return  Returns nothing.
 */
 public void createFeatureSource(MgResourceIdentifier resource, MgFeatureSourceParams sourceParams) {
    MapGuideJavaApiExJNI.MgFeatureService_CreateFeatureSource(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgFeatureSourceParams.getCPtr(sourceParams));
  }

  
/**
 * Retrieves schema information about a set of feature classes for a given feature source.
 *
 * @param  featureSourceId ({@link MgResourceIdentifier})  The resource identifier defining the  location of the feature source in  the repository.
 * @param  featureClasses ({@link MgStringCollection})  A collection of strings identifying the feature classes for which to  retrieve schema information. If this collection is null or empty, information  is returned for all feature classes.
 * @return  Returns an {@link MgByteReader} containing the XML schema.
 */
 public MgByteReader describeWfsFeatureType(MgResourceIdentifier featureSourceId, MgStringCollection featureClasses) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_DescribeWfsFeatureType__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(featureSourceId), MgStringCollection.getCPtr(featureClasses));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Retrieves schema informationabout a set of feature classes for a given feature source  with specified namespace prefix and url.
 *
 * @param  featureSourceId ({@link MgResourceIdentifier})  The resource identifier defining the  location of the feature source in  the repository.
 * @param  featureClasses ({@link MgStringCollection})  A collection of strings identifying the feature classes for which to  retrieve schema information. If this collection is null or empty, information  is returned for all feature classes.
 * @param  namespacePrefix (String/string)  A string identifying the namespace prefix in the output xml
 * @param  namespaceUrl (String/string)  A string idenyifying the namespace url in the output xml
 * @return  Returns an {@link MgByteReader} containing the XML schema.
 */
 public MgByteReader describeWfsFeatureType(MgResourceIdentifier featureSourceId, MgStringCollection featureClasses, String namespacePrefix, String namespaceUrl) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_DescribeWfsFeatureType__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(featureSourceId), MgStringCollection.getCPtr(featureClasses), namespacePrefix, namespaceUrl);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Retrieves feature information based on the supplied criteria.
 *
 * @param  featureSourceId ({@link MgResourceIdentifier})  The resource identifier defining the  location of the feature source in  the repository.
 * @param  featureClass (String/string)  The feature class containing the features to retrieve.
 * @param  requiredProperties ({@link MgStringCollection})  The collection of properties to retrieve for each feature. If the  collection is null or empty, all properties will be retrieved.
 * @param  srs (String/string)  The spatial reference system in which to return feature geometries
 * @param  filter (String/string)  An XML string containing the definition for an OGC filter
 * @param  maxFeatures (int)  The maximum number of features to retrieve. If the value is less  than or equal to zero, all features will be retrieved.
 * @return  Returns an {@link MgByteReader} containing the requested feature information.
 */
 public MgByteReader getWfsFeature(MgResourceIdentifier featureSourceId, String featureClass, MgStringCollection requiredProperties, String srs, String filter, int maxFeatures) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetWfsFeature__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(featureSourceId), featureClass, MgStringCollection.getCPtr(requiredProperties), srs, filter, maxFeatures);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Retrieves feature information based on the supplied criteria with specified format.
 *
 * @param  featureSourceId ({@link MgResourceIdentifier})  The resource identifier defining the  location of the feature source in  the repository.
 * @param  featureClass (String/string)  The feature class containing the features to retrieve.
 * @param  requiredProperties ({@link MgStringCollection})  The collection of properties to retrieve for each feature. If the  collection is null or empty, all properties will be retrieved.
 * @param  srs (String/string)  The spatial reference system in which to return feature geometries
 * @param  filter (String/string)  An XML string containing the definition for an OGC filter
 * @param  maxFeatures (int)  The maximum number of features to retrieve. If the value is less  than or equal to zero, all features will be retrieved.
 * @param  wfsVersion (String/string)  A string identifying the wfs version
 * @param  outputFormat (String/string)  A string identifying the output format of  the retrieved feature information.  The supported values of output format are specified in OpenGIS Web Feature Service (WFS) Implementation Specification - section 9.2  http://portal.opengeospatial.org/files/?artifact_id=8339
 * @param  sortCriteria (String/string)  A string identifying the sort criteria
 * @param  namespacePrefix (String/string)  A string identifying the namespace prefix in the output xml
 * @param  namespaceUrl (String/string)  A string idenyifying the namespace url in the output xml
 * @return  Returns an {@link MgByteReader} containing the requested feature information.
 * @exception  MgInvalidArgumentException
 */
 public MgByteReader getWfsFeature(MgResourceIdentifier featureSourceId, String featureClass, MgStringCollection requiredProperties, String srs, String filter, int maxFeatures, String wfsVersion, String outputFormat, String sortCriteria, String namespacePrefix, String namespaceUrl) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetWfsFeature__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(featureSourceId), featureClass, MgStringCollection.getCPtr(requiredProperties), srs, filter, maxFeatures, wfsVersion, outputFormat, sortCriteria, namespacePrefix, namespaceUrl);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * This method enumerates all the providers and if they are FDO enabled for
 * the specified provider and partial connection string.
 *
 * @param  providerName (String/string)  The name of the Fdo feature provider.
 * @param  partialConnString (String/string)  The partial connection string to the Fdo provider.
 * @return  Returns the list of data stores.
 */
 public MgByteReader enumerateDataStores(String providerName, String partialConnString) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_EnumerateDataStores(swigCPtr, providerName, partialConnString);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * This method returns all of the logical to physical schema mappings for
 * the specified provider and partial connection string.
 *
 * @param  providerName (String/string)  The name of the Fdo feature provider.
 * @param  partialConnString (String/string)  The partial connection string to the Fdo provider.
 * @return  Returns the schema mapping.
 */
 public MgByteReader getSchemaMapping(String providerName, String partialConnString) {
    long cPtr = MapGuideJavaApiExJNI.MgFeatureService_GetSchemaMapping(swigCPtr, providerName, partialConnString);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
