/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgGeometryCollection} provides support for defining an ordered set of
 * geometry objects.
 *
 */
 public class MgGeometryCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgGeometryCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgGeometryCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgGeometryCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometryCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of objects in the collection.
 *
 * @return  Returns number of objects in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgGeometryCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the object in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the object to retrieve.
 * @return  Returns the object in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgGeometry getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the object in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the object to set.
 * @param  value ({@link MgGeometry})  Object to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgGeometry value) {
    MapGuideJavaApiExJNI.MgGeometryCollection_SetItem(swigCPtr, index, MgGeometry.getCPtr(value));
  }

  
/**
 * Adds the specified object to the end of the collection.
 *
 * @param  value ({@link MgGeometry})  Object to add to the collection.
 * @return  Returns nothing
 */
 public void add(MgGeometry value) {
    MapGuideJavaApiExJNI.MgGeometryCollection_Add(swigCPtr, MgGeometry.getCPtr(value));
  }

  
/**
 * Inserts the specified object at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the object.
 * @param  value ({@link MgGeometry})  Object to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgGeometry value) {
    MapGuideJavaApiExJNI.MgGeometryCollection_Insert(swigCPtr, index, MgGeometry.getCPtr(value));
  }

  
/**
 * Removes all objects from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgGeometryCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified object from the collection. Returns true if removal
 * was successful.
 *
 * @param  value ({@link MgGeometry})  Object reference to remove.
 * @return  Returns true if object was removed.
 */
 public boolean remove(MgGeometry value) {
    return MapGuideJavaApiExJNI.MgGeometryCollection_Remove(swigCPtr, MgGeometry.getCPtr(value));
  }

  
/**
 * Removes the object at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the object to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgGeometryCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified object, false
 * otherwise.
 *
 * @param  value ({@link MgGeometry})  Object reference to check containment of.
 * @return  True if the collection contains the specified object, false
 *  otherwise.
 */
 public boolean contains(MgGeometry value) {
    return MapGuideJavaApiExJNI.MgGeometryCollection_Contains(swigCPtr, MgGeometry.getCPtr(value));
  }

  
/**
 * Returns the index of the specified object in the collection or -1
 * if the object does not exist.
 *
 * @param  value ({@link MgGeometry})  Object reference to find the index of.
 * @return  The index of the specified object in the collection or -1 if the
 *  coordinate does not exist.
 */
 public int indexOf(MgGeometry value) {
    return MapGuideJavaApiExJNI.MgGeometryCollection_IndexOf(swigCPtr, MgGeometry.getCPtr(value));
  }

  
/**
 * Construct a {@link MgGeometryCollection} object
 *
 */
 public MgGeometryCollection() {
    this(MapGuideJavaApiExJNI.new_MgGeometryCollection(), true);
  }

}
