/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * The {@link MgGeometryFactory} class is used to construct objects
 * whose classes are derived from {@link MgGeometry}.
 *
 */
 public class MgGeometryFactory extends MgGuardDisposable {
  private long swigCPtr;

  public MgGeometryFactory(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgGeometryFactoryToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgGeometryFactory(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometryFactory obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates an {@link MgGeometryFactory} object
 *
 */
 public MgGeometryFactory() {
    this(MapGuideJavaApiExJNI.new_MgGeometryFactory(), true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XY, X = x, Y
 * = y.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate createCoordinateXY(double x, double y) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCoordinateXY(swigCPtr, x, y);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYM, X = x, Y
 * = y, M = m.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  m (double)  M value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate createCoordinateXYM(double x, double y, double m) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCoordinateXYM(swigCPtr, x, y, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYZ, X = x, Y
 * = y, Z = z.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  z (double)  Z value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate createCoordinateXYZ(double x, double y, double z) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCoordinateXYZ(swigCPtr, x, y, z);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYZM, X = x,
 * Y = y, Z = z, M = m.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  z (double)  Z value for the coordinate.
 * @param  m (double)  M value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate createCoordinateXYZM(double x, double y, double z, double m) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCoordinateXYZM(swigCPtr, x, y, z, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an arc segment from start, end, and control
 * coordinates.
 *
 * @param  start ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the start point  of the arc.
 * @param  end ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the end point  of the arc.
 * @param  control ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the control  point of the arc.
 * @return  An instance of {@link MgArcSegment}.
 */
 public MgArcSegment createArcSegment(MgCoordinate start, MgCoordinate end, MgCoordinate control) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateArcSegment(swigCPtr, MgCoordinate.getCPtr(start), MgCoordinate.getCPtr(end), MgCoordinate.getCPtr(control));
    return (cPtr == 0) ? null : (MgArcSegment)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a linear segment from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the linear  segment. The collection must contain at least two coordinates.
 * @return  An instance of {@link MgLinearSegment}.
 */
 public MgLinearSegment createLinearSegment(MgCoordinateCollection coordinates) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateLinearSegment(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLinearSegment)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a linear ring from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the linear  ring. The collection must contain at least three coordinates.
 * @return  An instance of {@link MgLinearRing}.
 */
 public MgLinearRing createLinearRing(MgCoordinateCollection coordinates) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateLinearRing(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLinearRing)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve ring from a collection of curve segments.
 *
 * @param  curveSegments ({@link MgCurveSegmentCollection})  An {@link MgCurveSegmentCollection} that specifies the segments  of the curve ring. The segments in the collection must  form a closed shape. See the example php code for  details about the construction of the segments so that  the resulting shape is closed.
 * @return  An instance of {@link MgCurveRing}.
 */
 public MgCurveRing createCurveRing(MgCurveSegmentCollection curveSegments) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCurveRing(swigCPtr, MgCurveSegmentCollection.getCPtr(curveSegments));
    return (cPtr == 0) ? null : (MgCurveRing)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a point from a coordinate.
 *
 * @param  coordinate ({@link MgCoordinate})  An {@link MgCoordinate} that specifies the location of this point.
 * @return  An instance of {@link MgPoint}.
 */
 public MgPoint createPoint(MgCoordinate coordinate) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreatePoint(swigCPtr, MgCoordinate.getCPtr(coordinate));
    return (cPtr == 0) ? null : (MgPoint)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a line string from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the line  string. The collection must contain at least two coordinates.
 * @return  An instance of {@link MgLineString}.
 */
 public MgLineString createLineString(MgCoordinateCollection coordinates) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateLineString(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLineString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve string from a collection of curve segments.
 *
 * @param  curveSegments ({@link MgCurveSegmentCollection})  An {@link MgCurveSegmentCollection} that specifies the segments of the  curve string. The collection must contain at least one segment.
 * @return  An instance of {@link MgCurveString}.
 */
 public MgCurveString createCurveString(MgCurveSegmentCollection curveSegments) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCurveString(swigCPtr, MgCurveSegmentCollection.getCPtr(curveSegments));
    return (cPtr == 0) ? null : (MgCurveString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a polygon from an outer ring and a collection of inner rings.
 *
 * @param  outerRing ({@link MgLinearRing})  An {@link MgLinearRing} that specifies the polygons outer boundary.
 * @param  innerRings ({@link MgLinearRingCollection})  An {@link MgLinearRingCollection} that specifies the polygons holes.  This parameter may be null.
 * @return  An instance of {@link MgPolygon}.
 */
 public MgPolygon createPolygon(MgLinearRing outerRing, MgLinearRingCollection innerRings) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreatePolygon(swigCPtr, MgLinearRing.getCPtr(outerRing), MgLinearRingCollection.getCPtr(innerRings));
    return (cPtr == 0) ? null : (MgPolygon)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve polygon from an outer ring and a collection of inner
 * rings.
 *
 * @param  outerRing ({@link MgCurveRing})  An {@link MgCurveRing} that specifies the polygons outer boundary.
 * @param  innerRings ({@link MgCurveRingCollection})  An {@link MgCurveRingCollection} that specifies the polygons holes.  This parameter may be null.
 * @return  An instance of {@link MgCurvePolygon}.
 */
 public MgCurvePolygon createCurvePolygon(MgCurveRing outerRing, MgCurveRingCollection innerRings) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateCurvePolygon(swigCPtr, MgCurveRing.getCPtr(outerRing), MgCurveRingCollection.getCPtr(innerRings));
    return (cPtr == 0) ? null : (MgCurvePolygon)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi point aggregate geometry from a collection of points.
 *
 * @param  points ({@link MgPointCollection})  An {@link MgGeometryCollection} that specifies the points. All geometry  objects in this collection must be of type {@link MgPoint}.
 * @return  An instance of {@link MgMultiPoint}.
 */
 public MgMultiPoint createMultiPoint(MgPointCollection points) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiPoint(swigCPtr, MgPointCollection.getCPtr(points));
    return (cPtr == 0) ? null : (MgMultiPoint)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi line string aggregate geometry from a collection of
 * line strings.
 *
 * @param  lineStrings ({@link MgLineStringCollection})  An {@link MgGeometryCollection} that specifies the line strings. All geometry  objects in this collection must be of type {@link MgLineString}.
 * @return  An instance of {@link MgMultiLineString}.
 */
 public MgMultiLineString createMultiLineString(MgLineStringCollection lineStrings) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiLineString(swigCPtr, MgLineStringCollection.getCPtr(lineStrings));
    return (cPtr == 0) ? null : (MgMultiLineString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi curve string aggregate geometry from a collection of
 * curve strings.
 *
 * @param  curveStrings ({@link MgCurveStringCollection})  An {@link MgGeometryCollection} that specifies the curve strings. All geometry  objects in this collection must be of type {@link MgCurveString}.
 * @return  An instance of {@link MgMultiCurveString}.
 */
 public MgMultiCurveString createMultiCurveString(MgCurveStringCollection curveStrings) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiCurveString(swigCPtr, MgCurveStringCollection.getCPtr(curveStrings));
    return (cPtr == 0) ? null : (MgMultiCurveString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi polygon aggregate geometry from a collection of
 * polygons.
 *
 * @param  polygons ({@link MgPolygonCollection})  An {@link MgGeometryCollection} that specifies the polygons. All geometry  objects in this collection must be of type {@link MgPolygon}.
 * @return  An instance of {@link MgMultiPolygon}.
 */
 public MgMultiPolygon createMultiPolygon(MgPolygonCollection polygons) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiPolygon(swigCPtr, MgPolygonCollection.getCPtr(polygons));
    return (cPtr == 0) ? null : (MgMultiPolygon)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi curve polygon aggregate geometry from a collection of
 * curve polygons.
 *
 * @param  polygons ({@link MgCurvePolygonCollection})  An {@link MgGeometryCollection} that specifies the curve polygons. All geometry  objects in this collection must be of type {@link MgCurvePolygon}.
 * @return  An instance of {@link MgMultiCurvePolygon}.
 */
 public MgMultiCurvePolygon createMultiCurvePolygon(MgCurvePolygonCollection polygons) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiCurvePolygon(swigCPtr, MgCurvePolygonCollection.getCPtr(polygons));
    return (cPtr == 0) ? null : (MgMultiCurvePolygon)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an aggregate geometry from a collection of geometry objects.
 *
 * @param  geometries ({@link MgGeometryCollection})  An {@link MgGeometryCollection} that specifies the geometries.
 * @return  An instance of {@link MgMultiGeometry}.
 */
 public MgMultiGeometry createMultiGeometry(MgGeometryCollection geometries) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometryFactory_CreateMultiGeometry(swigCPtr, MgGeometryCollection.getCPtr(geometries));
    return (cPtr == 0) ? null : (MgMultiGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
