package org.osgeo.mapguide;


/**
 * {@link MgGeometryType} defines integer constants used to signify the
 * derived type of an {@link MgGeometry} instance.
 *
 */
public class MgGeometryType
{
   
/**
 * Specifies that the geometry is a Point.
 *
 */

   public static final int Point = 1 ; 
   
/**
 * Specifies that the geometry is a LineString.
 *
 */

   public static final int LineString = 2 ; 
   
/**
 * Specifies that the geometry is a Polygon.
 *
 */

   public static final int Polygon = 3 ; 
   
/**
 * Specifies that the geometry is a MultiPoint.
 *
 */

   public static final int MultiPoint = 4 ; 
   
/**
 * Specifies that the geometry is a MultiLineString.
 *
 */

   public static final int MultiLineString = 5 ; 
   
/**
 * Specifies that the geometry is a MultiPolygon.
 *
 */

   public static final int MultiPolygon = 6 ; 
   
/**
 * Specifies that the geometry is a MultiGeometry. In OpenGIS
 * this is referred to as a GeometryCollection.
 *
 */

   public static final int MultiGeometry = 7 ; 
   
/**
 * Specifies that the geometry is a CurveString.
 *
 */

   public static final int CurveString = 10 ; 
   
/**
 * Specifies that the geometry is a CurvePolygon.
 *
 */

   public static final int CurvePolygon = 11 ; 
   
/**
 * Specifies that the geometry is a MultiLineString.
 *
 */

   public static final int MultiCurveString = 12 ; 
   
/**
 * Specifies the geometry is a MultiPolygon.
 *
 */

   public static final int MultiCurvePolygon = 13 ; 
   
}

