/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;


import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.NoSuchElementException;


/**
 * Manipulates collections of {@link MgLayerBase} objects.
 *
 */
 public class MgLayerCollection extends MgGuardDisposable implements Collection<MgLayerBase> {
  private long swigCPtr;

  public MgLayerCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayerCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayerCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    /**
     * An iterator to iterate over this collection
     */
    class ItemIterator implements Iterator<MgLayerBase> {
        private MgLayerCollection _collection;
        private int _pos;
        private int _count;
        
        public ItemIterator(MgLayerCollection c) { 
            _collection = c; 
            _count = _collection.getCount();
            _pos = -1;
        }
        
        /**
         * Returns true if the iteration has more elements
         */
        public boolean hasNext() {
            return _pos + 1 < _count;
        }
        
        /**
         * Returns the next MgLayerBase in the collection
         */
        public MgLayerBase next() {
            _pos++;
            if (_pos >= _count)
                throw new NoSuchElementException();
            return _collection.getItem(_pos);
        }
        
        /**
         * Removes from the underlying collection the last element returned by the iterator (not supported).
         */
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
    /**
     * Returns an iterator over the elements in this collection.
     */
    public Iterator<MgLayerBase> iterator() { return new ItemIterator(this); }

    /**
     * Ensures that this collection contains the specified element (optional operation).
     */
    public boolean add(MgLayerBase item) {
        this.addItem(item);
        return true;
    }

    /**
     * Adds all of the elements in the specified collection to this collection (optional operation).
     */
    public boolean addAll(Collection<? extends MgLayerBase> c) {
        int added = 0;
        for (MgLayerBase item : c) {
            this.addItem(item);
            added++;
        }
        return added > 0;
    }

    /**
     *  Returns true if this collection contains the specified element.
     */
    public boolean contains(Object o) {
        if (o instanceof MgLayerBase) {
            return this.contains((MgLayerBase)o);
        }
        return false;
    }

    /**
     * Returns true if this collection contains all of the elements in the specified collection.
     */
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o))
                return false;
        }
        return true;
    }

    /**
     * Returns true if this collection contains no elements.
     */
    public boolean isEmpty() { return this.getCount() == 0; }

    /**
     * Removes a single instance of the specified element from this collection, if it is present (optional operation).
     */
    public boolean remove(Object o) {
        if (o instanceof MgLayerBase) {
            return this.remove((MgLayerBase)o);
        }
        return false;
    }

    /**
     * Removes all of this collection's elements that are also contained in the specified collection (optional operation).
     */
    public boolean removeAll(Collection<?> c) {
        int removed = 0;
        for (Object o : c) {
            if (this.remove(o))
                removed++;
        }
        return removed > 0;
    }

    /**
     * Retains only the elements in this collection that are contained in the specified collection (optional operation).
     */
    public boolean retainAll(Collection<?> c) {
        int removed = 0;
        ArrayList<MgLayerBase> remove = new ArrayList<MgLayerBase>();
        for (int i = 0; i < this.getCount(); i++) {
            MgLayerBase item = this.getItem(i);
            if (!c.contains(item))
                remove.add(item);
        }
        if (remove.size() > 0) {
            return this.removeAll(remove);
        } else {
            return false;
        }
    }

    /**
     * Returns the number of elements in this collection.
     */
    public int size() { return this.getCount(); }

    /**
     * Returns an array containing all of the elements in this collection.
     */
    public Object[] toArray() {
        int count = this.getCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; i++) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    /**
     * Returns an array containing all of the elements in this collection; the runtime type of the returned array is that of the specified array.
     */
    public <MgLayerBase> MgLayerBase[] toArray(MgLayerBase[] a) {
        Object[] items = this.toArray();
        if (a.length >= items.length) {
            for (int i = 0; i < items.length; i++) {
                a[i] = (MgLayerBase)items[i];
            }
            for (int i = items.length; i < a.length; i++) {
                a[i] = null;
            }
            return a;
        } else {
            MgLayerBase[] retVal = (MgLayerBase[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), items.length);
            for (int i = 0; i < retVal.length; i++) {
                retVal[i] = (MgLayerBase)items[i];
            }
            return retVal;
        }
    }


  
/**
 * Gets the number of layers in the collection.
 *
 * @return  Returns the number of layers.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgLayerCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer at the specified index.
 *
 * @param  index (int)  Index of the layer to get.
 * @return  Returns the layer.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public MgLayerBase getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the layer with the specified name.
 *
 * @param  name (String/string)  Name of the layer to get.
 * @return  Returns the layer.
 * @exception  MgObjectNotFoundException if the name does not exist.
 */
 public MgLayerBase getItem(String name) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the layer in the collection at the specified index to
 * the specified value.
 *
 * @param  index (int)  Position in the collection to set the layer.
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void setItem(int index, MgLayerBase value) {
    MapGuideJavaApiExJNI.MgLayerCollection_SetItem(swigCPtr, index, MgLayerBase.getCPtr(value));
  }

  
/**
 * Adds a layer to the end of the collection.
 *
 * @param  value ({@link MgLayerBase})  Layer to be added.
 * @return  Returns nothing.
 */
 public void addItem(MgLayerBase value) {
    MapGuideJavaApiExJNI.MgLayerCollection_addItem(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Inserts a layer at a specified location in the collection.
 *
 * @param  index (int)  Position in the collection to insert the layer.
 * @param  value ({@link MgLayerBase})  Layer to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void insert(int index, MgLayerBase value) {
    MapGuideJavaApiExJNI.MgLayerCollection_Insert(swigCPtr, index, MgLayerBase.getCPtr(value));
  }

  
/**
 * Removes all layers from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgLayerCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a layer from the collection.
 *
 * @param  value ({@link MgLayerBase})  Layer to be removed.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgLayerBase value) {
    return MapGuideJavaApiExJNI.MgLayerCollection_Remove(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Removes a layer from the collection at the specified index.
 *
 * @param  index (int)  Index of the layer to be removed.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgLayerCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  name (String/string)  Name of the layer to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean contains(String name) {
    return MapGuideJavaApiExJNI.MgLayerCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean contains(MgLayerBase value) {
    return MapGuideJavaApiExJNI.MgLayerCollection_Contains__SWIG_1(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  name (String/string)  Name of the layer to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int indexOf(String name) {
    return MapGuideJavaApiExJNI.MgLayerCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int indexOf(MgLayerBase value) {
    return MapGuideJavaApiExJNI.MgLayerCollection_IndexOf__SWIG_1(swigCPtr, MgLayerBase.getCPtr(value));
  }

}
