/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates the properties of a layer group.
 *
 */
 public class MgLayerGroup extends MgNamedSerializable {
  private long swigCPtr;

  public MgLayerGroup(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayerGroupToMgNamedSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerGroup() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayerGroup(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    public boolean equals(Object obj) {
        boolean equal=false;
        if(obj instanceof MgLayerGroup)
            equal=(((MgLayerGroup)obj).swigCPtr==this.swigCPtr);
        return equal;
    }
    
    public int hashCode() {
        return (int)swigCPtr;
    }

  
/**
 * Constructs an {@link MgLayerGroup} object with the specified name.
 *
 * @param  name (String/string)  Name of the group
 */
 public MgLayerGroup(String name) {
    this(MapGuideJavaApiExJNI.new_MgLayerGroup(name), true);
  }

  
/**
 * Gets the group name.
 *
 * @return  Returns the group name as a string.
 */
 public String getName() {
  { return MapGuideJavaApiExJNI.MgLayerGroup_GetName(swigCPtr); }
}

  
/**
 * Gets a unique identifier for this layer group.
 *
 * @return  Returns the unique identifier as a string.
 */
 public String getObjectId() {
  { return MapGuideJavaApiExJNI.MgLayerGroup_GetObjectId(swigCPtr); }
}

  
/**
 * Gets the type of the layer group.
 *
 * @return  Returns the type of the layer group.
 */
 public int getLayerGroupType() {
    return MapGuideJavaApiExJNI.MgLayerGroup_GetLayerGroupType(swigCPtr);
  }

  
/**
 * Gets the group this group is organized within.
 *
 * @return  Returns the parent group, or NULL if the group is at the top
 *  level of the hierarchy.
 */
 public MgLayerGroup getGroup() {
    long cPtr = MapGuideJavaApiExJNI.MgLayerGroup_GetGroup(swigCPtr);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Changes the group this group is organized within.
 *
 * @param  group ({@link MgLayerGroup})  Group for this group to belong to, or NULL if the  group should not belong to any group.
 * @return  Returns nothing.
 */
 public void setGroup(MgLayerGroup group) {
    MapGuideJavaApiExJNI.MgLayerGroup_SetGroup(swigCPtr, MgLayerGroup.getCPtr(group));
  }

  
/**
 * Determines if the layer group is potentially visible.
 *
 * @return  Returns true if the layer group is potentially visible, or
 *  false otherwise.
 */
 public boolean getVisible() {
    return MapGuideJavaApiExJNI.MgLayerGroup_GetVisible(swigCPtr);
  }

  
/**
 * Alters the group potential visibility.
 *
 * @param  visible (boolean/bool)  True if the group should be visible, or false  otherwise.
 * @return  Returns nothing.
 */
 public void setVisible(boolean visible) {
    MapGuideJavaApiExJNI.MgLayerGroup_SetVisible(swigCPtr, visible);
  }

  
/**
 * Determines the actual visibility of the group.
 *
 * @return  Returns true if the layer group is visible, or false
 *  otherwise.
 */
 public boolean isVisible() {
    return MapGuideJavaApiExJNI.MgLayerGroup_IsVisible(swigCPtr);
  }

  
/**
 * Determines whether an entry for the group should appear in
 * the legend.
 *
 * @return  Returns true if the group should appear in the legend, or
 *  false otherwise.
 */
 public boolean getDisplayInLegend() {
    return MapGuideJavaApiExJNI.MgLayerGroup_GetDisplayInLegend(swigCPtr);
  }

  
/**
 * Specifies whether an entry for the group should appear in the
 * legend.
 *
 * @param  displayInLegend (boolean/bool)  True if the group should appear in the  legend, or false otherwise.
 * @return  Returns nothing.
 */
 public void setDisplayInLegend(boolean displayInLegend) {
    MapGuideJavaApiExJNI.MgLayerGroup_SetDisplayInLegend(swigCPtr, displayInLegend);
  }

  
/**
 * Determines whether the entry for the group should initially
 * be expanded in the legend, if possible.
 *
 * @return  Returns true if the group should initially be expanded in the legend, or
 *  false otherwise.
 */
 public boolean getExpandInLegend() {
    return MapGuideJavaApiExJNI.MgLayerGroup_GetExpandInLegend(swigCPtr);
  }

  
/**
 * Gets the label to be displayed for the group in the legend.
 *
 * @return  Returns the legend label as a string.
 */
 public String getLegendLabel() {
  { return MapGuideJavaApiExJNI.MgLayerGroup_GetLegendLabel(swigCPtr); }
}

  
/**
 * Sets the label to be displayed for the group in the legend.
 *
 * @param  legendLabel (String/string)  Legend label.
 * @return  Returns nothing.
 */
 public void setLegendLabel(String legendLabel) {
    MapGuideJavaApiExJNI.MgLayerGroup_SetLegendLabel(swigCPtr, legendLabel);
  }

  
/**
 * Specifies whether the entry for the group should initially
 * be expanded in the legend, if possible.
 *
 * @param  expandInLegend (boolean/bool)  Indicates whether this group is expanded in the legend
 * @return  Returns nothing.
 * @since  2.5 */
 public void setExpandInLegend(boolean expandInLegend) {
    MapGuideJavaApiExJNI.MgLayerGroup_SetExpandInLegend(swigCPtr, expandInLegend);
  }

}
