/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates collections of {@link MgMapBase} objects.
 *
 */
 public class MgMapCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgMapCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgMapCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgMapCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMapCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of map in the collection.
 *
 * @return  Returns the number of maps.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgMapCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the map at the specified index.
 *
 * @param  index (int)  Index of the map to get.
 * @return  Returns the specified {@link MgMapBase} object.
 * @exception  MgOutOfRangeException if the index is invalid.
 */
 public MgMapBase getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgMapCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgMapBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the map with the specified name.
 *
 * @param  name (String/string)  Name of the map to get.
 * @return  Returns the specified {@link MgMapBase} object.
 * @exception  MgInvalidArgumentException if the name does not exist in
 */
 public MgMapBase getItem(String name) {
    long cPtr = MapGuideJavaApiExJNI.MgMapCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgMapBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the map in the collection at the specified index to a
 * specified value.
 *
 * @param  index (int)  Position in the collection to set the  {@link MgMapBase}.
 * @param  value ({@link MgMapBase})  {@link MgMapBase} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the index is out of range.
 */
 public void setItem(int index, MgMapBase value) {
    MapGuideJavaApiExJNI.MgMapCollection_SetItem(swigCPtr, index, MgMapBase.getCPtr(value));
  }

  
/**
 * Adds the specified map to the end of the collection.
 *
 * @param  value ({@link MgMapBase})  {@link MgMapBase} to be added to the collection.
 * @return  Returns nothing.
 */
 public void add(MgMapBase value) {
    MapGuideJavaApiExJNI.MgMapCollection_Add(swigCPtr, MgMapBase.getCPtr(value));
  }

  
/**
 * Inserts a map at a specified index within the collection.
 *
 * @param  index (int)  Position in the collection to insert the  {@link MgMapBase}.
 * @param  value ({@link MgMapBase})  {@link MgMapBase} to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the specified index is out of
 */
 public void insert(int index, MgMapBase value) {
    MapGuideJavaApiExJNI.MgMapCollection_Insert(swigCPtr, index, MgMapBase.getCPtr(value));
  }

  
/**
 * Removes all maps from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgMapCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a map from the collection.
 *
 * @param  value ({@link MgMapBase})  {@link MgMapBase} to be removed
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgMapBase value) {
    return MapGuideJavaApiExJNI.MgMapCollection_Remove(swigCPtr, MgMapBase.getCPtr(value));
  }

  
/**
 * Removes a map from the collection at the specified index.
 *
 * @param  index (int)  Index of the map to be removed.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the map does not exist in the
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgMapCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified map.
 *
 * @param  name (String/string)  Name of the map.
 * @return  Returns true if the collection contains the specified map,
 *  or false otherwise.
 */
 public boolean contains(String name) {
    return MapGuideJavaApiExJNI.MgMapCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified map.
 *
 * @param  value ({@link MgMapBase})  The {@link MgMapBase} to look for.
 * @return  Returns true if the collection contains the specified map,
 *  or false otherwise.
 */
 public boolean contains(MgMapBase value) {
    return MapGuideJavaApiExJNI.MgMapCollection_Contains__SWIG_1(swigCPtr, MgMapBase.getCPtr(value));
  }

  
/**
 * Gets the index of the specified map in the collection.
 *
 * @param  name (String/string)  Name of the map to get the index of.
 * @return  Returns the map's index if the collection contains the
 *  specified map, or false (-1) otherwise.
 */
 public int indexOf(String name) {
    return MapGuideJavaApiExJNI.MgMapCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified map in the collection.
 *
 * @param  value ({@link MgMapBase})  Value of the item to get the index of.
 * @return  Returns the map's index if the collection contains the
 *  specified map, or false (-1) otherwise.
 */
 public int indexOf(MgMapBase value) {
    return MapGuideJavaApiExJNI.MgMapCollection_IndexOf__SWIG_1(swigCPtr, MgMapBase.getCPtr(value));
  }

  
/**
 * Constructs an empty {@link MgMapCollection} object.
 *
 */
 public MgMapCollection() {
    this(MapGuideJavaApiExJNI.new_MgMapCollection(), true);
  }

}
