/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Performs map related operations such as getting an eMap DWF
 * representing a map or updates to a map, or querying features
 * from maps or layers of a map.
 *
 */
 public class MgMappingService extends MgService {
  private long swigCPtr;

  public MgMappingService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgMappingServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgMappingService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgMappingService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMappingService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Plot The map to an EPlot DWF using the center and scale from the map.  The
 * extents will be computed to fill the space within the page margins.  If the
 * layout paramter is null, no adornments will be added to the page.
 *
 * @param  map ({@link MgMap})  Map object describing current state of map.
 * @param  plotSpec ({@link MgPlotSpecification})  Plotting specifications for the generated plot.
 * @param  layout ({@link MgLayout})  Layout specifications to use for the generated plot.
 * @param  dwfVersion ({@link MgDwfVersion})  DWF version required by the client. This  determines the schema and file versions used to  generate the DWFs sent back to the client.
 * @return  Returns an {@link MgByteReader} object containing a DWF in ePlot format.
 * @exception  MgNullArgumentException
 */
 public MgByteReader generatePlot(MgMap map, MgPlotSpecification plotSpec, MgLayout layout, MgDwfVersion dwfVersion) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_GeneratePlot__SWIG_0(swigCPtr, MgMap.getCPtr(map), MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout), MgDwfVersion.getCPtr(dwfVersion));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Plot the map to an EPlot DWF using the specified center and scale.  The extents
 * will be computed to fill the space within the page margins.  If the layout
 * paramter is null, no adornments will be added to the page.
 *
 * @param  map ({@link MgMap})  Map object describing current state of map.
 * @param  center ({@link MgCoordinate})  The coordinates of the center of the map for the plot.
 * @param  scale (double)  The scale to use for the plot.
 * @param  plotSpec ({@link MgPlotSpecification})  Plotting specifications for the generated plot.
 * @param  layout ({@link MgLayout})  Layout specifications to use for the generated plot.
 * @param  dwfVersion ({@link MgDwfVersion})  DWF version required by the client. This  determines the schema and file versions used to  generate the DWFs sent back to the client.
 * @return  Returns an {@link MgByteReader} object containing a DWF in ePlot format.
 * @exception  MgNullArgumentException
 */
 public MgByteReader generatePlot(MgMap map, MgCoordinate center, double scale, MgPlotSpecification plotSpec, MgLayout layout, MgDwfVersion dwfVersion) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_GeneratePlot__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgCoordinate.getCPtr(center), scale, MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout), MgDwfVersion.getCPtr(dwfVersion));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Plot the map to an EPlot DWF using the extent specified in the mapping
 * coordinate space.  The center and scale will be computed based on the extent
 * specified.  If expandToFit is true, then the extent specified will be expanded
 * in the X or Y direction to fill the space within the page margins.  If the
 * layout paramter is null, no adornments will be added to the page.
 *
 * @param  map ({@link MgMap})  Map object describing current state of map.
 * @param  extents ({@link MgEnvelope})  The extents of the map to be plotted..
 * @param  expandToFit (boolean/bool)  Flag indicating whether the extents should be expanded to  fill the space withing the page margins.
 * @param  plotSpec ({@link MgPlotSpecification})  Plotting specifications for the generated plot.
 * @param  layout ({@link MgLayout})  Layout specifications to use for the generated plot.
 * @param  dwfVersion ({@link MgDwfVersion})  DWF version required by the client. This  determines the schema and file versions used to  generate the DWFs sent back to the client.
 * @return  Returns an {@link MgByteReader} object containing a DWF in ePlot format.
 * @exception  MgNullArgumentException
 */
 public MgByteReader generatePlot(MgMap map, MgEnvelope extents, boolean expandToFit, MgPlotSpecification plotSpec, MgLayout layout, MgDwfVersion dwfVersion) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_GeneratePlot__SWIG_2(swigCPtr, MgMap.getCPtr(map), MgEnvelope.getCPtr(extents), expandToFit, MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout), MgDwfVersion.getCPtr(dwfVersion));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  mapPlots ({@link MgMapPlotCollection})  A collection of MapPlot objects.
 * @param  dwfVersion ({@link MgDwfVersion})  DWF specification required by the client. This  determines the schema and file versions used to  generate the DWFs sent back to the client.
 * @return  Returns an {@link MgByteReader} object containing a DWF
 *  in ePlot format with multiple sheets, one for each
 *  map.
 * @exception  MgNullArgumentException
 */
 public MgByteReader generateMultiPlot(MgMapPlotCollection mapPlots, MgDwfVersion dwfVersion) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_GenerateMultiPlot(swigCPtr, MgMapPlotCollection.getCPtr(mapPlots), MgDwfVersion.getCPtr(dwfVersion));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * GenerateLegendImage() returns the legend image for the specified layer.
 *
 * @param  resource ({@link MgResourceIdentifier})  Input  {@link MgResourceIdentifier} object identifying the layer definition resource.
 * @param  scale (double)  Input  The scale at which the symbolization is requested.
 * @param  width (int)  Input  The requested image width in pixels.
 * @param  height (int)  Input  The requested image height in pixels.
 * @param  format (String/string)  Input  Image format, from {@link MgImageFormats}. Example: PNG, JPG, PNG8, etc
 * @param  geomType (int)  Input  The type of symbolization required: 1=Point, 2=Line, 3=Area, 4=Composite
 * @param  themeCategory (int)  Input  The value indicating which theme category swatch to return.  Used when there is a theme defined at this scale. An exception will be  thrown if a requested them category doesn't exist.
 * @return  Returns a stream representing the legend image.
 *  The default returned image format will be PNG8 unless a different supported
 *  format is requested. An exception will be thrown if an unsupported image
 *  format is requested.
 * @exception  MgArgumentOutOfRangeException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgNullArgumentException
 * @exception  MgInvalidImageFormatException
 */
 public MgByteReader generateLegendImage(MgResourceIdentifier resource, double scale, int width, int height, String format, int geomType, int themeCategory) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_GenerateLegendImage(swigCPtr, MgResourceIdentifier.getCPtr(resource), scale, width, height, format, geomType, themeCategory);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a new runtime map from the specified Map Definition resource id and returns an XML-based description of the runtime
 * map
 *
 * @param  mapDefinition ({@link MgResourceIdentifier})  {@link MgResourceIdentifier} object identifying the map definition resource.
 * @param  sessionId (String/string)  The session ID
 * @param  requestedFeatures (int)  A bitmask representing the desired information to return in the XML response:  1=Layer/Group structure, 2=Layer Icons, 4=Layer Feature Source Information
 * @param  iconsPerScaleRange (int)  The number of legend icons per scale range to render inline in the XML response as base64 strings.  If a scale range contains a number of rules that exceeds this value, only the first and  last rules of a type style in the scale range will have inline icons
 * @return  Returns an XML-based description of the runtime map
 */
 public MgByteReader createRuntimeMap(MgResourceIdentifier mapDefinition, String sessionId, int requestedFeatures, int iconsPerScaleRange) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_CreateRuntimeMap__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(mapDefinition), sessionId, requestedFeatures, iconsPerScaleRange);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a new runtime map from the specified Map Definition resource id and returns an XML-based description of the runtime
 * map
 *
 * @param  mapDefinition ({@link MgResourceIdentifier})  {@link MgResourceIdentifier} object identifying the map definition resource.
 * @param  targetMapName (String/string)  The desired name of the runtime map
 * @param  sessionId (String/string)  The session ID
 * @param  iconFormat (String/string)  The desired image format for icons (from {@link MgImageFormats})
 * @param  iconWidth (int)  The width of each individual inline legend icons. Has no effect if icons was not requested in the response.
 * @param  iconHeight (int)  The height of each individual inline legend icons. Has no effect if icons was not requested in the response.
 * @param  requestedFeatures (int)  A bitmask representing the desired information to return in the XML response:  1=Layer/Group structure, 2=Layer Icons, 4=Layer Feature Source Information
 * @param  iconsPerScaleRange (int)  The number of legend icons per scale range to render inline in the XML response as base64 strings.  If a scale range contains a number of rules that exceeds this value, only the first and  last rules of a type style in the scale range will have inline icons
 * @return  Returns an XML-based description of the runtime map
 * @exception  MgInvalidArgumentException
 * @exception  MgNullArgumentException
 */
 public MgByteReader createRuntimeMap(MgResourceIdentifier mapDefinition, String targetMapName, String sessionId, String iconFormat, int iconWidth, int iconHeight, int requestedFeatures, int iconsPerScaleRange) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_CreateRuntimeMap__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(mapDefinition), targetMapName, sessionId, iconFormat, iconWidth, iconHeight, requestedFeatures, iconsPerScaleRange);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns an XML-based description of the runtime map
 *
 * @param  map ({@link MgMap})  The map to describe
 * @param  requestedFeatures (int)  A bitmask representing the desired information to return in the XML response:  1=Layer/Group structure, 2=Layer Icons, 4=Layer Feature Source Information
 * @param  iconsPerScaleRange (int)  The number of legend icons per scale range to render inline in the XML response as base64 strings.  If a scale range contains a number of rules that exceeds this value, only the first and  last rules of a type style in the scale range will have inline icons
 * @return  Returns an XML-based description of the runtime map
 */
 public MgByteReader describeRuntimeMap(MgMap map, int requestedFeatures, int iconsPerScaleRange) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_DescribeRuntimeMap__SWIG_0(swigCPtr, MgMap.getCPtr(map), requestedFeatures, iconsPerScaleRange);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns an XML-based description of the given runtime map
 *
 * @param  map ({@link MgMap})  The map to describe
 * @param  iconFormat (String/string)  The desired image format for icons (from {@link MgImageFormats})
 * @param  iconWidth (int)  The width of each individual inline legend icons. Has no effect if icons was not requested in the response.
 * @param  iconHeight (int)  The height of each individual inline legend icons. Has no effect if icons was not requested in the response.
 * @param  requestedFeatures (int)  A bitmask representing the desired information to return in the XML response:  1=Layer/Group structure, 2=Layer Icons, 4=Layer Feature Source Information
 * @param  iconsPerScaleRange (int)  The number of legend icons per scale range to render inline in the XML response as base64 strings.  If a scale range contains a number of rules that exceeds this value, only the first and  last rules of a type style in the scale range will have inline icons
 * @return  Returns an XML-based description of the runtime map
 * @exception  MgInvalidArgumentException
 * @exception  MgNullArgumentException
 */
 public MgByteReader describeRuntimeMap(MgMap map, String iconFormat, int iconWidth, int iconHeight, int requestedFeatures, int iconsPerScaleRange) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_DescribeRuntimeMap__SWIG_1(swigCPtr, MgMap.getCPtr(map), iconFormat, iconWidth, iconHeight, requestedFeatures, iconsPerScaleRange);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Queries and returns each of the visible features on the
 * specified layer of the specified map.
 *
 * @param  map  Input map object containing current viewed  state of map.
 * @param  layerName  Input name of the layer to query properties  for
 * @param  coordinateSpace  Input specifies the coordinate system the  geometry should be returned in. See  {@link MgCoordinateSpace}
 * @return  A byte reader containing an XML document with the feature
 *  information described in GML (Geography Markup Language). GML
 *  is defined by the OpenGIS consortium. A specification for
 *  this language can be found at: /// https://portal.opengeospatial.org/files/?artifact_id=7174
 */
 public MgByteReader queryFeatures(MgMap map, String layerName, String coordinateSpace) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_QueryFeatures__SWIG_0(swigCPtr, MgMap.getCPtr(map), layerName, coordinateSpace);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Queries feature information for each feature visible at the
 * specified point of interest, on a given set of layers.
 *
 * @param  map  Map object containing current view state of the  map.
 * @param  layerNames  List of layers to return information from. Each  layer must be in the specified {@link MgMap} object
 * @param  x  X coordinate for point of interest
 * @param  y  Y coordinate for point of interest
 * @param  maxFeatures  Maximum number of feature that should be returned  for a given layer greater than 0, usually 1. If  the number of features sharing the requested  location is greater than maxFeatures the subset of  features returned depends on the provider.
 * @param  coordinateSpace  Input specifies the coordinate system the  geometry should be returned in. See  {@link MgCoordinateSpace}
 * @return  Returns a byte reader containing an XML document with the feature
 *  information described in GML (Geography Markup Language). GML
 *  is defined by the OpenGIS consortium. A specification for
 *  this language can be found at: /// https://portal.opengeospatial.org/files/?artifact_id=7174
 */
 public MgByteReader queryFeatures(MgMap map, MgStringCollection layerNames, int x, int y, int maxFeatures, String coordinateSpace) {
    long cPtr = MapGuideJavaApiExJNI.MgMappingService_QueryFeatures__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgStringCollection.getCPtr(layerNames), x, y, maxFeatures, coordinateSpace);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
