/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgParameterCollection} represents a collection of parameters.
 * All parameters contained in an instance of a parameter
 * collection are objects whose base class is {@link MgParameter}.
 * A call to a parameter object's GetType() method returns one
 * of the integer constants defined in class {@link MgPropertyType}.
 * This collection does not allow duplicate key names.
 *
 * @since  2.2 */
 public class MgParameterCollection extends MgCollection {
  private long swigCPtr;

  public MgParameterCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgParameterCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgParameterCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgParameterCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a {@link MgParameterCollection}.
 * The collection is initially empty.
 *
 */
 public MgParameterCollection() {
    this(MapGuideJavaApiExJNI.new_MgParameterCollection(), true);
  }

  
/**
 * Sets the item in the collection at the specified index to the specified value.
 *
 * @param  index (int)  Input index.
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void setItem(int index, MgParameter value) {
    MapGuideJavaApiExJNI.MgParameterCollection_SetItem(swigCPtr, index, MgParameter.getCPtr(value));
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns nothing.
 * @exception  MgDuplicateObjectException if the index is a duplicate.
 */
 public void add(MgParameter value) {
    MapGuideJavaApiExJNI.MgParameterCollection_Add(swigCPtr, MgParameter.getCPtr(value));
  }

  
/**
 * Inserts the specified item at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void insert(int index, MgParameter value) {
    MapGuideJavaApiExJNI.MgParameterCollection_Insert(swigCPtr, index, MgParameter.getCPtr(value));
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgParameter value) {
    return MapGuideJavaApiExJNI.MgParameterCollection_Remove(swigCPtr, MgParameter.getCPtr(value));
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index.
 * @return  Returns the item in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public MgParameter getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgParameterCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgParameter)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns the number of items in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgParameterCollection_GetCount(swigCPtr);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgParameterCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgParameterCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean contains(MgParameter value) {
    return MapGuideJavaApiExJNI.MgParameterCollection_Contains(swigCPtr, MgParameter.getCPtr(value));
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value ({@link MgParameter})  Input value.
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int indexOf(MgParameter value) {
    return MapGuideJavaApiExJNI.MgParameterCollection_IndexOf(swigCPtr, MgParameter.getCPtr(value));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader toXml() {
    long cPtr = MapGuideJavaApiExJNI.MgParameterCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
