/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgPointCollection} provides support for defining an ordered set of
 * points.
 *
 */
 public class MgPointCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgPointCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgPointCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgPointCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgPointCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of points in the collection.
 *
 * @return  Returns number of points in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgPointCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the point in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the point to retrieve.
 * @return  Returns the point in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgPoint getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgPointCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgPoint)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the point in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgPoint})  point to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgPoint value) {
    MapGuideJavaApiExJNI.MgPointCollection_SetItem(swigCPtr, index, MgPoint.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgPoint})  point to add to the collection.
 * @return  Returns nothing.
 */
 public void add(MgPoint value) {
    MapGuideJavaApiExJNI.MgPointCollection_Add(swigCPtr, MgPoint.getCPtr(value));
  }

  
/**
 * Inserts the specified point at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgPoint})  point to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgPoint value) {
    MapGuideJavaApiExJNI.MgPointCollection_Insert(swigCPtr, index, MgPoint.getCPtr(value));
  }

  
/**
 * Removes all points from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgPointCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified point from the collection.
 *
 * @param  value ({@link MgPoint})  point reference to remove.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgPoint value) {
    return MapGuideJavaApiExJNI.MgPointCollection_Remove(swigCPtr, MgPoint.getCPtr(value));
  }

  
/**
 * Removes the point at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the point to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgPointCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified point, false
 * otherwise.
 *
 * @param  value ({@link MgPoint})  point reference to check containment of.
 * @return  True if the collection contains the specified point, false
 *  otherwise.
 */
 public boolean contains(MgPoint value) {
    return MapGuideJavaApiExJNI.MgPointCollection_Contains(swigCPtr, MgPoint.getCPtr(value));
  }

  
/**
 * Returns the index of the specified point in the collection or -1
 * if the point does not exist.
 *
 * @param  value ({@link MgPoint})  point reference to find the index of.
 * @return  The index of the specified point in the collection or -1 if the
 *  point does not exist.
 */
 public int indexOf(MgPoint value) {
    return MapGuideJavaApiExJNI.MgPointCollection_IndexOf(swigCPtr, MgPoint.getCPtr(value));
  }

  
/**
 * Construct a {@link MgPointCollection} object
 *
 */
 public MgPointCollection() {
    this(MapGuideJavaApiExJNI.new_MgPointCollection(), true);
  }

}
