/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;


import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.NoSuchElementException;


/**
 * {@link MgPropertyCollection} represents a collection of properties.
 * All properties contained in an instance of a property
 * collection are objects whose base class is {@link MgProperty} and
 * whose derived class is one of the classes referenced in the
 *
 */
 public class MgPropertyCollection extends MgCollection implements Collection<MgProperty> {
  private long swigCPtr;

  public MgPropertyCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgPropertyCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgPropertyCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgPropertyCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    /**
     * An iterator to iterate over this collection
     */
    class ItemIterator implements Iterator<MgProperty> {
        private MgPropertyCollection _collection;
        private int _pos;
        private int _count;
        
        public ItemIterator(MgPropertyCollection c) { 
            _collection = c; 
            _count = _collection.getCount();
            _pos = -1;
        }
        
        /**
         * Returns true if the iteration has more elements
         */
        public boolean hasNext() {
            return _pos + 1 < _count;
        }
        
        /**
         * Returns the next MgProperty in the collection
         */
        public MgProperty next() {
            _pos++;
            if (_pos >= _count)
                throw new NoSuchElementException();
            return _collection.getItem(_pos);
        }
        
        /**
         * Removes from the underlying collection the last element returned by the iterator (not supported).
         */
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
    /**
     * Returns an iterator over the elements in this collection.
     */
    public Iterator<MgProperty> iterator() { return new ItemIterator(this); }

    /**
     * Ensures that this collection contains the specified element (optional operation).
     */
    public boolean add(MgProperty item) {
        this.addItem(item);
        return true;
    }

    /**
     * Adds all of the elements in the specified collection to this collection (optional operation).
     */
    public boolean addAll(Collection<? extends MgProperty> c) {
        int added = 0;
        for (MgProperty item : c) {
            this.addItem(item);
            added++;
        }
        return added > 0;
    }

    /**
     *  Returns true if this collection contains the specified element.
     */
    public boolean contains(Object o) {
        if (o instanceof MgProperty) {
            return this.contains((MgProperty)o);
        }
        return false;
    }

    /**
     * Returns true if this collection contains all of the elements in the specified collection.
     */
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o))
                return false;
        }
        return true;
    }

    /**
     * Returns true if this collection contains no elements.
     */
    public boolean isEmpty() { return this.getCount() == 0; }

    /**
     * Removes a single instance of the specified element from this collection, if it is present (optional operation).
     */
    public boolean remove(Object o) {
        if (o instanceof MgProperty) {
            return this.remove((MgProperty)o);
        }
        return false;
    }

    /**
     * Removes all of this collection's elements that are also contained in the specified collection (optional operation).
     */
    public boolean removeAll(Collection<?> c) {
        int removed = 0;
        for (Object o : c) {
            if (this.remove(o))
                removed++;
        }
        return removed > 0;
    }

    /**
     * Retains only the elements in this collection that are contained in the specified collection (optional operation).
     */
    public boolean retainAll(Collection<?> c) {
        int removed = 0;
        ArrayList<MgProperty> remove = new ArrayList<MgProperty>();
        for (int i = 0; i < this.getCount(); i++) {
            MgProperty item = this.getItem(i);
            if (!c.contains(item))
                remove.add(item);
        }
        if (remove.size() > 0) {
            return this.removeAll(remove);
        } else {
            return false;
        }
    }

    /**
     * Returns the number of elements in this collection.
     */
    public int size() { return this.getCount(); }

    /**
     * Returns an array containing all of the elements in this collection.
     */
    public Object[] toArray() {
        int count = this.getCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; i++) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    /**
     * Returns an array containing all of the elements in this collection; the runtime type of the returned array is that of the specified array.
     */
    public <MgProperty> MgProperty[] toArray(MgProperty[] a) {
        Object[] items = this.toArray();
        if (a.length >= items.length) {
            for (int i = 0; i < items.length; i++) {
                a[i] = (MgProperty)items[i];
            }
            for (int i = items.length; i < a.length; i++) {
                a[i] = null;
            }
            return a;
        } else {
            MgProperty[] retVal = (MgProperty[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), items.length);
            for (int i = 0; i < retVal.length; i++) {
                retVal[i] = (MgProperty)items[i];
            }
            return retVal;
        }
    }


  
/**
 * Constructs a PropertyCollection.  The collection is initially empty.
 *
 */
 public MgPropertyCollection() {
    this(MapGuideJavaApiExJNI.new_MgPropertyCollection(), true);
  }

  
/**
 * Sets the item in the collection at the specified index to the specified value.
 *
 * @param  index (int)  Input index
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void setItem(int index, MgProperty value) {
    MapGuideJavaApiExJNI.MgPropertyCollection_SetItem(swigCPtr, index, MgProperty.getCPtr(value));
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgDuplicateObjectException if the index is a duplicate.
 */
 public void addItem(MgProperty value) {
    MapGuideJavaApiExJNI.MgPropertyCollection_addItem(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Inserts the specified item at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void insert(int index, MgProperty value) {
    MapGuideJavaApiExJNI.MgPropertyCollection_Insert(swigCPtr, index, MgProperty.getCPtr(value));
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgProperty value) {
    return MapGuideJavaApiExJNI.MgPropertyCollection_Remove(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the item in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public MgProperty getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgPropertyCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the item in the collection with the specified name.
 *
 * @param  name (String/string)  Input item name
 * @return  Returns the item in the collection with the specified name.
 * @exception  MgObjectNotFoundException if the item does not exist within the collection.
 */
 public MgProperty getItem(String name) {
    long cPtr = MapGuideJavaApiExJNI.MgPropertyCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns the number of items in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgPropertyCollection_GetCount(swigCPtr);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgPropertyCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgPropertyCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean contains(MgProperty value) {
    return MapGuideJavaApiExJNI.MgPropertyCollection_Contains__SWIG_0(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  name (String/string)  Input the item name
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean contains(String name) {
    return MapGuideJavaApiExJNI.MgPropertyCollection_Contains__SWIG_1(swigCPtr, name);
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int indexOf(MgProperty value) {
    return MapGuideJavaApiExJNI.MgPropertyCollection_IndexOf__SWIG_0(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Returns the index of the specified item (by name) in the collection or -1 if the item does not exist.
 *
 * @param  name (String/string)  Input the item name
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int indexOf(String name) {
    return MapGuideJavaApiExJNI.MgPropertyCollection_IndexOf__SWIG_1(swigCPtr, name);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 * The order of the properties in the XML is the same as the order of the properties in the collection.
 * It starts with item zero to length of collection.
 * TODO: Add a snippet of XML here?
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader toXml() {
    long cPtr = MapGuideJavaApiExJNI.MgPropertyCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
