/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Creates and manipulates resource identifiers.
 *
 */
 public class MgResourceIdentifier extends MgSerializable {
  private long swigCPtr;

  public MgResourceIdentifier(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgResourceIdentifierToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgResourceIdentifier() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgResourceIdentifier(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgResourceIdentifier obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Initialize and validate a resource identifier from a string.
 *
 * @param  resource (String/string)
 * @exception  MgOutOfMemoryException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgInvalidRepositoryTypeException
 */
 public MgResourceIdentifier(String resource) {
    this(MapGuideJavaApiExJNI.new_MgResourceIdentifier(resource), true);
  }

  
/**
 * Extracts the repository type from a resource's identifier.
 *
 * @return  Returns the repository type. Legal repository types are
 */
 public String getRepositoryType() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_GetRepositoryType(swigCPtr); }
}

  
/**
 * Sets the repository type.
 *
 * @param  type (String/string)  Repository type string.  Legal repository
 * @return  Returns nothing.
 *  <!-- Examples (PHP) -->
 */
 public void setRepositoryType(String type) {
    MapGuideJavaApiExJNI.MgResourceIdentifier_SetRepositoryType(swigCPtr, type);
  }

  
/**
 * Extracts the repository name from a resource's identifier.
 *
 * @return  Returns the repository name. For session repositories, the
 *  name is the session ID. For library repositories, the name is
 *  an empty string.
 */
 public String getRepositoryName() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_GetRepositoryName(swigCPtr); }
}

  
/**
 * Sets the repository name.
 *
 * @param  name (String/string)  Repository name.  <ul>  <li>If the repository is the library, the name must be an empty string.</li>  <li>If the repository is a session repository, the name cannot be empty.</li>  </ul>
 * @return  Returns nothing.
 *  <!-- Examples (PHP) -->
 */
 public void setRepositoryName(String name) {
    MapGuideJavaApiExJNI.MgResourceIdentifier_SetRepositoryName(swigCPtr, name);
  }

  
/**
 * Converts the resource identifier into a string.
 *
 * @return  Returns a fully qualified resource specifier string.
 */
 public String toString() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_ToString(swigCPtr); }
}

  
/**
 * Extracts the resource's path from the resource identifier.
 *
 * @return  Returns the resource's path.
 */
 public String getPath() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_GetPath(swigCPtr); }
}

  
/**
 * Set the resource path within the repository.
 *
 * @param  path (String/string)  Resource path within the repository. It can contain  spaces but cannot contain any of the characters
 * @return  Returns nothing.
 */
 public void setPath(String path) {
    MapGuideJavaApiExJNI.MgResourceIdentifier_SetPath(swigCPtr, path);
  }

  
/**
 * Extracts the resource's name from the resource identifier.
 *
 * @return  Returns the resource name.
 */
 public String getName() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_GetName(swigCPtr); }
}

  
/**
 * Set the resource name
 *
 * @param  name (String/string)  Resource name. It can contain spaces but  cannot contain any of the characters  %*:|?<'&">=
 * @return  Returns nothing.
 */
 public void setName(String name) {
    MapGuideJavaApiExJNI.MgResourceIdentifier_SetName(swigCPtr, name);
  }

  
/**
 * Extracts the resource's type from the resource identifier.
 *
 * @return  Returns the resource's type string, as defined in
 *  {@link MgResourceType}.
 */
 public String getResourceType() {
  { return MapGuideJavaApiExJNI.MgResourceIdentifier_GetResourceType(swigCPtr); }
}

  
/**
 * Sets the resource type.
 *
 * @param  type (String/string)
 * @return  Returns nothing.
 */
 public void setResourceType(String type) {
    MapGuideJavaApiExJNI.MgResourceIdentifier_SetResourceType(swigCPtr, type);
  }

  
/**
 * Validates the resource identifier.  This method should be called
 * after the identifier has been fully specified by constructor and/or
 * Set methods.
 *
 * @return  Returns nothing.
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public void validate() {
    MapGuideJavaApiExJNI.MgResourceIdentifier_Validate(swigCPtr);
  }

}
