/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;


import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.NoSuchElementException;


/**
 * This class represents a collection of strings.  The collection maintains its own copy of strings.
 *
 */
 public class MgStringCollection extends MgCollection implements Collection<String> {
  private long swigCPtr;

  public MgStringCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgStringCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgStringCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgStringCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    /**
     * An iterator to iterate over this collection
     */
    class ItemIterator implements Iterator<String> {
        private MgStringCollection _collection;
        private int _pos;
        private int _count;
        
        public ItemIterator(MgStringCollection c) { 
            _collection = c; 
            _count = _collection.getCount();
            _pos = -1;
        }
        
        /**
         * Returns true if the iteration has more elements
         */
        public boolean hasNext() {
            return _pos + 1 < _count;
        }
        
        /**
         * Returns the next String in the collection
         */
        public String next() {
            _pos++;
            if (_pos >= _count)
                throw new NoSuchElementException();
            return _collection.getItem(_pos);
        }
        
        /**
         * Removes from the underlying collection the last element returned by the iterator (not supported).
         */
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
    /**
     * Returns an iterator over the elements in this collection.
     */
    public Iterator<String> iterator() { return new ItemIterator(this); }

    /**
     * Ensures that this collection contains the specified element (optional operation).
     */
    public boolean add(String item) {
        this.addItem(item);
        return true;
    }

    /**
     * Adds all of the elements in the specified collection to this collection (optional operation).
     */
    public boolean addAll(Collection<? extends String> c) {
        int added = 0;
        for (String item : c) {
            this.addItem(item);
            added++;
        }
        return added > 0;
    }

    /**
     *  Returns true if this collection contains the specified element.
     */
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.contains((String)o);
        }
        return false;
    }

    /**
     * Returns true if this collection contains all of the elements in the specified collection.
     */
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o))
                return false;
        }
        return true;
    }

    /**
     * Returns true if this collection contains no elements.
     */
    public boolean isEmpty() { return this.getCount() == 0; }

    /**
     * Removes a single instance of the specified element from this collection, if it is present (optional operation).
     */
    public boolean remove(Object o) {
        if (o instanceof String) {
            return this.remove((String)o);
        }
        return false;
    }

    /**
     * Removes all of this collection's elements that are also contained in the specified collection (optional operation).
     */
    public boolean removeAll(Collection<?> c) {
        int removed = 0;
        for (Object o : c) {
            if (this.remove(o))
                removed++;
        }
        return removed > 0;
    }

    /**
     * Retains only the elements in this collection that are contained in the specified collection (optional operation).
     */
    public boolean retainAll(Collection<?> c) {
        int removed = 0;
        ArrayList<String> remove = new ArrayList<String>();
        for (int i = 0; i < this.getCount(); i++) {
            String item = this.getItem(i);
            if (!c.contains(item))
                remove.add(item);
        }
        if (remove.size() > 0) {
            return this.removeAll(remove);
        } else {
            return false;
        }
    }

    /**
     * Returns the number of elements in this collection.
     */
    public int size() { return this.getCount(); }

    /**
     * Returns an array containing all of the elements in this collection.
     */
    public Object[] toArray() {
        int count = this.getCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; i++) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    /**
     * Returns an array containing all of the elements in this collection; the runtime type of the returned array is that of the specified array.
     */
    public <String> String[] toArray(String[] a) {
        Object[] items = this.toArray();
        if (a.length >= items.length) {
            for (int i = 0; i < items.length; i++) {
                a[i] = (String)items[i];
            }
            for (int i = items.length; i < a.length; i++) {
                a[i] = null;
            }
            return a;
        } else {
            String[] retVal = (String[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), items.length);
            for (int i = 0; i < retVal.length; i++) {
                retVal[i] = (String)items[i];
            }
            return retVal;
        }
    }


  
/**
 * Constructs a StringCollection.  The collection is initially empty.
 *
 */
 public MgStringCollection() {
    this(MapGuideJavaApiExJNI.new_MgStringCollection(), true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns the number of items in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgStringCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the item in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public String getItem(int index) {
  { return MapGuideJavaApiExJNI.MgStringCollection_GetItem(swigCPtr, index); }
}

  
/**
 * Sets the item in the collection at the specified index position to the specified value.
 *
 * @param  index (int)  Input index
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void setItem(int index, String value) {
    MapGuideJavaApiExJNI.MgStringCollection_SetItem(swigCPtr, index, value);
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 */
 public void addItem(String value) {
    MapGuideJavaApiExJNI.MgStringCollection_addItem(swigCPtr, value);
  }

  
/**
 * Inserts the specified item at the specified index position within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void insert(int index, String value) {
    MapGuideJavaApiExJNI.MgStringCollection_Insert(swigCPtr, index, value);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgStringCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value (String/string)  Input value
 * @return  Returns true if removal was successful.
 */
 public boolean remove(String value) {
    return MapGuideJavaApiExJNI.MgStringCollection_Remove(swigCPtr, value);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgStringCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value (String/string)  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean contains(String value) {
    return MapGuideJavaApiExJNI.MgStringCollection_Contains(swigCPtr, value);
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value (String/string)  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int indexOf(String value) {
    return MapGuideJavaApiExJNI.MgStringCollection_IndexOf(swigCPtr, value);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 * The order of the properties in the XML is the same as the order of properties in the collection.
 * It starts with item zero to length of collection.
 * TODO: Add a snippet of XML here?
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader toXml() {
    long cPtr = MapGuideJavaApiExJNI.MgStringCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
