/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.mapguide;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgeo.mapguide.MapGuideJavaApiExJNI;
import org.osgeo.mapguide.MgByteReader;
import org.osgeo.mapguide.MgCollection;
import org.osgeo.mapguide.MgFeatureSchema;
import org.osgeo.mapguide.ObjectFactory;

public class MgFeatureSchemaCollection
extends MgCollection
implements Collection<MgFeatureSchema> {
    private long swigCPtr;

    public MgFeatureSchemaCollection(long l, boolean bl) {
        super(MapGuideJavaApiExJNI.SWIGMgFeatureSchemaCollectionToMgCollection(l), bl);
        this.swigCPtr = l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            MapGuideJavaApiExJNI.delete_MgFeatureSchemaCollection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtr(MgFeatureSchemaCollection mgFeatureSchemaCollection) {
        return mgFeatureSchemaCollection == null ? 0L : mgFeatureSchemaCollection.swigCPtr;
    }

    @Override
    public Iterator<MgFeatureSchema> iterator() {
        return new ItemIterator(this);
    }

    @Override
    public boolean add(MgFeatureSchema mgFeatureSchema) {
        this.addItem(mgFeatureSchema);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends MgFeatureSchema> collection) {
        int n = 0;
        for (MgFeatureSchema mgFeatureSchema : collection) {
            this.addItem(mgFeatureSchema);
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof MgFeatureSchema) {
            return this.contains((MgFeatureSchema)object);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof MgFeatureSchema) {
            return this.remove((MgFeatureSchema)object);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = 0;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        ArrayList<MgFeatureSchema> arrayList = new ArrayList<MgFeatureSchema>();
        for (int i = 0; i < this.getCount(); ++i) {
            MgFeatureSchema mgFeatureSchema = this.getItem(i);
            if (collection.contains(mgFeatureSchema)) continue;
            arrayList.add(mgFeatureSchema);
        }
        if (arrayList.size() > 0) {
            return this.removeAll(arrayList);
        }
        return false;
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public Object[] toArray() {
        int n = this.getCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getItem(i);
        }
        return objectArray;
    }

    @Override
    public <MgFeatureSchema> MgFeatureSchema[] toArray(MgFeatureSchema[] MgFeatureSchemaArray) {
        Object[] objectArray = this.toArray();
        if (MgFeatureSchemaArray.length >= objectArray.length) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                MgFeatureSchemaArray[n] = objectArray[n];
            }
            for (n = objectArray.length; n < MgFeatureSchemaArray.length; ++n) {
                MgFeatureSchemaArray[n] = null;
            }
            return MgFeatureSchemaArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(MgFeatureSchemaArray.getClass().getComponentType(), objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public MgFeatureSchemaCollection() {
        this(MapGuideJavaApiExJNI.new_MgFeatureSchemaCollection(), true);
    }

    public void setItem(int n, MgFeatureSchema mgFeatureSchema) {
        MapGuideJavaApiExJNI.MgFeatureSchemaCollection_SetItem(this.swigCPtr, n, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    public void addItem(MgFeatureSchema mgFeatureSchema) {
        MapGuideJavaApiExJNI.MgFeatureSchemaCollection_addItem(this.swigCPtr, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    public void insert(int n, MgFeatureSchema mgFeatureSchema) {
        MapGuideJavaApiExJNI.MgFeatureSchemaCollection_Insert(this.swigCPtr, n, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    public boolean remove(MgFeatureSchema mgFeatureSchema) {
        return MapGuideJavaApiExJNI.MgFeatureSchemaCollection_Remove(this.swigCPtr, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    public MgFeatureSchema getItem(int n) {
        long l = MapGuideJavaApiExJNI.MgFeatureSchemaCollection_GetItem(this.swigCPtr, n);
        return l == 0L ? null : (MgFeatureSchema)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    @Override
    public int getCount() {
        return MapGuideJavaApiExJNI.MgFeatureSchemaCollection_GetCount(this.swigCPtr);
    }

    @Override
    public void clear() {
        MapGuideJavaApiExJNI.MgFeatureSchemaCollection_Clear(this.swigCPtr);
    }

    @Override
    public void removeAt(int n) {
        MapGuideJavaApiExJNI.MgFeatureSchemaCollection_RemoveAt(this.swigCPtr, n);
    }

    public boolean contains(MgFeatureSchema mgFeatureSchema) {
        return MapGuideJavaApiExJNI.MgFeatureSchemaCollection_Contains(this.swigCPtr, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    public int indexOf(MgFeatureSchema mgFeatureSchema) {
        return MapGuideJavaApiExJNI.MgFeatureSchemaCollection_IndexOf(this.swigCPtr, MgFeatureSchema.getCPtr(mgFeatureSchema));
    }

    @Override
    public MgByteReader toXml() {
        long l = MapGuideJavaApiExJNI.MgFeatureSchemaCollection_ToXml(this.swigCPtr);
        return l == 0L ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    class ItemIterator
    implements Iterator<MgFeatureSchema> {
        private MgFeatureSchemaCollection _collection;
        private int _pos;
        private int _count;

        public ItemIterator(MgFeatureSchemaCollection mgFeatureSchemaCollection2) {
            this._collection = mgFeatureSchemaCollection2;
            this._count = this._collection.getCount();
            this._pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this._pos + 1 < this._count;
        }

        @Override
        public MgFeatureSchema next() {
            ++this._pos;
            if (this._pos >= this._count) {
                throw new NoSuchElementException();
            }
            return this._collection.getItem(this._pos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

