/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.mapguide;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgeo.mapguide.MapGuideJavaApiExJNI;
import org.osgeo.mapguide.MgGuardDisposable;
import org.osgeo.mapguide.MgLayerBase;
import org.osgeo.mapguide.ObjectFactory;

public class MgLayerCollection
extends MgGuardDisposable
implements Collection<MgLayerBase> {
    private long swigCPtr;

    public MgLayerCollection(long l, boolean bl) {
        super(MapGuideJavaApiExJNI.SWIGMgLayerCollectionToMgGuardDisposable(l), bl);
        this.swigCPtr = l;
    }

    protected MgLayerCollection() {
        this(0L, false);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            MapGuideJavaApiExJNI.delete_MgLayerCollection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtr(MgLayerCollection mgLayerCollection) {
        return mgLayerCollection == null ? 0L : mgLayerCollection.swigCPtr;
    }

    @Override
    public Iterator<MgLayerBase> iterator() {
        return new ItemIterator(this);
    }

    @Override
    public boolean add(MgLayerBase mgLayerBase) {
        this.addItem(mgLayerBase);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends MgLayerBase> collection) {
        int n = 0;
        for (MgLayerBase mgLayerBase : collection) {
            this.addItem(mgLayerBase);
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof MgLayerBase) {
            return this.contains((MgLayerBase)object);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof MgLayerBase) {
            return this.remove((MgLayerBase)object);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = 0;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        ArrayList<MgLayerBase> arrayList = new ArrayList<MgLayerBase>();
        for (int i = 0; i < this.getCount(); ++i) {
            MgLayerBase mgLayerBase = this.getItem(i);
            if (collection.contains(mgLayerBase)) continue;
            arrayList.add(mgLayerBase);
        }
        if (arrayList.size() > 0) {
            return this.removeAll(arrayList);
        }
        return false;
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public Object[] toArray() {
        int n = this.getCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getItem(i);
        }
        return objectArray;
    }

    @Override
    public <MgLayerBase> MgLayerBase[] toArray(MgLayerBase[] MgLayerBaseArray) {
        Object[] objectArray = this.toArray();
        if (MgLayerBaseArray.length >= objectArray.length) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                MgLayerBaseArray[n] = objectArray[n];
            }
            for (n = objectArray.length; n < MgLayerBaseArray.length; ++n) {
                MgLayerBaseArray[n] = null;
            }
            return MgLayerBaseArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(MgLayerBaseArray.getClass().getComponentType(), objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public int getCount() {
        return MapGuideJavaApiExJNI.MgLayerCollection_GetCount(this.swigCPtr);
    }

    public MgLayerBase getItem(int n) {
        long l = MapGuideJavaApiExJNI.MgLayerCollection_GetItem__SWIG_0(this.swigCPtr, n);
        return l == 0L ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    public MgLayerBase getItem(String string) {
        long l = MapGuideJavaApiExJNI.MgLayerCollection_GetItem__SWIG_1(this.swigCPtr, string);
        return l == 0L ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    public void setItem(int n, MgLayerBase mgLayerBase) {
        MapGuideJavaApiExJNI.MgLayerCollection_SetItem(this.swigCPtr, n, MgLayerBase.getCPtr(mgLayerBase));
    }

    public void addItem(MgLayerBase mgLayerBase) {
        MapGuideJavaApiExJNI.MgLayerCollection_addItem(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    public void insert(int n, MgLayerBase mgLayerBase) {
        MapGuideJavaApiExJNI.MgLayerCollection_Insert(this.swigCPtr, n, MgLayerBase.getCPtr(mgLayerBase));
    }

    @Override
    public void clear() {
        MapGuideJavaApiExJNI.MgLayerCollection_Clear(this.swigCPtr);
    }

    public boolean remove(MgLayerBase mgLayerBase) {
        return MapGuideJavaApiExJNI.MgLayerCollection_Remove(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    public void removeAt(int n) {
        MapGuideJavaApiExJNI.MgLayerCollection_RemoveAt(this.swigCPtr, n);
    }

    public boolean contains(String string) {
        return MapGuideJavaApiExJNI.MgLayerCollection_Contains__SWIG_0(this.swigCPtr, string);
    }

    public boolean contains(MgLayerBase mgLayerBase) {
        return MapGuideJavaApiExJNI.MgLayerCollection_Contains__SWIG_1(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    public int indexOf(String string) {
        return MapGuideJavaApiExJNI.MgLayerCollection_IndexOf__SWIG_0(this.swigCPtr, string);
    }

    public int indexOf(MgLayerBase mgLayerBase) {
        return MapGuideJavaApiExJNI.MgLayerCollection_IndexOf__SWIG_1(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    class ItemIterator
    implements Iterator<MgLayerBase> {
        private MgLayerCollection _collection;
        private int _pos;
        private int _count;

        public ItemIterator(MgLayerCollection mgLayerCollection2) {
            this._collection = mgLayerCollection2;
            this._count = this._collection.getCount();
            this._pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this._pos + 1 < this._count;
        }

        @Override
        public MgLayerBase next() {
            ++this._pos;
            if (this._pos >= this._count) {
                throw new NoSuchElementException();
            }
            return this._collection.getItem(this._pos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

