/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.mapguide;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgeo.mapguide.MapGuideJavaApiExJNI;
import org.osgeo.mapguide.MgByteReader;
import org.osgeo.mapguide.MgCollection;
import org.osgeo.mapguide.MgProperty;
import org.osgeo.mapguide.ObjectFactory;

public class MgPropertyCollection
extends MgCollection
implements Collection<MgProperty> {
    private long swigCPtr;

    public MgPropertyCollection(long l, boolean bl) {
        super(MapGuideJavaApiExJNI.SWIGMgPropertyCollectionToMgCollection(l), bl);
        this.swigCPtr = l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            MapGuideJavaApiExJNI.delete_MgPropertyCollection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtr(MgPropertyCollection mgPropertyCollection) {
        return mgPropertyCollection == null ? 0L : mgPropertyCollection.swigCPtr;
    }

    @Override
    public Iterator<MgProperty> iterator() {
        return new ItemIterator(this);
    }

    @Override
    public boolean add(MgProperty mgProperty) {
        this.addItem(mgProperty);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends MgProperty> collection) {
        int n = 0;
        for (MgProperty mgProperty : collection) {
            this.addItem(mgProperty);
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof MgProperty) {
            return this.contains((MgProperty)object);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof MgProperty) {
            return this.remove((MgProperty)object);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = 0;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        ArrayList<MgProperty> arrayList = new ArrayList<MgProperty>();
        for (int i = 0; i < this.getCount(); ++i) {
            MgProperty mgProperty = this.getItem(i);
            if (collection.contains(mgProperty)) continue;
            arrayList.add(mgProperty);
        }
        if (arrayList.size() > 0) {
            return this.removeAll(arrayList);
        }
        return false;
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public Object[] toArray() {
        int n = this.getCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getItem(i);
        }
        return objectArray;
    }

    @Override
    public <MgProperty> MgProperty[] toArray(MgProperty[] MgPropertyArray) {
        Object[] objectArray = this.toArray();
        if (MgPropertyArray.length >= objectArray.length) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                MgPropertyArray[n] = objectArray[n];
            }
            for (n = objectArray.length; n < MgPropertyArray.length; ++n) {
                MgPropertyArray[n] = null;
            }
            return MgPropertyArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(MgPropertyArray.getClass().getComponentType(), objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public MgPropertyCollection() {
        this(MapGuideJavaApiExJNI.new_MgPropertyCollection(), true);
    }

    public void setItem(int n, MgProperty mgProperty) {
        MapGuideJavaApiExJNI.MgPropertyCollection_SetItem(this.swigCPtr, n, MgProperty.getCPtr(mgProperty));
    }

    public void addItem(MgProperty mgProperty) {
        MapGuideJavaApiExJNI.MgPropertyCollection_addItem(this.swigCPtr, MgProperty.getCPtr(mgProperty));
    }

    public void insert(int n, MgProperty mgProperty) {
        MapGuideJavaApiExJNI.MgPropertyCollection_Insert(this.swigCPtr, n, MgProperty.getCPtr(mgProperty));
    }

    public boolean remove(MgProperty mgProperty) {
        return MapGuideJavaApiExJNI.MgPropertyCollection_Remove(this.swigCPtr, MgProperty.getCPtr(mgProperty));
    }

    public MgProperty getItem(int n) {
        long l = MapGuideJavaApiExJNI.MgPropertyCollection_GetItem__SWIG_0(this.swigCPtr, n);
        return l == 0L ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    public MgProperty getItem(String string) {
        long l = MapGuideJavaApiExJNI.MgPropertyCollection_GetItem__SWIG_1(this.swigCPtr, string);
        return l == 0L ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    @Override
    public int getCount() {
        return MapGuideJavaApiExJNI.MgPropertyCollection_GetCount(this.swigCPtr);
    }

    @Override
    public void clear() {
        MapGuideJavaApiExJNI.MgPropertyCollection_Clear(this.swigCPtr);
    }

    @Override
    public void removeAt(int n) {
        MapGuideJavaApiExJNI.MgPropertyCollection_RemoveAt(this.swigCPtr, n);
    }

    public boolean contains(MgProperty mgProperty) {
        return MapGuideJavaApiExJNI.MgPropertyCollection_Contains__SWIG_0(this.swigCPtr, MgProperty.getCPtr(mgProperty));
    }

    public boolean contains(String string) {
        return MapGuideJavaApiExJNI.MgPropertyCollection_Contains__SWIG_1(this.swigCPtr, string);
    }

    public int indexOf(MgProperty mgProperty) {
        return MapGuideJavaApiExJNI.MgPropertyCollection_IndexOf__SWIG_0(this.swigCPtr, MgProperty.getCPtr(mgProperty));
    }

    public int indexOf(String string) {
        return MapGuideJavaApiExJNI.MgPropertyCollection_IndexOf__SWIG_1(this.swigCPtr, string);
    }

    @Override
    public MgByteReader toXml() {
        long l = MapGuideJavaApiExJNI.MgPropertyCollection_ToXml(this.swigCPtr);
        return l == 0L ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    class ItemIterator
    implements Iterator<MgProperty> {
        private MgPropertyCollection _collection;
        private int _pos;
        private int _count;

        public ItemIterator(MgPropertyCollection mgPropertyCollection2) {
            this._collection = mgPropertyCollection2;
            this._count = this._collection.getCount();
            this._pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this._pos + 1 < this._count;
        }

        @Override
        public MgProperty next() {
            ++this._pos;
            if (this._pos >= this._count) {
                throw new NoSuchElementException();
            }
            return this._collection.getItem(this._pos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

