/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public class MgCoordinateSystem extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystem(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystem() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystem(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystem obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the type of the coordinate system: arbitrary, geographic, or projected.
 *
 * @return  One of the values defined in {@link MgCoordinateSystemType}.
 */
 public int GetType() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetType(swigCPtr);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in lon/lat units to coordinate system units
 *
 * @param  lonLat ({@link MgCoordinate})  The {@link MgCoordinate} in lon/lat units
 * @return  The converted {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate ConvertFromLonLat(MgCoordinate lonLat) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_0(swigCPtr, MgCoordinate.getCPtr(lonLat));
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in coordinate system units to lon/lat units
 *
 * @param  coordinate ({@link MgCoordinate})  The {@link MgCoordinate} in coordinate system units
 * @return  The converted {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate ConvertToLonLat(MgCoordinate coordinate) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coordinate));
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the given value in coordinate system units to meters
 *
 * @param  units (double)  The value in coordinate system units
 * @return  The converted value in meters
 */
 public double ConvertCoordinateSystemUnitsToMeters(double units) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_ConvertCoordinateSystemUnitsToMeters(swigCPtr, units);
  }

  
/**
 * Converts the given value in meters to coordinate system units
 *
 * @param  meters (double)  The value in meters
 * @return  The converted value in coordinate system unit
 */
 public double ConvertMetersToCoordinateSystemUnits(double meters) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_ConvertMetersToCoordinateSystemUnits(swigCPtr, meters);
  }

  
/**
 * Measures the euclidean distance between two coordinates in coordinate system units.
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The euclidean distance from coord1 to coord2 in coordinate system units.
 */
 public double MeasureEuclideanDistance(MgCoordinate coord1, MgCoordinate coord2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_MeasureEuclideanDistance__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Measures the euclidean distance between (x1, y1) and (x2, y2) in coordinate system units.
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The euclidean distance from (x1, y1) to (x2, y2) in coordinate system units.
 */
 public double MeasureEuclideanDistance(double x1, double y1, double x2, double y2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_MeasureEuclideanDistance__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Measures the great circle distance between two coordinates in coordinate system units
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The great circle distance from coord1 to coord2 in coordinate system units
 */
 public double MeasureGreatCircleDistance(MgCoordinate coord1, MgCoordinate coord2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_MeasureGreatCircleDistance__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Measures the distance between two coordinates (x1, y1) and (x2, y2) in coordinate system units
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The great circle distance from (x1, y1) to (x2, y2) in coordinate system units
 */
 public double MeasureGreatCircleDistance(double x1, double y1, double x2, double y2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_MeasureGreatCircleDistance__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Gets the angle with respect to North of a vector formed by two coordinates
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The azimuth (Angle with respect to North) of the vector formed by coord1 and coord2
 */
 public double GetAzimuth(MgCoordinate coord1, MgCoordinate coord2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetAzimuth__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Gets the angle with respect to North of a vector formed by two coordinate
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The azimuth (Angle with respect to the North) of the vector formed by (x1, y1) and (x2, y2)
 */
 public double GetAzimuth(double x1, double y1, double x2, double y2) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetAzimuth__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Computes a coordinate a given distance along a vector that is defined by a starting coordinate and an azimuth (Angle with respect to North).
 *
 * @param  coord ({@link MgCoordinate})  An {@link MgCoordinate} object in coordinate system  units that represents the start of the  vector.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  An {@link MgCoordinate} that lies the given distance along the vector.
 */
 public MgCoordinate GetCoordinate(MgCoordinate coord, double azimuth, double distance) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetCoordinate__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord), azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Computes a coordinate a given distance along a vector that is defined by a starting (x, y) coordinate and an azimuth (Angle with respect to North).
 *
 * @param  xStart (double)  The x value in coordinate system units of the  starting coordinate.
 * @param  yStart (double)  The y value in coordinate system units of the  starting coordinate.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  An {@link MgCoordinate} that lies the given distance along the vector.
 */
 public MgCoordinate GetCoordinate(double xStart, double yStart, double azimuth, double distance) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetCoordinate__SWIG_1(swigCPtr, xStart, yStart, azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the OGC WKT string representation of the coordinate system.
 *
 * @return  The OGC WKT string.
 */
 public String ToString() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_ToString(swigCPtr); }
}

  
/**
 * Gets the coordinate system units
 *
 * @return  The coordinate system units string
 */
 public String GetUnits() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetUnits(swigCPtr); }
}

  
/**
 * Gets the factor used to convert coordinate system units to meters
 *
 * @return  The factor used to convert coordinate system units to meters
 */
 public double GetUnitScale() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetUnitScale(swigCPtr);
  }

  
/**
 * Gets the minimum X value.
 *
 * @return  The coordinate system minimum X value
 */
 public double GetMinX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetMinX(swigCPtr);
  }

  
/**
 * Gets the minimum Y value.
 *
 * @return  The coordinate system minimum Y value
 */
 public double GetMinY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetMinY(swigCPtr);
  }

  
/**
 * Gets the maximum X value
 *
 * @return  The coordinate system maximum X value
 */
 public double GetMaxX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetMaxX(swigCPtr);
  }

  
/**
 * Gets the maximum Y value
 *
 * @return  The coordinate system maximum Y value
 */
 public double GetMaxY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetMaxY(swigCPtr);
  }

  
/**
 * Returns the CS-Map coordinate system code
 *
 * @return  The CS-Map coordinate system code
 */
 public String GetCsCode() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetCsCode(swigCPtr); }
}

  
/**
 * Returns the description of this coordinate system
 *
 * @return  The description of this coordinate system
 */
 public String GetDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetDescription(swigCPtr); }
}

  
/**
 * Returns the projection of this coordinate system
 *
 * @return  The projection of this coordinate system
 */
 public String GetProjection() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetProjection(swigCPtr); }
}

  
/**
 * Returns the projection description of this coordinate system
 *
 * @return  The projection description of this coordinate system
 */
 public String GetProjectionDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetProjectionDescription(swigCPtr); }
}

  
/**
 * Returns the datum of this coordinate system
 *
 * @return  The coordinate system datum string
 */
 public String GetDatum() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetDatum(swigCPtr); }
}

  
/**
 * Returns the datum description of this coordinate system
 *
 * @return  The datum description string of this coordinate system
 */
 public String GetDatumDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetDatumDescription(swigCPtr); }
}

  
/**
 * Returns the ellipsoid of this coordinate system
 *
 * @return  The ellipsoid string of this coordinate system
 */
 public String GetEllipsoid() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetEllipsoid(swigCPtr); }
}

  
/**
 * Returns the ellipsoid description of this coordinate system
 *
 * @return  The ellipsoid description string of this coordinate system
 */
 public String GetEllipsoidDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetEllipsoidDescription(swigCPtr); }
}

  public int GetEpsgCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetEpsgCode(swigCPtr);
  }

  public int GetSridCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetSridCode(swigCPtr);
  }

  public short GetEpsgQuadrant() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetEpsgQuadrant(swigCPtr);
  }

  
/**
 * Gets the measure object of this coordinate system
 *
 * @return  The {@link MgCoordinateSystemMeasure} object of this coordinate system
 * @since  2.0 */
 public MgCoordinateSystemMeasure GetMeasure() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetMeasure(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemMeasure)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the categories of this coordinate system
 *
 * @return  The {@link MgStringCollection} containing the cateogories for this coordinate system
 */
 public MgStringCollection GetCategories() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetCategories(swigCPtr);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the associated coordinate system catalog for this coordinate system
 *
 * @return  The associated {@link MgCoordinateSystemCatalog} object
 */
 public MgCoordinateSystemCatalog GetCatalog() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetCatalog(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemCatalog)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the CS-Map coordinate system code for this coordinate system
 *
 * @param  sCode (String/string)  The CS-Map coordinate system code
 */
 public void SetCsCode(String sCode) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetCsCode(swigCPtr, sCode);
  }

  
/**
 * Checks whether the given CS-Map coordinate system code is a legal one
 *
 * @return  true if the given code is a legal one, false otherwise
 */
 public boolean IsLegalCsCode(String sCode) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalCsCode(swigCPtr, sCode);
  }

  
/**
 * Checks whether this coordinate system is a valid one
 *
 * @return  true if this coordinate system is a valid one. false otherwise
 */
 public boolean IsValid() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsValid(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public boolean IsUsable(MgCoordinateSystemCatalog pCatalog) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsUsable(swigCPtr, MgCoordinateSystemCatalog.getCPtr(pCatalog));
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public boolean IsSameAs(MgGuardDisposable pDef) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsSameAs(swigCPtr, MgGuardDisposable.getCPtr(pDef));
  }

  
/**
 * Sets the description of this coordinate system
 *
 * @param  sDesc (String/string)  The description of this coordinate system
 */
 public void SetDescription(String sDesc) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetDescription(swigCPtr, sDesc);
  }

  
/**
 * Checks whether this description is legal for this coordinate system
 *
 * @param  sDesc (String/string)  The description to check
 * @return  true if the given description is a legal one, false otherwise
 */
 public boolean IsLegalDescription(String sDesc) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalDescription(swigCPtr, sDesc);
  }

  
/**
 * Gets the group of this coordinate system
 *
 * @return  The group of this coordinate system
 */
 public String GetGroup() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this coordinate system
 *
 * @param  sGroup (String/string)  The group
 */
 public void SetGroup(String sGroup) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetGroup(swigCPtr, sGroup);
  }

  
/**
 * Checks whether this group is legal for this coordinate system
 *
 * @param  sGroup (String/string)  The group to check
 * @return  true if the given group is a legal one, false otherwise
 */
 public boolean IsLegalGroup(String sGroup) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalGroup(swigCPtr, sGroup);
  }

  
/**
 * Gets the source of this coordinate system
 *
 * @return  The source of this coordinate system
 */
 public String GetSource() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this coordinate system
 *
 * @param  sSource (String/string)  The source
 */
 public void SetSource(String sSource) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetSource(swigCPtr, sSource);
  }

  
/**
 * Checks whether this source is legal for this coordinate system
 *
 * @param  sSource (String/string)  The source to check
 * @return  true if the given source is a legal one, false otherwise
 */
 public boolean IsLegalSource(String sSource) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalSource(swigCPtr, sSource);
  }

  
/**
 * Checks whether this coordinate system is protected
 *
 * @return  true if this coordinate system is protected. false otherwise
 */
 public boolean IsProtected() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsProtected(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public short GetAge() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetAge(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void SetProtectMode(boolean bIsProtected) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetProtectMode(swigCPtr, bIsProtected);
  }

  
/**
 * Checks whether this coordinate system is encrypted
 *
 * @return  true if this coordinate system is encrypted. false otherwise
 */
 public boolean IsEncrypted() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsEncrypted(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void SetEncryptMode(boolean bIsEncrypted) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetEncryptMode(swigCPtr, bIsEncrypted);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public MgCoordinateSystemEnumInteger32 GetErrors() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetErrors(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemEnumInteger32)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the location of this coordinate system
 *
 * @return  The location of this coordinate system
 */
 public String GetLocation() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetLocation(swigCPtr); }
}

  
/**
 * Sets the location of this coordinate system
 *
 * @param  sLoc (String/string)  The location
 */
 public void SetLocation(String sLoc) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetLocation(swigCPtr, sLoc);
  }

  
/**
 * Checks whether this location is legal for this coordinate system
 *
 * @param  sLoc (String/string)  The location to check
 * @return  true if the given location is a legal one, false otherwise
 */
 public boolean IsLegalLocation(String sLoc) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalLocation(swigCPtr, sLoc);
  }

  
/**
 * Gets the country or state of this coordinate system
 *
 * @return  The country or state of this coordinate system
 */
 public String GetCountryOrState() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystem_GetCountryOrState(swigCPtr); }
}

  
/**
 * Sets the country or state of this coordinate system
 *
 * @param  sCountryOrState (String/string)  The country or state
 */
 public void SetCountryOrState(String sCountryOrState) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetCountryOrState(swigCPtr, sCountryOrState);
  }

  
/**
 * Checks whether this country or state is legal for this coordinate system
 *
 * @param  sCountryOrState (String/string)  The country or state to check
 * @return  true if the given country or state is a legal one, false otherwise
 */
 public boolean IsLegalCountryOrState(String sCountryOrState) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsLegalCountryOrState(swigCPtr, sCountryOrState);
  }

  
/**
 * Gets whether this coordinate system is geodetic
 *
 * @return  true if this coordinate system is geodetic. false otherwise
 */
 public boolean IsGeodetic() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsGeodetic(swigCPtr);
  }

  
/**
 * Gets the projection code of this coordinate system (see {@link MgCoordinateSystemProjectionCode})
 *
 * @return  The projection code of this coordinate system
 */
 public int GetProjectionCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetProjectionCode(swigCPtr);
  }

  
/**
 * Sets the projection code for this coordinate system
 *
 * @param  prjType (int)  The projection code (see {@link MgCoordinateSystemProjectionCode})
 */
 public void SetProjectionCode(int prjType) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetProjectionCode(swigCPtr, prjType);
  }

  
/**
 * Gets the unit code of this coordinate system
 *
 * @return  The unit code of this coordinate system
 */
 public int GetUnitCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetUnitCode(swigCPtr);
  }

  
/**
 * Sets the unit code for this coordinate system
 *
 * @param  unit (int)  The unit code
 */
 public void SetUnitCode(int unit) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetUnitCode(swigCPtr, unit);
  }

  
/**
 * Gets the projection parameter count of this coordinate system
 *
 * @return  The projection parameter count of this coordinate system
 */
 public int GetProjectionParameterCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetProjectionParameterCount(swigCPtr);
  }

  
/**
 * Gets the projection parameter count of this coordinate system at the specified index
 *
 * @param  nIndex (int)  The index at which to retrieve the projection parameter
 * @return  The projection parameter at the given index
 */
 public double GetProjectionParameter(int nIndex) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetProjectionParameter(swigCPtr, nIndex);
  }

  
/**
 * Sets the projection parameter of this coordinate system at the specified index
 *
 * @param  nIndex (int)  The index at which to set the projection parameter
 * @param  dValue (double)  The projection parameter value
 */
 public void SetProjectionParameter(int nIndex, double dValue) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetProjectionParameter(swigCPtr, nIndex, dValue);
  }

  
/**
 * Gets the origin longitude of this coordinate system
 *
 * @return  The origin longitude of this coordinate system
 */
 public double GetOriginLongitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetOriginLongitude(swigCPtr);
  }

  
/**
 * Sets the origin longitude for this coordinate system
 *
 * @param  dOrgLng (double)  The origin longitude
 */
 public void SetOriginLongitude(double dOrgLng) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetOriginLongitude(swigCPtr, dOrgLng);
  }

  
/**
 * Gets the origin latitude of this coordinate system
 *
 * @return  The origin latitude of this coordinate system
 */
 public double GetOriginLatitude() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetOriginLatitude(swigCPtr);
  }

  
/**
 * Sets the origin latitude for this coordinate system
 *
 * @param  dOrgLat (double)  The origin latitude
 */
 public void SetOriginLatitude(double dOrgLat) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetOriginLatitude(swigCPtr, dOrgLat);
  }

  
/**
 * Gets the X offset of this coordinate system
 *
 * @return  The X offset of this coordinate system
 */
 public double GetOffsetX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetOffsetX(swigCPtr);
  }

  
/**
 * Gets the Y offset of this coordinate system
 *
 * @return  The Y offset of this coordinate system
 */
 public double GetOffsetY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetOffsetY(swigCPtr);
  }

  
/**
 * Sets the X and Y offsets for this coordinate system
 *
 * @param  dXOffset (double)  The X offset
 * @param  dYOffset (double)  The Y offset
 */
 public void SetOffsets(double dXOffset, double dYOffset) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetOffsets(swigCPtr, dXOffset, dYOffset);
  }

  
/**
 * Gets the scale reduction of this coordinate system
 *
 * @return  The scale reduction of this coordinate system
 */
 public double GetScaleReduction() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetScaleReduction(swigCPtr);
  }

  
/**
 * Sets the scale reduction for this coordinate system
 *
 * @param  dSclRed (double)  The scale reduction
 */
 public void SetScaleReduction(double dSclRed) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetScaleReduction(swigCPtr, dSclRed);
  }

  
/**
 * Gets the map scale for this coordinate system
 *
 * @return  The map scale for this coordinate system
 */
 public double GetMapScale() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetMapScale(swigCPtr);
  }

  
/**
 * Sets the map scale for this coordinate system
 *
 * @param  dMapScale (double)  The map scale
 */
 public void SetMapScale(double dMapScale) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetMapScale(swigCPtr, dMapScale);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetZeroX() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetZeroX(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetZeroY() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetZeroY(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void SetZeroes(double dXZero, double dYZero) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetZeroes(swigCPtr, dXZero, dYZero);
  }

  
/**
 * Returns this system's minimum longitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double GetLonMin() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetLonMin(swigCPtr);
  }

  
/**
 * Returns this system's maximum longitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double GetLonMax() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetLonMax(swigCPtr);
  }

  
/**
 * Returns this system's minimum latitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double GetLatMin() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetLatMin(swigCPtr);
  }

  
/**
 * Returns this system's maximum latitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double GetLatMax() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetLatMax(swigCPtr);
  }

  
/**
 * Allows to set the min/max longitude and latitude values in degrees this coordinate system is valid in.
 * This method must only be called on systems that are not protected.
 * When setting these values, the coordinate system API will perform the following actions:
 * <ol>
 * <li>(Re-)enable valid range checking: When converting coordinates, the values are checked to fall
 *     in the valid range as specified here</li>
 * <li>Save the values for later storage: When eventually writing this coordinate system to the
 *     dictionary, the values will be written, too.</li>
 * </ol>
 *
 * @param  dLonMin  The minimum longitude value
 * @param  dLatMin  The minimum latitude value
 * @param  dLonMax  The maximum longitude value
 * @param  dLatMax  The maximum latitude value
 * @return  Nothing
 */
 public void SetLonLatBounds(double dLonMin, double dLatMin, double dLonMax, double dLatMax) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetLonLatBounds(swigCPtr, dLonMin, dLatMin, dLonMax, dLatMax);
  }

  
/**
 * Cancels only the range checking for coordinate transformations, if it has been enabled
 * via SetLonLatBounds before. Specifically, calling this method does not reset the
 * min/max values on the coordinate system definition itself. That is, when eventually writing
 * this object to the dictionary, the min/max values will be written, too.
 *
 * @return  Nothing
 */
 public void CancelLonLatBounds() throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_CancelLonLatBounds(swigCPtr);
  }

  
/**
 * Allows to set the min/max X and Y values in the coordinate system's units that this coordinate system is valid in.
 * This method must only be called on systems that are not protected.
 * When setting these values, the coordinate system API will perform the following actions:
 * <ol>
 * <li>(Re-)enable valid range checking: When converting coordinates, the values are checked to fall
 *     in the valid range as specified here</li>
 * <li>Save the values for later storage: When eventually writing this coordinate system to the
 *     dictionary, the values will be written, too.</li>
 * </ol>
 *
 * @param  dXMin  The minimum X value
 * @param  dYMin  The minimum Y value
 * @param  dXMax  The maximum X value
 * @param  dYMax  The maximum Y value
 * @return  Nothing
 */
 public void SetXYBounds(double dXMin, double dYMin, double dXMax, double dYMax) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetXYBounds(swigCPtr, dXMin, dYMin, dXMax, dYMax);
  }

  
/**
 * Cancels only the range checking for coordinate transformations, if it has been enabled via
 * SetXYBounds
 *
 */
 public void CancelXYBounds() throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_CancelXYBounds(swigCPtr);
  }

  
/**
 * Gets the quadrant for this coordinate system
 *
 * @return  The quadrant for this coordinate system
 */
 public short GetQuadrant() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetQuadrant(swigCPtr);
  }

  
/**
 * Sets the quadrant for this coordinate system
 *
 * @param  sQuad (short/int)  The quadrant
 */
 public void SetQuadrant(short sQuad) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetQuadrant(swigCPtr, sQuad);
  }

  
/**
 * Gets the datum definition for this coordinate system
 *
 * @return  The datum definition for this coordinate system
 */
 public MgCoordinateSystemDatum GetDatumDefinition() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetDatumDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the datum for this coordinate system
 *
 * @param  pDatum ({@link MgCoordinateSystemDatum})  The datum definition
 */
 public void SetDatumDefinition(MgCoordinateSystemDatum pDatum) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetDatumDefinition(swigCPtr, MgCoordinateSystemDatum.getCPtr(pDatum));
  }

  
/**
 * Gets the ellipsoid for this coordinate system
 *
 * @return  The ellipsoid for this coordinate system
 */
 public MgCoordinateSystemEllipsoid GetEllipsoidDefinition() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_GetEllipsoidDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemEllipsoid)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the ellipsoid definition for this coordinate system
 *
 * @param  pEllipsoid ({@link MgCoordinateSystemEllipsoid})  The ellipsoid definition
 */
 public void SetEllipsoidDefinition(MgCoordinateSystemEllipsoid pEllipsoid) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_SetEllipsoidDefinition(swigCPtr, MgCoordinateSystemEllipsoid.getCPtr(pEllipsoid));
  }

  
/**
 * Gets the given X and Y coordinates are valid within this coordinate system
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @return  true if the coordinates are valid. false otherwise
 */
 public boolean IsValidXY(double dX, double dY) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsValidXY(swigCPtr, dX, dY);
  }

  
/**
 * Gets the given longitude and latitude coordinates are valid within this coordinate system
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @return  true if the coordinates are valid. false otherwise
 */
 public boolean IsValidLonLat(double dLongitude, double dLatitude) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_IsValidLonLat(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in lon/lat units to coordinate system units
 *
 * @param  lonLatToCoordinate ({@link MgCoordinate})  The {@link MgCoordinate} in lon/lat units that will be converted
 */
 public void ConvertCoordinateFromLonLat(MgCoordinate lonLatToCoordinate) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_ConvertCoordinateFromLonLat(swigCPtr, MgCoordinate.getCPtr(lonLatToCoordinate));
  }

  
/**
 * Converts the specified {@link MgCoordinate} in coordinate system units to lon/lat units
 *
 * @param  coordinateToLonLat ({@link MgCoordinate})  The {@link MgCoordinate} in coordinate system units that will be converted
 */
 public void ConvertCoordinateToLonLat(MgCoordinate coordinateToLonLat) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystem_ConvertCoordinateToLonLat(swigCPtr, MgCoordinate.getCPtr(coordinateToLonLat));
  }

  
/**
 * Converts the specified coordinates in coordinate system units to lon/lat units
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @return  The {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate ConvertToLonLat(double dX, double dY) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_1(swigCPtr, dX, dY);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in coordinate system units to lon/lat units
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @param  dZ (double)  The Z coordinate
 * @return  The {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate ConvertToLonLat(double dX, double dY, double dZ) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_2(swigCPtr, dX, dY, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in lon/lat units to coordinate system units
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @return  The {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate ConvertFromLonLat(double dLongitude, double dLatitude) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_1(swigCPtr, dLongitude, dLatitude);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in lon/lat units to coordinate system units
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @param  dZ (double)  The Z coordinate
 * @return  The {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate ConvertFromLonLat(double dLongitude, double dLatitude, double dZ) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_2(swigCPtr, dLongitude, dLatitude, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetConvergence(double dLongitude, double dLatitude) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetConvergence(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetScale(double dLongitude, double dLatitude) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetScale(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetScaleH(double dLongitude, double dLatitude) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetScaleH(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double GetScaleK(double dLongitude, double dLatitude) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystem_GetScaleK(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * Gets a cloned copy of this coordinate system
 *
 * @return  The cloned copy of this coordinate system
 */
 public MgCoordinateSystem CreateClone() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystem_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
