/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Supports the creation of {@link MgCoordinateSystem} objects based on
 * a OpenGIS Well-Known Text (WKT) definition of the coordinate
 * system. This class is the main entry point for accessing assorted classes
 * and functionalities of the Coordinate System API
 *
 */
 public class MgCoordinateSystemFactory extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemFactory(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemFactoryToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemFactory(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemFactory obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgCoordinateSystemFactory} object.
 *
 */
 public MgCoordinateSystemFactory() throws MgException {
    this(MapGuideJavaApiJNI.new_MgCoordinateSystemFactory(), true);
  }

  
/**
 * Creates an {@link MgCoordinateSystem} instance given a definition of
 * the coordinate system in OpenGIS Well-Known Text (WKT)
 *
 * @param  wkt (String/string)  A string defining the coordinate system  in OpenGIS WKT format.
 * @return  Returns an {@link MgCoordinateSystem} instance that corresponds to
 *  the specified WKT definition.
 */
 public MgCoordinateSystem Create(String wkt) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_Create(swigCPtr, wkt);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the coordinate system catalog
 *
 * @return  Returns the {@link MgCoordinateSystemCatalog}
 */
 public MgCoordinateSystemCatalog GetCatalog() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetCatalog(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemCatalog)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Constructs a {@link MgCoordinateSystemTransform} that can be used to transform
 * coordinates from the source coordinate system to the target coordinate
 * system.
 *
 * @param  pSource ({@link MgCoordinateSystem})  The source coordinate system
 * @param  pTarget ({@link MgCoordinateSystem})  The target coordinate system
 * @return  The coordinate system transform that can be used to transform coordinates
 * @since  2.0 */
 public MgCoordinateSystemTransform GetTransform(MgCoordinateSystem pSource, MgCoordinateSystem pTarget) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetTransform(swigCPtr, MgCoordinateSystem.getCPtr(pSource), MgCoordinateSystem.getCPtr(pTarget));
    return (cPtr == 0) ? null : (MgCoordinateSystemTransform)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a {@link MgCoordinateSystem} object from the specified CS-Map coordinate
 * system code
 *
 * @param  code (String/string)  The CS-Map coordinate system code
 * @return  The coordinate system
 */
 public MgCoordinateSystem CreateFromCode(String code) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_CreateFromCode(swigCPtr, code);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the matching CS-Map coordinate system code based on the specified
 *
 * @param  wkt (String/string)  The coordinate system WKT string
 * @return  The CS-Map coordinate system code that corresponds to the specified WKT
 */
 public String ConvertWktToCoordinateSystemCode(String wkt) throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemFactory_ConvertWktToCoordinateSystemCode(swigCPtr, wkt); }
}

  
/**
 * Gets the matching coordinate system WKT based on the specified CS-Map
 * coordinate system code
 *
 * @param  code (String/string)  The CS-Map coordinate system code
 * @return  The coordinate system WKT string that corresponds to the specified CS-Map
 */
 public String ConvertCoordinateSystemCodeToWkt(String code) throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemFactory_ConvertCoordinateSystemCodeToWkt(swigCPtr, code); }
}

  
/**
 * Returns a list of the available coordinate system categories
 *
 * @return  A {@link MgStringCollection} containing the names of the available coordinate
 *  system categories
 */
 public MgStringCollection EnumerateCategories() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_EnumerateCategories(swigCPtr);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a {@link MgBatchPropertyCollection} containing the properties of each
 * coordinate system under the specified category
 *
 * @param  category (String/string)  The coordinate system category to enumerate
 * @return  A {@link MgBatchPropertyCollection} containing the properties of each coordinate system
 *  under the specified category
 */
 public MgBatchPropertyCollection EnumerateCoordinateSystems(String category) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_EnumerateCoordinateSystems(swigCPtr, category);
    return (cPtr == 0) ? null : (MgBatchPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the matching coordinate system WKT based on the specified EPSG code
 *
 * @param  code  The EPSG code
 * @return  The coordinate system WKT string that corresponds to the specified EPSG code
 */
 public String ConvertEpsgCodeToWkt(int code) throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemFactory_ConvertEpsgCodeToWkt(swigCPtr, code); }
}

  
/**
 * Gets the matching EPSG code based on the specified coordinate system WKT
 *
 * @param  wkt (String/string)
 * @return  The EPSG code that corresponds to the specified coordinate system WKT string
 */
 public int ConvertWktToEpsgCode(String wkt) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemFactory_ConvertWktToEpsgCode(swigCPtr, wkt);
  }

  
/**
 * Gets name of the underlying coordinate system library
 *
 * @return  Returns the name of the underlying coordinate system library
 */
 public String GetBaseLibrary() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetBaseLibrary(swigCPtr); }
}

  
/**
 * Gets whether the specified coordinate system WKT string is a valid one
 *
 * @param  wkt (String/string)
 * @return  Returns <b>true</b> if the specified WKT is valid. Returns <b>false</b> otherwise
 */
 public boolean IsValid(String wkt) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemFactory_IsValid(swigCPtr, wkt);
  }

  
/**
 * Constructs a grid boundary object.
 *
 * @param  southwest  The coordinates of the the southwest corner of a rectangular region  which represents the grid region.  This point <b>MUST</b> indeed be  southwest of the coordinate provided by the <c>northeast</c> parameter.
 * @param  northeast  The coordinates of the the northeast corner of a rectangular region  which represents the grid region.  This point <b>MUST</b> indeed be  northeast of the coordinate provided by the <c>southwest</c> parameter.
 * @return  Returns the grid boundary in the form used by the grid/graticule
 *  sub-system.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBoundary GridBoundary(MgCoordinate southwest, MgCoordinate northeast) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GridBoundary__SWIG_0(swigCPtr, MgCoordinate.getCPtr(southwest), MgCoordinate.getCPtr(northeast));
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBoundary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Constructs a grid boundary object.  Externally, grid objects are in
 * viewport coordinates and define the extents of the region within
 * which a grid is to be drawn.  Such objects are often simple
 * rectangles, but his is not a requirement.
 *
 * @param  boundary  The grid boundary in the form of a {@link MgPolygon} with no interior rings.
 * @return  Returns the boundary in the form used by the grid/graticule sub-system.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBoundary GridBoundary(MgPolygon boundary) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GridBoundary__SWIG_1(swigCPtr, MgPolygon.getCPtr(boundary));
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBoundary)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  public MgCoordinateSystemGridSpecification GridSpecification() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GridSpecification__SWIG_0(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridSpecification)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Constructs a grid specification object with all specifications set to
 * the values indicated by the supplied parameters.
 *
 * @param  increment  The distance between grid lines of a grid or graticule.  This value is  used for both the easting and northing grid lines; and the value must  be in the units specified by the <c>unitCode</c> parameter.
 * @param  tickIncrement  The distance between tick marks of a grid or graticule.  This value is  used for both the easting and northing tick marks; and the value must  be in the units specified by the <c>unitCode</c> parameter.
 * @param  unitCode  One of the values defined by the {@link MgCoordinateSystemUnitCode} object  which indicates the units in which the <c>increment</c>,  <c>tickIncrement</c>, and <c>curvePrecision</c> parameters are  specified.
 * @param  curvePrecision  In the units indicated by the <c>unitCode</c> parameter, the  <b>desired</b> maximum distance between the true complex curve and  the multi-segment approximation of the complex curve of any grid or  graticule line generated using this specification.
 * @return  A fully initialized grid specification object.
 * @exception  std::bad_alloc
 */
 public MgCoordinateSystemGridSpecification GridSpecification(double increment, double tickIncrement, int unitCode, double curvePrecision) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GridSpecification__SWIG_1(swigCPtr, increment, tickIncrement, unitCode, curvePrecision);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridSpecification)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Constructs a grid specification object with all specifications set to
 * the values indicated by the supplied parameters.
 *
 * @param  gridType  A value defined by the {@link MgCoordinateSystemGridSpecializationType} object  which indicates the Type of specialized grid desired.
 * @param  gridLevel  A value which indicates the density of the grid desired.  The exact  value of this parameter is dependent upon the value of the  <c>gridType</c> argument.  See Remarks below.
 * @return  Returns a fully initialized grid specification structure.
 * @exception  std::bad_alloc
 */
 public MgCoordinateSystemGridSpecification GridSpecification(int gridType, int gridLevel) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GridSpecification__SWIG_2(swigCPtr, gridType, gridLevel);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridSpecification)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures generic grid object.  A generic grid is one which simply
 * draws isolines of one coordinate system (the Grid coordinate system)
 * into the drawing space of another (the frame system).
 *
 * @param  sGridCs  The coordinate system code name of the grid coordinate system.
 * @param  sFrameCs  The coordinate system code name of the frame coordinate system.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on all  exceptional conditions.
 * @return  Returns a disposable pointer to the abstract interface class from which the
 *  generic grid object (and all other grid objects) derive.
 *  object derive.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBase GenericGrid(String sGridCs, String sFrameCs, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GenericGrid__SWIG_0(swigCPtr, sGridCs, sFrameCs, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures generic grid object.  A generic grid is one which simply
 * draws isolines of one coordinate system (the Grid coordinate system)
 * into the drawing space of another (the frame system).
 *
 * @param  pGridCs  The grid coordinate system.
 * @param  pFrameCs  The frame coordinate system.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on all  exceptional conditions.
 * @return  Returns a disposable pointer to the abstract interface class from which the
 *  generic grid object (and all other grid objects) derive.
 *  object derive.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBase GenericGrid(MgCoordinateSystem pGridCs, MgCoordinateSystem pFrameCs, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GenericGrid__SWIG_1(swigCPtr, MgCoordinateSystem.getCPtr(pGridCs), MgCoordinateSystem.getCPtr(pFrameCs), bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures an MGRS grid object.  The returned object is suitable only
 * for use in simple coordinate <-> MGRS string calculations.
 *
 * @param  dEquatorialRadius  Equatorial radius of the ellipsod upon which conversions to and from  MGRS strings are to be based.
 * @param  dEccentricity  Eccentricity of the ellipsod upon which conversions to and from  MGRS strings are to be based.
 * @param  nLetteringScheme  A value as defined in the {@link MgCoordinateSystemMgrsLetteringScheme}  object which specifies the lettering scheme to be used on MGRS  string conversions.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on coordinate  conversions which fail for any reason.
 * @return  Returns a disposable pointer to an {@link MgCoordinateSystemMgrs}
 *  object which is suitable <b>only</b> for MGRS string conversions.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemMgrs GetMgrs(double dEquatorialRadius, double dEccentricity, short nLetteringScheme, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetMgrs(swigCPtr, dEquatorialRadius, dEccentricity, nLetteringScheme, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemMgrs)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures an MGRS grid object.  The returned object is suitable only
 * for use in simple coordinate <-> MGRS string calculations.
 *
 * @param  sEllipsoidCode  Dictionary code name of the ellipsoid upon which conversions to and from  MGRS strings are to be based.
 * @param  nLetteringScheme  A value as defined in the {@link MgCoordinateSystemMgrsLetteringScheme}  object which specifies the lettering scheme to be used on MGRS  string conversions.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on coordinate  conversions which fail for any reason.
 * @return  Returns a disposable pointer to an {@link MgCoordinateSystemMgrs}
 *  object which is suitable <b>only</b> for MGRS string conversions.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemMgrs GetMgrsEllipsoid(String sEllipsoidCode, short nLetteringScheme, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetMgrsEllipsoid(swigCPtr, sEllipsoidCode, nLetteringScheme, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemMgrs)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures an MGRS grid object.  The returned object is suitable only
 * for use in simple coordinate <-> MGRS string calculations.
 *
 * @param  sDatumCode  Dictionary code name of the datum whose referenced ellipsoid is to be  used for all conversions to and from MGRS strings.
 * @param  nLetteringScheme  A value as defined in the {@link MgCoordinateSystemMgrsLetteringScheme}  object which specifies the lettering scheme to be used on MGRS  string conversions.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on coordinate  conversions which fail for any reason.
 * @return  Returns a disposable pointer to an {@link MgCoordinateSystemMgrs}
 *  object which is suitable <b>only</b> for MGRS string conversions.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemMgrs GetMgrsDatum(String sDatumCode, short nLetteringScheme, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_GetMgrsDatum(swigCPtr, sDatumCode, nLetteringScheme, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemMgrs)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures an MGRS grid object which is suitable for generating an
 * actual MGRS grid.
 *
 * @param  pFrameCs  The frame coordinate system.
 * @param  bUseFrameDatum  <c>true</c> causes the frame datum to be used for all geodetic calculations  neccessary to generate the grid; otherwise WGS84 is assumed.
 * @param  nLetteringScheme  A value as defined in the {@link MgCoordinateSystemMgrsLetteringScheme}  object which specifies the lettering scheme to be used on MGRS  string conversions.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on coordinate  conversions which fail for any reason. This applies only to MGRS string  conversions.
 * @return  Returns a disposable pointer to the abstract interface class from which the
 *  MGRS grid object (and all other grid objects) derive.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBase MgrsGrid(MgCoordinateSystem pFrameCs, boolean bUseFrameDatum, short nLetteringScheme, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_MgrsGrid__SWIG_0(swigCPtr, MgCoordinateSystem.getCPtr(pFrameCs), bUseFrameDatum, nLetteringScheme, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Manufactures an MGRS grid object which is suitable for generating an
 * actual MGRS grid.
 *
 * @param  sFrameCs  The dictionary code name of the frame coordinate system.
 * @param  bUseFrameDatum  <c>true</c> causes the frame datum to be used for all geodetic calculations  neccessary to generate the grid; otherwise WGS84 is assumed.
 * @param  nLetteringScheme  A value as defined in the {@link MgCoordinateSystemMgrsLetteringScheme}  object which specifies the lettering scheme to be used on MGRS  string conversions.
 * @param  bSetExceptionsOn  <c>true</c> indicates that exceptions are to be thrown on coordinate  conversions which fail for any reason. This applies only to MGRS string  conversions.
 * @return  Returns a disposable pointer to the abstract interface class from which the
 *  MGRS grid object (and all other grid objects) derive.
 * @exception  MgOutOfMemoryException
 */
 public MgCoordinateSystemGridBase MgrsGrid(String sFrameCs, boolean bUseFrameDatum, short nLetteringScheme, boolean bSetExceptionsOn) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemFactory_MgrsGrid__SWIG_1(swigCPtr, sFrameCs, bUseFrameDatum, nLetteringScheme, bSetExceptionsOn);
    return (cPtr == 0) ? null : (MgCoordinateSystemGridBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
