/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class holds all parameters that are specific to grid-file based transformation. That is,
 * where the actual datum shift value for a coordinate is determined by interpolating between grid point values
 * as defined in the respective grid file(s).
 *
 */
 public class MgCoordinateSystemGeodeticInterpolationTransformDefParams extends MgCoordinateSystemGeodeticTransformDefParams {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticInterpolationTransformDefParams(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemGeodeticInterpolationTransformDefParamsToMgCoordinateSystemGeodeticTransformDefParams(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticInterpolationTransformDefParams() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemGeodeticInterpolationTransformDefParams(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticInterpolationTransformDefParams obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Sets the grid files to be used by this transformation. See the description for
 * gridFiles parameter.
 *
 * @param  gridFiles  A (possibly empty) ordered(!) collection of {@link MgCoordinateSystemGeodeticTransformGridFile} objects.  The order of the elements contained in the collection is important, because this  instructs the underlying API in which order to use the grid files, e.g. in case of an overlap.
 */
 public void SetGridFiles(MgDisposableCollection gridFiles) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticInterpolationTransformDefParams_SetGridFiles(swigCPtr, MgDisposableCollection.getCPtr(gridFiles));
  }

  
/**
 * Returns an ordered, non-live collection {@link MgCoordinateSystemGeodeticTransformGridFile} elements
 * currently used by this parameter object. Changing the collection does NOT
 * have an affect on this parent parameter instance. Instead, any API client
 * has to modify the collection and then set it back via SetGridFiles.
 * The list returned can be an empty but will never be NULL.
 *
 */
 public MgDisposableCollection GetGridFiles() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticInterpolationTransformDefParams_GetGridFiles(swigCPtr);
    return (cPtr == 0) ? null : (MgDisposableCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the name of the transformation to fallback to in case the transformation using the
 * defined grid files doesn't succeed.
 *
 * @return  Returns the name of the fallback transformation. Can be empty if no such fallback transformation
 *  is defined.
 */
 public String GetFallback() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticInterpolationTransformDefParams_GetFallback(swigCPtr); }
}

  
/**
 * Sets the name of the transformation to fallback to, if the transformation could not
 * be performed using the grid files defined.
 *
 * @param  fallbackTransformation  Name of the transformation to fallback to.
 */
 public void SetFallback(String fallbackTransformation) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticInterpolationTransformDefParams_SetFallback(swigCPtr, fallbackTransformation);
  }

  
/**
 * Creates a new, empty {@link MgCoordinateSystemGeodeticTransformGridFile} object
 * that can be added to the collection set via SetGridFiles.
 *
 * @return  Returns a new, unitialized {@link MgCoordinateSystemGeodeticTransformGridFile} instance
 *  The caller is resonsible for disposing the object if no longer needed.
 */
 public MgCoordinateSystemGeodeticTransformGridFile NewGridFile() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticInterpolationTransformDefParams_NewGridFile(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformGridFile)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
