/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * A geodetic (transformation) path allows to concatenate multiple
 * geodetic transformations. For example, converting between 2 datums
 * cannot be achieved by doing 1 datum shift only but requires to
 * do 1 or more datums shifts in between.
 *
 */
 public class MgCoordinateSystemGeodeticPath extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticPath(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemGeodeticPathToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticPath() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemGeodeticPath(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticPath obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the path name of this geodetic path
 *
 * @return  The path name of this geodetic path
 */
 public String GetPathName() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetPathName(swigCPtr); }
}

  
/**
 * Sets the path name of this geodetic path
 *
 * @param  sName (String/string)  The path name
 */
 public void SetPathName(String sName) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetPathName(swigCPtr, sName);
  }

  
/**
 * Gets the description of this geodetic path
 *
 * @return  The description of this geodetic path
 */
 public String GetDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetDescription(swigCPtr); }
}

  
/**
 * Sets the description of this geodetic path
 *
 * @param  sDescription (String/string)  The description
 */
 public void SetDescription(String sDescription) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetDescription(swigCPtr, sDescription);
  }

  
/**
 * Gets the group of this geodetic path
 *
 * @return  The group of this geodetic path
 */
 public String GetGroup() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this geodetic path
 *
 * @param  sGroup (String/string)  The group
 */
 public void SetGroup(String sGroup) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetGroup(swigCPtr, sGroup);
  }

  
/**
 * Gets the source of this geodetic path
 *
 * @return  The source of this geodetic path
 */
 public String GetSource() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this geodetic path
 *
 * @param  sSource (String/string)  The source
 */
 public void SetSource(String sSource) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetSource(swigCPtr, sSource);
  }

  
/**
 * Gets the target datum of this geodetic path
 *
 * @return  The target datum of this geodetic path
 */
 public String GetTargetDatum() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetTargetDatum(swigCPtr); }
}

  
/**
 * Sets the target datum of this geodetic path
 *
 * @param  sTargetDatum (String/string)  The target datum
 */
 public void SetTargetDatum(String sTargetDatum) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetTargetDatum(swigCPtr, sTargetDatum);
  }

  
/**
 * Gets the source datum of this geodetic path
 *
 * @return  The source datum of this geodetic path
 */
 public String GetSourceDatum() throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetSourceDatum(swigCPtr); }
}

  
/**
 * Sets the source datum of this geodetic path
 *
 * @param  sSourceDatum (String/string)  The source datum
 */
 public void SetSourceDatum(String sSourceDatum) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetSourceDatum(swigCPtr, sSourceDatum);
  }

  
/**
 * Gets the accuracy of this geodetic path
 *
 * @return  The accuracy of this geodetic path
 */
 public double GetAccuracy() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetAccuracy(swigCPtr);
  }

  
/**
 * Sets the accuracy of this geodetic path
 *
 * @param  accuracy (String/string)  The accuracy
 */
 public void SetAccuracy(double accuracy) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetAccuracy(swigCPtr, accuracy);
  }

  
/**
 * Gets whether this geodetic path is reversible
 *
 * @return  true if this geodetic path is reversible
 */
 public boolean GetIsReversible() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetIsReversible(swigCPtr);
  }

  
/**
 * Sets whether this geodetic path is reversible
 *
 * @param  isReversible (boolean/bool)  true if reversible. false otherwise
 */
 public void SetIsReversible(boolean isReversible) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetIsReversible(swigCPtr, isReversible);
  }

  
/**
 * Gets the EPSG code of of this geodetic path
 *
 * @return  The EPSG code of this geodetic path
 */
 public int GetEpsgCode() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetEpsgCode(swigCPtr);
  }

  
/**
 * Sets the EPSG code of of this geodetic path
 *
 * @param  epsgCode (int)  the EPSG code
 */
 public void SetEpsgCode(int epsgCode) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetEpsgCode(swigCPtr, epsgCode);
  }

  
/**
 * Gets the EPSG variant of this geodetic path
 *
 * @return  The EPSG variant of this geodetic path
 */
 public int GetEpsgVariant() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetEpsgVariant(swigCPtr);
  }

  
/**
 * Sets the EPSG variant of of this geodetic path
 *
 * @param  epsgVariant (int)  the EPSG variant
 */
 public void SetEpsgVariant(int epsgVariant) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetEpsgVariant(swigCPtr, epsgVariant);
  }

  
/**
 * Returns an ordered collection of {@link MgCoordinateSystemGeodeticPathElement} objects
 * that form this geodetic transformation path. See remarks.
 *
 * @return  Returns a (possibly empty) collection of {@link MgCoordinateSystemGeodeticPathElement} instances.
 *  The caller is responsible for disposing the collection being returned.
 */
 public MgDisposableCollection GetPathElements() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_GetPathElements(swigCPtr);
    return (cPtr == 0) ? null : (MgDisposableCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the individual transformation steps that form this geodetic transformation
 * path.
 *
 */
 public void SetPathElements(MgDisposableCollection pathElements) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_SetPathElements(swigCPtr, MgDisposableCollection.getCPtr(pathElements));
  }

  
/**
 * Gets whether this geodetic path is protected
 *
 * @return  true if this geodetic path is protected. false otherwise
 */
 public boolean IsProtected() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_IsProtected(swigCPtr);
  }

  
/**
 * Gets whether this geodetic path is valid
 *
 * @return  true if this geodetic path is valid. false otherwise
 */
 public boolean IsValid() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_IsValid(swigCPtr);
  }

  
/**
 * Creates a new, unitialized {@link MgCoordinateSystemGeodeticPathElement} instance.
 * Calling this method does not affect the underlying dictionary file.
 * Typically, an API client will retrieve new objects through this method
 * so they can be added to the collection of path elements that can be set
 * via SetPathElements.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticPathElement} instance. The caller is responsible
 *  for disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticPathElement NewPathElement() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_NewPathElement(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPathElement)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a deep clone of this geodetic path. That is, the cloned object
 * will also have its geodetic path element information cloned.
 *
 * @return  Returns a new {@link MgCoordinateSystemGeodeticPath} object that is an exact clone
 *  of this {@link MgCoordinateSystemGeodeticPath} instance. The caller is responsible for
 *  disposing the object being returned.
 */
 public MgCoordinateSystemGeodeticPath CreateClone() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGeodeticPath_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPath)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
